/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */


package org.netbeans.server.uihandler;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.netbeans.modules.exceptions.utils.PersistenceUtils;
import org.netbeans.server.uihandler.CheckingFilter.WholeStackTraceFilter;
import org.netbeans.server.uihandler.CheckingFilter.LinesCheckingFilter;
import org.netbeans.server.uihandler.CheckingFilter.StackOverflowCheckingFilter;

/**
 *
 * @author Jindrich Sedek
 */
public final class Utils {
    public static final String EXCEPTIONS_URL=
            java.util.ResourceBundle.getBundle("org/netbeans/server/uihandler/Bundle").getString("EXCEPTIONS_URL");
    
    /** Creates a new instance of Utils */
    public Utils() {
    }
    
    public static org.netbeans.modules.exceptions.entity.Exceptions checkIssue(Throwable thrown){
        if (thrown == null) return null;
        org.netbeans.modules.exceptions.entity.Exceptions result = null;
        LinkedList<CheckingFilter> filters = new LinkedList<CheckingFilter>();
        filters.add(new WholeStackTraceFilter());
        filters.add(new LinesCheckingFilter(3));
        filters.add(new StackOverflowCheckingFilter());
        Iterator<CheckingFilter> iterator = filters.iterator();
        while ((result == null)&&(iterator.hasNext())){
            result = iterator.next().check(thrown);
        }
        if ((result != null)&&(result.getDuplicateof()!= null)){
            result = result.getDuplicateof();
        }
        return result;
    }
    
    public static int countHash(StackTraceElement[] throwable){
        if (throwable.length==0) return 0;
        String str = throwable[0].getClassName();
        str = str.concat(throwable[0].getMethodName());
        for (int i = 1; i < throwable.length; i++) {
            str = str.concat(throwable[i].getClassName());
            str = str.concat(throwable[i].getMethodName());
        }
        int result = str.hashCode();
        return result;
    }
    
    public static PersistenceUtils getPersistenceUtils(){
        return PersistenceUtils.getInstance();
    }
    
    //
    // Working with JNDI
    //
    
    static void printContext(String space, Context c) {
        try     {
            printContextImpl(space, c);
        } catch (NamingException ex) {
            org.openide.util.Exceptions.printStackTrace(ex);
        }
}
    private static void printContextImpl(String space, Context c) throws NamingException {
        if (c == null) {
            Context initCtx = new InitialContext();
            c = (Context) initCtx.lookup("java:comp/env"); // NOI18N
        }
        
        NamingEnumeration<NameClassPair> tips;
        tips = c.list("");
        while (tips.hasMore()) {
            NameClassPair pair = tips.next();
            
            Object o = c.lookup(pair.getName());
            if (pair.getClassName().indexOf("Context") >= 0) {
                if (o instanceof Context) {
                    LogsManager.LOG.fine("binding " + space + pair.getName() + " class: " + pair.getClassName());
                    printContext(space + pair.getName() + "/", (Context)o);
                    continue;
                }
            } 
            LogsManager.LOG.warning("  value " + space + pair.getName() + " = " + o);
        }
        
    }
    
    /**
     * Reads value for a variable defined in the "env-entry" section of web.xml
     *
     * @param name name of the variabl
     * @param type the expected type of the variable
     * @return value for the variable or null if there is no, or there is not the right type
     */
    public static <T> T getVariable(String name, Class<T> type) {
        try {
            Context initCtx = new InitialContext();
            Context c = (Context) initCtx.lookup("java:comp/env"); // NOI18N
            c = (Context)c.lookup("analytics"); // NOI18N
            return type.cast(c.lookup(name));
        } catch (NamingException ex) {
            LogsManager.LOG.log(Level.WARNING, "no env variable for " + name, ex);
            printContext("", null);
            return null;
        } catch (ClassCastException ex) {
            LogsManager.LOG.log(Level.WARNING, "wrong env variable for " + name + " we need " + type.getName(), ex);
            return null;
        }
    }
}
