/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 * 
 * Contributor(s):
 * 
 * Portions Copyrighted 2008 Sun Microsystems, Inc.
 */

package org.netbeans.modules.hibernate.completion;

import java.util.ArrayList;
import java.util.List;
import org.junit.Test;
import org.netbeans.spi.editor.completion.CompletionProvider;

/**
 *
 * @author dc151887
 */
public class HibernateMappingCompletionManagerTest extends HibernateCompletionTestBase {
    
    private static final String[] generatorClasses = new String[]{
            "increment", 
            "identity", 
            "sequence", 
            "hilo", 
            "seqhilo", 
            "uuid", 
            "guid", 
            "native", 
            "assigned",
            "select", 
            "foreign",
            "sequence-identity"
        };

    public HibernateMappingCompletionManagerTest(String name) {
        super(name);
    }

    /**
     * Test of completeAttributeValues method, of class HibernateMappingCompletionManager.
     */
    @Test
    public void testCompleteAttributeValues() throws Exception {
        System.out.println("completeAttributeValues");
        setupCompletion("resources/Person.hbm.xml", null);
        List<HibernateCompletionItem> items = query(314);
        String[] expectedResult = generatorClasses;
        assertResult(items, expectedResult);
    }

    /**
     * Test of completeAttributes method, of class HibernateMappingCompletionManager.
     */
    @Test
    public void testCompleteAttributes() {
        System.out.println("completeAttributes");
        // NOP
    }

    /**
     * Test of completeElements method, of class HibernateMappingCompletionManager.
     */
    @Test
    public void testCompleteElements() {
        System.out.println("completeElements");
        //NOP
    }
    
    private List<HibernateCompletionItem> query(int caretOffset) throws Exception {
        List<HibernateCompletionItem> completionItems = new ArrayList<HibernateCompletionItem>();
        assert(instanceDocument != null);
        HibernateMappingCompletionQuery instance = new HibernateMappingCompletionQuery(CompletionProvider.COMPLETION_QUERY_TYPE,
                caretOffset);
        instance.getCompletionItems(instanceDocument, caretOffset, completionItems);
        return completionItems;
    }

}