/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2007 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.java.source.tasklist;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.java.source.usages.RepositoryUpdater;
import org.openide.util.ChangeSupport;

/**
 *
 * @author Jan Lahoda
 */
public class TasklistOptionsPanel extends javax.swing.JPanel {
    
    private ChangeSupport cs;
    private Map<JCheckBox, String> compilerSettings;
    
    /** Creates new form TasklistOptionsPanel */
    public TasklistOptionsPanel() {
        cs = new ChangeSupport(this);
        initComponents();
        
//        if( "Windows".equals(UIManager.getLookAndFeel().getID()) ) //NOI18N
//            setOpaque( false );
        
    }
    
    void addChangeListener(ChangeListener l) {
        cs.addChangeListener(l);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        enableTasklist = new javax.swing.JCheckBox();
        enableDependencies = new javax.swing.JCheckBox();
        enableBadges = new javax.swing.JCheckBox();

        setBorder(javax.swing.BorderFactory.createEmptyBorder(8, 8, 8, 8));
        setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(enableTasklist, org.openide.util.NbBundle.getBundle(TasklistOptionsPanel.class).getString("jCheckBox1.text")); // NOI18N
        enableTasklist.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        enableTasklist.setMargin(new java.awt.Insets(0, 0, 0, 0));
        enableTasklist.setOpaque(false);
        enableTasklist.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                enableTasklistStateChanged(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 0);
        add(enableTasklist, gridBagConstraints);
        enableTasklist.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TasklistOptionsPanel.class, "ACD_EnableTaskList")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(enableDependencies, org.openide.util.NbBundle.getBundle(TasklistOptionsPanel.class).getString("jCheckBox2.text")); // NOI18N
        enableDependencies.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        enableDependencies.setMargin(new java.awt.Insets(0, 0, 0, 0));
        enableDependencies.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 8, 0);
        add(enableDependencies, gridBagConstraints);
        enableDependencies.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TasklistOptionsPanel.class, "ACD_EnableDependencies")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(enableBadges, org.openide.util.NbBundle.getBundle(TasklistOptionsPanel.class).getString("jCheckBox1.text_1")); // NOI18N
        enableBadges.setBorder(javax.swing.BorderFactory.createEmptyBorder(0, 0, 0, 0));
        enableBadges.setMargin(new java.awt.Insets(0, 0, 0, 0));
        enableBadges.setOpaque(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.gridheight = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 8, 0);
        add(enableBadges, gridBagConstraints);
        enableBadges.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TasklistOptionsPanel.class, "ACD_EnableErrorBadges")); // NOI18N

        getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(TasklistOptionsPanel.class, "ACN_TaskListOptionsPanel")); // NOI18N
        getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(TasklistOptionsPanel.class, "ACD_TaskListOptionsPanel")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

private void enableTasklistStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_enableTasklistStateChanged
    // TODO add your handling code here:
    updateEnabled();
}//GEN-LAST:event_enableTasklistStateChanged
    
    //XXX: shoudl fire changes
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JCheckBox enableBadges;
    private javax.swing.JCheckBox enableDependencies;
    private javax.swing.JCheckBox enableTasklist;
    // End of variables declaration//GEN-END:variables
    
    public void setTasklistEnabled(boolean enabled) {
        enableTasklist.setSelected(enabled);
        updateEnabled();
    }
    
    public void setDependenciesEnabled(boolean enabled) {
        enableDependencies.setSelected(enabled);
    }
    
    public void setBadgesEnabled(boolean enabled) {
        enableBadges.setSelected(enabled);
    }
    
    public boolean getTasklistEnabled() {
        return enableTasklist.isSelected();
    }

    public boolean getDependenciesEnabled() {
        return enableDependencies.isSelected();
    }

    public boolean getBadgesEnabled() {
        return enableBadges.isSelected();
    }

    private void updateEnabled() {
        enableDependencies.setEnabled(enableTasklist.isSelected());
        enableBadges.setEnabled(enableTasklist.isSelected());
    }
    
//    public void fillInCompilerSettings() {
//        Preferences p = CompilerSettings.getNode();
//        
//        for (Entry<JCheckBox, String> e : compilerSettings.entrySet()) {
//            e.getKey().setSelected(CompilerSettings.get(p, e.getValue()));
//        }
//        
//        updateCompilerSettingsEnabled();
//    }
//    
    
//    public boolean isCompilerSettingsChanged() {
//        Preferences p = CompilerSettings.getNode();
//
//        for (Entry<JCheckBox, String> e : compilerSettings.entrySet()) {
//            if (e.getKey().isSelected() != CompilerSettings.get(p, e.getValue()))
//                return true;
//        }
//
//        return false;
//    }
//
//    public void storeCompilerSettings() {
//        
//        Preferences p = CompilerSettings.getNode();
//        
//        for (Entry<JCheckBox, String> e : compilerSettings.entrySet()) {
//            p.putBoolean(e.getValue(), e.getKey().isSelected());
//        }
//        RepositoryUpdater.getDefault().rebuildAll(false);
//    }
    
}
