/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2009 Sun Microsystems, Inc.
 */

/*
 * HistoryPanel.java
 *
 * Created on 7.1.2009, 16:21:02
 */

package org.netbeans.modules.debugger.jpda.ui;

import java.awt.GridBagConstraints;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import org.openide.util.NbBundle;

/**
 *
 * @author Dan
 */
public class HistoryPanel extends javax.swing.JPanel {

    transient private HistoryTableModel historyModel = new HistoryTableModel();
    private HistoryTable historyTable = new HistoryTable();

    HistoryPanel() {
        initComponents();

        GridBagConstraints constr = new java.awt.GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 2;
        constr.fill = GridBagConstraints.HORIZONTAL;
        constr.insets = new java.awt.Insets(0, 3, 0, 0);
        JTableHeader tableHeader = historyTable.getTableHeader();
        tableHeader.setFocusable(false);
        add(tableHeader, constr);

        constr = new GridBagConstraints();
        constr.gridx = 0;
        constr.gridy = 3;
        constr.fill = java.awt.GridBagConstraints.BOTH;
        constr.weightx = 1.0;
        constr.weighty = 1.0;
        constr.insets = new java.awt.Insets(0, 3, 0, 0);
        add(historyTable, constr);

        historyTable.setModel(historyModel);
    }

    public void addItem(final String expr, final String type, final String value, final String toString) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                historyModel.addItem(expr, type, value, toString);
            }
        });
    }

    public void clearHistory() {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
                historyModel.clearHistory();
            }
        });
    }

    public ArrayList<Item> getHistoryItems() {
        return historyModel.getHistory();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        historyLabel = new javax.swing.JLabel();
        separatorPanel = new javax.swing.JPanel();

        setLayout(new java.awt.GridBagLayout());

        historyLabel.setText(org.openide.util.NbBundle.getMessage(HistoryPanel.class, "HistoryPanel.historyLabel.text")); // NOI18N
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        add(historyLabel, gridBagConstraints);

        separatorPanel.setBackground(javax.swing.UIManager.getDefaults().getColor("Separator.foreground"));
        separatorPanel.setPreferredSize(new java.awt.Dimension(10, 1));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        add(separatorPanel, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel historyLabel;
    private javax.swing.JPanel separatorPanel;
    // End of variables declaration//GEN-END:variables

    // ..........................................................................

    public class Item {

        public String expr;
        public String type;
        public String value;
        public String toString;
        public String tooltip;
        public String exprFormatted;

        Item(String expr, String type, String value, String toString) {
            this.expr = expr;
            this.type = type;
            this.value = value;
            this.toString = toString;
            StringBuffer buf = new StringBuffer();
            buf.append("<html>");
            String text = expr.replaceAll ("&", "&amp;");
            text = text.replaceAll ("<", "&lt;");
            text = text.replaceAll (">", "&gt;");
            text = text.replaceAll ("\n", "<br/>");
            text = text.replaceAll ("\r", "");
            buf.append(text);
            buf.append("</html>");
            this.tooltip = buf.toString();
        }

        Vector toVector() {
            Vector result = new Vector();
            result.add(expr);
            result.add(type);
            result.add(value);
            result.add(toString);
            return result;
        }

        @Override
        public String toString() {
            return expr;
        }

    }

    class HistoryTable extends JTable {

        HistoryTable() {
            setBackground(javax.swing.UIManager.getDefaults().getColor("Button.background"));
            setGridColor(javax.swing.UIManager.getDefaults().getColor("Button.light"));
        }

        @Override
        public String getToolTipText(MouseEvent e) {
            java.awt.Point p = e.getPoint();
            int rowIndex = rowAtPoint(p);
            int colIndex = columnAtPoint(p);
            if (rowIndex < 0 || colIndex < 0) {
                return super.getToolTipText(e);
            }
            int realColumnIndex = convertColumnIndexToModel(colIndex);
            if (realColumnIndex < 0) {
                return super.getToolTipText(e);
            }
            TableModel model = getModel();
            String value = (String)model.getValueAt(rowIndex, realColumnIndex);
            value = value.replace("\n", "<br/>"); // NOI18N
            return "<html>" + value + "</html>"; // NOI18N
        }

    }

    class HistoryTableModel extends DefaultTableModel {

        private static final int MAX_ITEMS = 100;

        private ArrayList<Item> historyItems = new ArrayList<Item>();

        private void addItem(String expr, String type, String value, String toString) {
            Item item = new Item(expr, type, value, toString);
            historyItems.add(0, item);
            if (historyItems.size() > MAX_ITEMS) {
                historyItems.remove(MAX_ITEMS);
            }
            fireTableDataChanged();
        }

        public ArrayList<Item> getHistory() {
            return historyItems;
        }

        public void clearHistory() {
            historyItems.clear();
            fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            if (historyItems == null) {
                historyItems = new ArrayList<Item>();
            }
            return historyItems.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public String getColumnName(int columnIndex) {
            String id = null;
            switch (columnIndex) {
                case 0: id = "CTL_Expression"; break;
                case 1: id = "CTL_Type"; break;
                case 2: id = "CTL_Value"; break;
            }
            return NbBundle.getMessage (HistoryPanel.class, id);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex >= historyItems.size()) {
                return "<???>"; // NOI18N
            }
            Item item = historyItems.get(rowIndex);
            switch (columnIndex) {
                case 0:
                    return item.expr;
                case 1:
                    return item.type;
                case 2:
                    return item.value;
            }
            return "<???>"; // NOI18N
        }

    }

}
