/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2009 Sun Microsystems, Inc.
 */

package org.netbeans.modules.kenai.ui;

import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.layout.LayoutStyle;
import org.netbeans.modules.kenai.api.KenaiService;
import org.netbeans.modules.kenai.ui.NewKenaiProjectWizardIterator.SharedItem;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

/**
 *
 * @author Maros Sandor
 */
public class SummaryWizardPanelGUI extends javax.swing.JPanel {

    private SummaryWizardPanel panel;

    public SummaryWizardPanelGUI(SummaryWizardPanel pnl) {
        panel = pnl;
        initComponents();
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(SummaryWizardPanelGUI.class,
                "SummaryWizardPanelGUI.panelName"); // NOI18N
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {






        jLabel1 = new JLabel();
        projectCreatedLabel = new JLabel();
        commitedLabel = new JLabel();
        projectURL = new JLabel();
        repoURL = new JLabel();
        jScrollPane1 = new JScrollPane();
        commitedItems = new JList();
        issueTrackingLabel = new JLabel();
        chatroomLabel = new JLabel();
        repoLabel = new JLabel();
        commitPrepareLabel = new JLabel();
        tobeSharedLabel = new JLabel();
        projectsMoveLabel = new JLabel();
        localRoot = new JLabel();
        Mnemonics.setLocalizedText(jLabel1, NbBundle.getMessage(SummaryWizardPanelGUI.class, "SummaryWizardPanelGUI.jLabel1.text")); // NOI18N
        Mnemonics.setLocalizedText(projectCreatedLabel, NbBundle.getMessage(SummaryWizardPanelGUI.class, "SummaryWizardPanelGUI.projectCreatedLabel.text"));
        Mnemonics.setLocalizedText(commitedLabel, NbBundle.getMessage(SummaryWizardPanelGUI.class, "SummaryWizardPanelGUI.commitedLabel.text"));
        Mnemonics.setLocalizedText(projectURL, NbBundle.getMessage(SummaryWizardPanelGUI.class, "SummaryWizardPanelGUI.projectURL.text"));
        Mnemonics.setLocalizedText(repoURL, NbBundle.getMessage(SummaryWizardPanelGUI.class, "SummaryWizardPanelGUI.repoURL.text"));
        jScrollPane1.setViewportView(commitedItems);




        Mnemonics.setLocalizedText(issueTrackingLabel, NbBundle.getMessage(SummaryWizardPanelGUI.class, "SummaryWizardPanelGUI.issueTrackingLabel.text")); // NOI18N
        Mnemonics.setLocalizedText(chatroomLabel, NbBundle.getMessage(SummaryWizardPanelGUI.class, "SummaryWizardPanelGUI.chatroomLabel.text"));
        Mnemonics.setLocalizedText(repoLabel, NbBundle.getMessage(SummaryWizardPanelGUI.class, "SummaryWizardPanelGUI.repoLabel.text"));
        Mnemonics.setLocalizedText(commitPrepareLabel, NbBundle.getMessage(SummaryWizardPanelGUI.class, "SummaryWizardPanelGUI.commitPrepareLabel.text"));
        tobeSharedLabel.setLabelFor(commitedItems);



        Mnemonics.setLocalizedText(tobeSharedLabel, NbBundle.getMessage(SummaryWizardPanelGUI.class, "SummaryWizardPanelGUI.tobeSharedLabel.text")); // NOI18N
        Mnemonics.setLocalizedText(projectsMoveLabel, NbBundle.getMessage(SummaryWizardPanelGUI.class, "SummaryWizardPanelGUI.projectsMoveLabel.text"));
        Mnemonics.setLocalizedText(localRoot, NbBundle.getMessage(SummaryWizardPanelGUI.class, "SummaryWizardPanelGUI.localRoot.text"));
        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(24, 24, 24)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(projectURL, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 472, Short.MAX_VALUE)
                    .add(localRoot, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 472, Short.MAX_VALUE)
                    .add(repoURL, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 472, Short.MAX_VALUE))
                .addContainerGap())
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(issueTrackingLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 484, Short.MAX_VALUE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(commitedLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 484, Short.MAX_VALUE)
                .addContainerGap())
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(commitPrepareLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 484, Short.MAX_VALUE)
                .addContainerGap())
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(projectsMoveLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 484, Short.MAX_VALUE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(24, 24, 24)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 472, Short.MAX_VALUE)
                .add(12, 12, 12))
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(tobeSharedLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 484, Short.MAX_VALUE)
                .addContainerGap())
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(projectCreatedLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 484, Short.MAX_VALUE)
                    .add(jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 484, Short.MAX_VALUE))
                .addContainerGap())
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(chatroomLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 484, Short.MAX_VALUE)
                .addContainerGap())
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(repoLabel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 484, Short.MAX_VALUE)
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabel1)
                .add(18, 18, 18)
                .add(projectCreatedLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(projectURL)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(tobeSharedLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 77, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(projectsMoveLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(localRoot)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(repoLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(commitPrepareLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(commitedLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(repoURL)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(issueTrackingLabel)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(chatroomLabel)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        getAccessibleContext().setAccessibleName(NbBundle.getMessage(SummaryWizardPanelGUI.class, "SourceAndIssuesWizardPanelGUI.AccessibleContext.accessibleName")); // NOI18N
        getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(SummaryWizardPanelGUI.class, "SourceAndIssuesWizardPanelGUI.AccessibleContext.accessibleDescription")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private JLabel chatroomLabel;
    private JLabel commitPrepareLabel;
    private JList commitedItems;
    private JLabel commitedLabel;
    private JLabel issueTrackingLabel;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JLabel localRoot;
    private JLabel projectCreatedLabel;
    private JLabel projectURL;
    private JLabel projectsMoveLabel;
    private JLabel repoLabel;
    private JLabel repoURL;
    private JLabel tobeSharedLabel;
    // End of variables declaration//GEN-END:variables

    @Override
    public void addNotify() {
        super.addNotify();
        panel.fireChangeEvent();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.putClientProperty(NewKenaiProjectWizardIterator.PROP_EXC_ERR_MSG, null);
    }

    public void read(WizardDescriptor settings) {
        projectCreatedLabel.setText(NbBundle.getMessage(SummaryWizardPanelGUI.class, "SummaryWizardPanelGUI.projectCreatedLabel.text",
                settings.getProperty(NewKenaiProjectWizardIterator.PROP_PRJ_TITLE),
                settings.getProperty(NewKenaiProjectWizardIterator.PROP_PRJ_LICENSE))
        );
        projectURL.setText("<html><b>" + NameAndLicenseWizardPanelGUI.getPreviewPrefix() + settings.getProperty(NewKenaiProjectWizardIterator.PROP_PRJ_NAME)+"</b></html>");

        boolean autoCommit = Boolean.valueOf((String) settings.getProperty(NewKenaiProjectWizardIterator.PROP_AUTO_COMMIT));
        commitedLabel.setText(NbBundle.getMessage(SummaryWizardPanelGUI.class, "SummaryWizardPanelGUI.commitedLabel.text",
                settings.getProperty(NewKenaiProjectWizardIterator.PROP_SCM_TYPE)));
        repoLabel.setText(NbBundle.getMessage(SummaryWizardPanelGUI.class, "SummaryWizardPanelGUI.repoLabel.text",
                settings.getProperty(NewKenaiProjectWizardIterator.PROP_SCM_TYPE)));
        commitPrepareLabel.setText(NbBundle.getMessage(SummaryWizardPanelGUI.class, "SummaryWizardPanelGUI.commitPrepareLabel.text",
                settings.getProperty(NewKenaiProjectWizardIterator.PROP_SCM_TYPE)));

        repoURL.setText("<html><b>" + settings.getProperty(NewKenaiProjectWizardIterator.PROP_SCM_PREVIEW) + "</b></html>");

        List<SharedItem> sharedItems = (List<SharedItem>) settings.getProperty(NewKenaiProjectWizardIterator.PROP_FOLDERS_TO_SHARE);
        commitedItems.setListData(sharedItems.toArray(new SharedItem[sharedItems.size()]));

        String  scmType = (String) settings.getProperty(NewKenaiProjectWizardIterator.PROP_SCM_TYPE);
        boolean scmCreated = KenaiService.Names.SUBVERSION.equals(scmType) || KenaiService.Names.MERCURIAL.equals(scmType);

        commitPrepareLabel.setVisible(sharedItems.size() > 0 && !autoCommit && scmCreated);
        commitedLabel.setVisible(sharedItems.size() > 0 && autoCommit && scmCreated);
        repoLabel.setVisible(sharedItems.size() == 0 && scmCreated);
        jScrollPane1.setVisible(sharedItems.size() > 0 && scmCreated);
        tobeSharedLabel.setVisible(sharedItems.size() > 0 && scmCreated);

        String newPrjScmLocal = (String) settings.getProperty(NewKenaiProjectWizardIterator.PROP_SCM_LOCAL);
        boolean inPlaceRepository = NewKenaiProjectWizardIterator.isCommonParent(sharedItems, newPrjScmLocal);
        projectsMoveLabel.setVisible(!inPlaceRepository && scmCreated);
        if (sharedItems.size()==0) {
            Mnemonics.setLocalizedText(projectsMoveLabel, NbBundle.getMessage(SummaryWizardPanelGUI.class, "SummaryWizardPanelGUI.projectsMoveLabelNoSelection.text"));
        }
        localRoot.setVisible(!inPlaceRepository && scmCreated);
        localRoot.setText("<html><b>"+newPrjScmLocal+"</b></html>"); // NOI18N

        String issues = (String) settings.getProperty(NewKenaiProjectWizardIterator.PROP_ISSUES);
        issueTrackingLabel.setVisible(KenaiService.Names.BUGZILLA.equals(issues) || KenaiService.Names.JIRA.equals(issues));

        repoURL.setVisible(scmCreated);

        validate();
    }

    public void store(WizardDescriptor settings) {
    }
}
