/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.profiler.attach.panels;

import java.awt.Font;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.util.NbBundle;

/**
 *
 * @author  Jaroslav Bachorik
 */
public class RemoteAttachSettingsPanelUI extends javax.swing.JPanel implements DocumentListener {
  private final String HOSTOS_HEADER = NbBundle.getMessage(this.getClass(), "TargetSettingsWizardPanelUI_SelectHostOsString"); // NOI18N

  private class HostOsComboBoxModel extends DefaultComboBoxModel {
    public HostOsComboBoxModel() {
      super();
    }
    public HostOsComboBoxModel(Vector list) {
      super(list);
      this.insertElementAt(HOSTOS_HEADER, 0);
      this.fireIntervalAdded(this, 0, 0);
      this.setSelectedItem(this.getElementAt(0));
    }
    public HostOsComboBoxModel(Object[] objects) {
      super(objects);
      this.insertElementAt(HOSTOS_HEADER, 0);
    }
    public void setSelectedItem(Object anObject) {
      if (getElementAt(0).equals(HOSTOS_HEADER)) {
        removeElementAt(0);
        this.fireIntervalRemoved(this, 0, 0);
      }
      super.setSelectedItem(anObject);
    }
  }
  private RemoteAttachSettingsPanel.Model model;
  private HostOsComboBoxModel comboModel;
  
  /**
   * Creates new form RemoteAttachSettingsPanelUI
   */
  public RemoteAttachSettingsPanelUI(RemoteAttachSettingsPanel.Model model) {
    this.model = model; // MUST be the first statement in constructor
    comboModel = new HostOsComboBoxModel(model.getAvailableOsList());
    initComponents();
    
    this.model.setRemoteOs((String)comboHostOs.getSelectedItem());
  }
  
  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        hintPanel = new org.netbeans.modules.profiler.attach.panels.components.ResizableHintPanel();
        jPanel2 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        textHostname = new javax.swing.JTextField();
        jLabel3 = new javax.swing.JLabel();
        comboHostOs = new javax.swing.JComboBox();
        jPanel1 = new javax.swing.JPanel();

        setMaximumSize(new java.awt.Dimension(800, 600));
        setPreferredSize(new java.awt.Dimension(500, 400));

        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("org/netbeans/modules/profiler/attach/panels/Bundle"); // NOI18N
        hintPanel.setHint(bundle.getString("TargetSettingsWizardPanelUI_RemotePacksHelpString")); // NOI18N
        hintPanel.setMinimumSize(new java.awt.Dimension(0, 0));

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder(org.openide.util.NbBundle.getMessage(RemoteAttachSettingsPanelUI.class, "TargetSettingsWizardPanelUI_ProvideRemoteConfigString"))); // NOI18N

        jLabel2.setLabelFor(textHostname);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, bundle.getString("TargetSettingsWizardPanelUI_HostNameString")); // NOI18N

        textHostname.getDocument().addDocumentListener(this);
        textHostname.setPreferredSize(new java.awt.Dimension(200, 24));
        textHostname.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                textHostnameKeyTyped(evt);
            }
        });

        jLabel3.setLabelFor(comboHostOs);
        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, bundle.getString("TargetSettingsWizardPanelUI_HostOsString")); // NOI18N

        comboHostOs.setModel(getHostOsModel());
        comboHostOs.setMaximumSize(new java.awt.Dimension(250, 19));
        comboHostOs.setMinimumSize(new java.awt.Dimension(160, 19));
        comboHostOs.setPreferredSize(new java.awt.Dimension(200, 24));
        comboHostOs.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                comboHostOsActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel2Layout = new org.jdesktop.layout.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, comboHostOs, 0, 440, Short.MAX_VALUE)
                    .add(textHostname, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 440, Short.MAX_VALUE)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jLabel2)
                    .add(org.jdesktop.layout.GroupLayout.LEADING, jLabel3))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel2Layout.createSequentialGroup()
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(textHostname, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jLabel3)
                .add(10, 10, 10)
                .add(comboHostOs, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        textHostname.getAccessibleContext().setAccessibleDescription("null");
        comboHostOs.getAccessibleContext().setAccessibleDescription("null");

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 500, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 60, Short.MAX_VALUE)
        );

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addContainerGap())
            .add(org.jdesktop.layout.GroupLayout.TRAILING, hintPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 500, Short.MAX_VALUE)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(hintPanel, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        hintPanel.getAccessibleContext().setAccessibleName("null");
    }// </editor-fold>//GEN-END:initComponents
  
    private void comboHostOsActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_comboHostOsActionPerformed
      this.model.setRemoteOs(comboHostOs.getSelectedItem().toString());
    }//GEN-LAST:event_comboHostOsActionPerformed
    
    private void textHostnameKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_textHostnameKeyTyped
          }//GEN-LAST:event_textHostnameKeyTyped
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox comboHostOs;
    private org.netbeans.modules.profiler.attach.panels.components.ResizableHintPanel hintPanel;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JTextField textHostname;
    // End of variables declaration//GEN-END:variables
  
  public ComboBoxModel getHostOsModel() {
    return comboModel;
  }
  
  public void removeUpdate(DocumentEvent e) {
    this.model.setRemoteHost(textHostname.getText());
  }
  
  public void insertUpdate(DocumentEvent e) {
    this.model.setRemoteHost(textHostname.getText());
  }
  
  public void changedUpdate(DocumentEvent e) {
    this.model.setRemoteHost(textHostname.getText());
  }
  
  public void refresh() {
    if (model.getRemoteOs() != null)
      comboHostOs.setSelectedItem(model.getRemoteOs());
    textHostname.setText(model.getRemoteHost());
  }
}
