/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.api.java.source.support;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePathScanner;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 *
 * @author Jan Lahoda
 */
public class CancellableTreePathScanner<R,P> extends TreePathScanner<R,P> {

    private final AtomicBoolean internalCanceled;
    private final AtomicBoolean canceled;

    /**Construct a new CancellableTreePathScanner which can be canceled by calling
     * the {@link #cancel} method.
     */
    public CancellableTreePathScanner() {
        this(null);
    }

    /**Construct a new CancellableTreePath Scanner which can be canceled either by calling
     * the {@link #cancel} method, or by setting <code>true</code> into the provided
     * <code>canceled</code> {@link AtomicBoolean}.
     * 
     * @param canceled an {@link AtomicBoolean} through which this scanner can be canceled.
     *                 The scanner never changes the state of the {@link AtomicBoolean}.
     * @since 0.29
     */
    public CancellableTreePathScanner(AtomicBoolean canceled) {
        this.canceled = canceled;
        
        this.internalCanceled = new AtomicBoolean();
    }

    protected boolean isCanceled() {
        return internalCanceled.get() || (canceled != null && canceled.get());
    }

    public void cancel() {
        internalCanceled.set(true);
    }

    /** @inheritDoc
     */
    public R scan(Tree tree, P p) {
        if (isCanceled())
            return null;
        
        return super.scan(tree, p);
    }

    /** @inheritDoc
     */
    public R scan(Iterable<? extends Tree> trees, P p) {
        if (isCanceled())
            return null;
        
        return super.scan(trees, p);
    }

}
