/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2009 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2008 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */

package org.netbeans.modules.subversion.ui.repository;

import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import static org.jdesktop.layout.LayoutStyle.RELATED;
import static org.jdesktop.layout.GroupLayout.BASELINE;
import static org.jdesktop.layout.GroupLayout.DEFAULT_SIZE;
import static org.jdesktop.layout.GroupLayout.LEADING;
import static org.jdesktop.layout.GroupLayout.PREFERRED_SIZE;

/**
 *
 * @author  Petr Kuzel
 */
public class HttpPanel extends JPanel {

    /** Creates new form RepositoryPanel */
    public HttpPanel() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold desc="UI Layout Code" defaultstate="collapsed">
    private void initComponents() {

        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/subversion/ui/repository/Bundle"); // NOI18N
        setName(bundle.getString("BK2018")); // NOI18N
        setVerifyInputWhenFocusTarget(false);

        userTextField.setColumns(10);
        userPasswordField.setColumns(10);

        userLabel.setLabelFor(userTextField);
        passwordLabel.setLabelFor(userPasswordField);

        Mnemonics.setLocalizedText(userLabel, NbBundle.getMessage(HttpPanel.class, "BK0003")); // NOI18N
        userLabel.setToolTipText(NbBundle.getMessage(HttpPanel.class, "TT_UserName")); // NOI18N

        Mnemonics.setLocalizedText(passwordLabel, NbBundle.getMessage(HttpPanel.class, "BK0004")); // NOI18N
        passwordLabel.setToolTipText(NbBundle.getMessage(HttpPanel.class, "TT_Password")); // NOI18N

        leaveBlankLabel.setText(NbBundle.getMessage(HttpPanel.class, "BK0005")); // NOI18N

        savePasswordCheckBox.setMnemonic('v');
        savePasswordCheckBox.setText(NbBundle.getMessage(HttpPanel.class, "BK0007")); // NOI18N
        savePasswordCheckBox.setMargin(new java.awt.Insets(0, 0, 0, 0));

        /* ----------- SSL panel ------------ */

        sslPanel.setVerifyInputWhenFocusTarget(false);

        certFileTextField.setColumns(30);
        certPasswordField.setColumns(10);

        certFileLabel.setLabelFor(certFileTextField);
        certPasswordLabel.setLabelFor(certPasswordField);

        Mnemonics.setLocalizedText(browseButton, NbBundle.getMessage(HttpPanel.class, "HttpPanel.browseButton.text")); // NOI18N
        browseButton.setToolTipText(NbBundle.getMessage(HttpPanel.class, "HttpPanel.browseButton.toolTipText")); // NOI18N

        Mnemonics.setLocalizedText(certFileLabel, NbBundle.getMessage(HttpPanel.class, "HttpPanel.certFileLabel.text")); // NOI18N
        certFileLabel.setToolTipText(NbBundle.getMessage(HttpPanel.class, "HttpPanel.certFileLabel.toolTipText")); // NOI18N

        Mnemonics.setLocalizedText(certPasswordLabel, NbBundle.getMessage(HttpPanel.class, "HttpPanel.certPasswordLabel.text")); // NOI18N
        certPasswordLabel.setToolTipText(NbBundle.getMessage(HttpPanel.class, "HttpPanel.certPasswordLabel.toolTipText")); // NOI18N

        GroupLayout sslPanelLayout = new GroupLayout(sslPanel);
        sslPanel.setLayout(sslPanelLayout);
        sslPanelLayout.setHorizontalGroup(
                sslPanelLayout.createSequentialGroup()
                    .add(sslPanelLayout.createParallelGroup(LEADING)
                            .add(certFileLabel)
                            .add(certPasswordLabel))
                    .addPreferredGap(RELATED)
                    .add(sslPanelLayout.createParallelGroup(LEADING)
                            .add(sslPanelLayout.createSequentialGroup()
                                    .add(certFileTextField, DEFAULT_SIZE, DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addPreferredGap(RELATED)
                                    .add(browseButton))
                            .add(certPasswordField, PREFERRED_SIZE, DEFAULT_SIZE, PREFERRED_SIZE))
        );
        sslPanelLayout.setVerticalGroup(
                sslPanelLayout.createParallelGroup(LEADING)
                .add(sslPanelLayout.createSequentialGroup()
                        .add(sslPanelLayout.createParallelGroup(BASELINE)
                                .add(certFileLabel)
                                .add(certFileTextField, PREFERRED_SIZE, DEFAULT_SIZE, PREFERRED_SIZE)
                                .add(browseButton))
                        .addPreferredGap(RELATED)
                        .add(sslPanelLayout.createParallelGroup(BASELINE)
                                .add(certPasswordLabel)
                                .add(certPasswordField, PREFERRED_SIZE, DEFAULT_SIZE, PREFERRED_SIZE)))
        );

        certPasswordField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HttpPanel.class, "HttpPanel.certPasswordField.AccessibleContext.accessibleName")); // NOI18N
        certPasswordField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HttpPanel.class, "HttpPanel.certPasswordField.AccessibleContext.accessibleDescription")); // NOI18N
        certFileTextField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HttpPanel.class, "HttpPanel.certFileTextField.AccessibleContext.accessibleName")); // NOI18N
        certFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HttpPanel.class, "HttpPanel.certFileTextField.AccessibleContext.accessibleDescription")); // NOI18N
        browseButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(HttpPanel.class, "HttpPanel.proxySettingsButton1.AccessibleContext.accessibleName")); // NOI18N

        /* ----------- end of SSL panel ------------ */

        Mnemonics.setLocalizedText(proxySettingsButton, NbBundle.getMessage(HttpPanel.class, "BK0006")); // NOI18N
        proxySettingsButton.setToolTipText(NbBundle.getMessage(HttpPanel.class, "ACSD_ProxyDialog")); // NOI18N

        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
                layout.createParallelGroup(LEADING)
                .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(LEADING)
                                .add(userLabel)
                                .add(passwordLabel))
                        .addPreferredGap(RELATED)
                        .add(layout.createParallelGroup(LEADING)
                                .add(layout.createSequentialGroup()
                                        .add(layout.createParallelGroup(LEADING, false)
                                                .add(userPasswordField)
                                                .add(userTextField))
                                        .addPreferredGap(RELATED)
                                        .add(leaveBlankLabel))
                                .add(savePasswordCheckBox)))
                .add(sslPanel, DEFAULT_SIZE, DEFAULT_SIZE, Short.MAX_VALUE)
                .add(proxySettingsButton)
        );
        layout.setVerticalGroup(
                layout.createParallelGroup(LEADING)
                .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(BASELINE)
                                .add(userLabel)
                                .add(userTextField, PREFERRED_SIZE, DEFAULT_SIZE, PREFERRED_SIZE)
                                .add(leaveBlankLabel))
                        .addPreferredGap(RELATED)
                        .add(layout.createParallelGroup(BASELINE)
                                .add(passwordLabel)
                                .add(userPasswordField, PREFERRED_SIZE, DEFAULT_SIZE, PREFERRED_SIZE))
                        .addPreferredGap(RELATED)
                        .add(savePasswordCheckBox)
                        .add(18)
                        .add(sslPanel, PREFERRED_SIZE, DEFAULT_SIZE, PREFERRED_SIZE)
                        .addPreferredGap(RELATED)
                        .add(proxySettingsButton))
        );

        userPasswordField.getAccessibleContext().setAccessibleParent(this);
        passwordLabel.getAccessibleContext().setAccessibleParent(this);
        userLabel.getAccessibleContext().setAccessibleParent(this);
        userTextField.getAccessibleContext().setAccessibleParent(this);
        leaveBlankLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HttpPanel.class, "ACSD_InfoLabel")); // NOI18N
        leaveBlankLabel.getAccessibleContext().setAccessibleParent(this);
        savePasswordCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HttpPanel.class, "BK0011")); // NOI18N
        proxySettingsButton.getAccessibleContext().setAccessibleParent(this);

        getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(HttpPanel.class, "ACSD_RepositoryPanel")); // NOI18N
    }// </editor-fold>
        
    // Variables declaration
    final JButton browseButton = new JButton();
    final JTextField certFileTextField = new JTextField();
    final JPasswordField certPasswordField = new JPasswordField();
    final JLabel leaveBlankLabel = new JLabel();
    final JLabel passwordLabel = new JLabel();
    final JButton proxySettingsButton = new JButton();
    final JCheckBox savePasswordCheckBox = new JCheckBox();
    final JPanel sslPanel = new JPanel();
    final JLabel userLabel = new JLabel();
    final JLabel certFileLabel = new JLabel();
    final JLabel certPasswordLabel = new JLabel();
    final JPasswordField userPasswordField = new JPasswordField();
    final JTextField userTextField = new JTextField();
    // End of variables declaration

}
