/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 *
 * Contributor(s):
 *
 * Portions Copyrighted 2010 Sun Microsystems, Inc.
 */

/*
 * ResolveTreeConflictPanel.java
 *
 * Created on Nov 26, 2010, 2:17:25 PM
 */

package org.netbeans.modules.git.ui.conflicts;

import java.io.File;
import org.netbeans.libs.git.GitConflictDescriptor.Type;
import org.openide.util.NbBundle;

/**
 *
 * @author ondra
 */
public class ResolveTreeConflictPanel extends javax.swing.JPanel {

    /** Creates new form ResolveTreeConflictPanel */
    public ResolveTreeConflictPanel (File file, Type conflictType) {
        initComponents();
        lblFile.setText(NbBundle.getMessage(ResolveTreeConflictPanel.class, "MSG_ResolveTreeConflictPanel.file.text", file.getName()));
        lblFileStatus.setText(NbBundle.getMessage(ResolveTreeConflictPanel.class, "MSG_ResolveTreeConflictPanel.fileStatus.text", conflictType.getDescription()));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        lblFile = new javax.swing.JLabel();
        lblFileStatus = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();

        org.openide.awt.Mnemonics.setLocalizedText(lblFile, org.openide.util.NbBundle.getMessage(ResolveTreeConflictPanel.class, "ResolveTreeConflictPanel.lblFile.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(lblFileStatus, org.openide.util.NbBundle.getMessage(ResolveTreeConflictPanel.class, "ResolveTreeConflictPanel.lblFileStatus.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, org.openide.util.NbBundle.getMessage(ResolveTreeConflictPanel.class, "ResolveTreeConflictPanel.jLabel1.text")); // NOI18N

        buttonGroup1.add(rbRemove);
        org.openide.awt.Mnemonics.setLocalizedText(rbRemove, org.openide.util.NbBundle.getMessage(ResolveTreeConflictPanel.class, "ResolveTreeConflictPanel.rbRemove.text")); // NOI18N
        rbRemove.setToolTipText(org.openide.util.NbBundle.getMessage(ResolveTreeConflictPanel.class, "ResolveTreeConflictPanel.rbRemove.TTtext")); // NOI18N

        buttonGroup1.add(rbAdd);
        org.openide.awt.Mnemonics.setLocalizedText(rbAdd, org.openide.util.NbBundle.getMessage(ResolveTreeConflictPanel.class, "ResolveTreeConflictPanel.rbAdd.text")); // NOI18N
        rbAdd.setToolTipText(org.openide.util.NbBundle.getMessage(ResolveTreeConflictPanel.class, "ResolveTreeConflictPanel.rbAdd.toolTipText")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblFile)
                    .addComponent(lblFileStatus)
                    .addComponent(jLabel1)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(rbAdd)
                            .addComponent(rbRemove))))
                .addContainerGap(8, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(lblFile)
                .addGap(18, 18, 18)
                .addComponent(lblFileStatus)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(rbRemove)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(rbAdd)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel lblFile;
    private javax.swing.JLabel lblFileStatus;
    final javax.swing.JRadioButton rbAdd = new javax.swing.JRadioButton();
    final javax.swing.JRadioButton rbRemove = new javax.swing.JRadioButton();
    // End of variables declaration//GEN-END:variables

}
