/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * Oracle and Java are registered trademarks of Oracle and/or its affiliates.
 * Other names may be trademarks of their respective owners.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2006 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.modules.javaee.wildfly.ide.ui;

import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openide.util.NbBundle;


/**
 *
 * @author Ivan Sidorkin
 */
public class AddServerPropertiesVisualPanel extends JPanel {

    private final Set listeners = new HashSet();

    private javax.swing.JComboBox  domainField;  // Domain name (list of registered domains) can be edited
    private javax.swing.JTextField domainPathField;  //
    private javax.swing.JLabel     domainLabel;
    private javax.swing.JLabel     domainPathLabel;
    private javax.swing.JLabel     label1;
    private javax.swing.JPanel     panel1;
    private javax.swing.JLabel     hostLabel;
    private javax.swing.JTextField hostField;
    private javax.swing.JLabel     portLabel;
    private javax.swing.JTextField portField;
    private javax.swing.JLabel     userLabel;
    private javax.swing.JTextField userField;
    private javax.swing.JLabel     passwordLabel;
    private javax.swing.JPasswordField passwordField;
    private javax.swing.JComboBox  serverType;  // Local or Remote


    /** Creates a new instance of AddServerPropertiesVisualPanel */
    public AddServerPropertiesVisualPanel() {
        init();
        setName(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "TITLE_ServerProperties")); //NOI18N
    }

    public void addChangeListener(ChangeListener l) {
        synchronized (listeners) {
            listeners.add(l);
        }
    }

    public void removeChangeListener(ChangeListener l ) {
        synchronized (listeners) {
            listeners.remove(l);
        }
    }

    private void somethingChanged() {
        fireChangeEvent();
    }

    private void fireChangeEvent() {
        Iterator it;
        synchronized (listeners) {
            it = new HashSet(listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(ev);
        }
    }

    public boolean isLocalServer(){
        return  ("Local".equals(serverType.getSelectedItem()));
    }

    public String getHost(){
        return hostField.getText().trim();
    }

    public String getPort(){
        return portField.getText().trim();
    }

    public String getUser(){
        return userField.getText();
    }

    public String getPassword(){
        return new String(passwordField.getPassword());
    }

    public String getDomainPath(){
        return domainPathField.getText();
    }

    public String getDomain(){
        return (String)domainField.getSelectedItem();
    }

    private void domainChanged(){
        DomainComboModel model = (DomainComboModel)domainField.getModel();
        String path = model.getCurrentPath();
        domainPathField.setText(path);
        portField.setText(WildflyPluginUtils.getHTTPConnectorPort(path));
        fireChangeEvent();
    }

    void installLocationChanged() {
        DomainComboModel domainModel = (DomainComboModel) domainField.getModel();
        String serverLocation = WildflyPluginProperties.getInstance().getInstallLocation();
        domainModel.setDomains(WildflyPluginUtils.getRegisteredDomains(serverLocation));
        String configLocation = WildflyPluginProperties.getInstance().getConfigLocation();
        File domainDir = new File(configLocation).getParentFile().getParentFile();
        if(domainModel.hasDomain(domainDir.getName())) {
            domainModel.setSelectedItem(domainDir.getName());
        } else {
            domainModel.addDomain(domainDir.getName(), domainDir.getAbsolutePath());
        }
        domainChanged();
    }

    private void serverTypeChanged(){

        if (isLocalServer()){  //NOI18N
            domainLabel.setVisible(true);
            domainField.setVisible(true);

            domainPathLabel.setVisible(true);
            domainPathField.setVisible(true);

            hostField.setEditable(true);
        } else {  // REMOTE

            domainLabel.setVisible(false);
            domainField.setVisible(false);

            domainPathLabel.setVisible(false);
            domainPathField.setVisible(false);

            hostField.setEditable(true);
        }

        somethingChanged();
    }

    private void init(){
        java.awt.GridBagConstraints gridBagConstraints;

        label1 = new JLabel(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "TXT_PROPERTY_TEXT")); //NOI18N

        serverType = new JComboBox(new String[]{"Local","Remote"});//NOI18N
        serverType.addActionListener(new ActionListener(){
            @Override
            public void actionPerformed(ActionEvent e) {
                serverTypeChanged();
            }
        });


        domainPathLabel = new JLabel(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "LBL_DomainPath"));//NOI18N
        domainPathField = new JTextField();
        domainPathField.setColumns(20);
        domainPathField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "LBL_DomainPath"));
        domainPathField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "LBL_DomainPath"));


        panel1 = new JPanel();

        //Domain combobox
        domainLabel = new JLabel();
        String serverLocation = WildflyPluginProperties.getInstance().getInstallLocation();
        domainField = new JComboBox(new DomainComboModel(WildflyPluginUtils.getRegisteredDomains(serverLocation)));
        domainField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "LBL_Domain"));
        domainField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "LBL_Domain"));

        domainField.addActionListener(new ActionListener(){
            public void actionPerformed(ActionEvent e) {
                domainChanged();
            }
        });

        domainLabel.setLabelFor(domainField);
        org.openide.awt.Mnemonics.setLocalizedText(domainLabel, org.openide.util.NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "LBL_Domain")); // NOI18N

        hostLabel = new JLabel();
        org.openide.awt.Mnemonics.setLocalizedText(hostLabel, NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "LBL_Host")); // NOI18N

        hostField = new JTextField();
        hostField.setColumns(20);
        hostField.setEditable(true);
        hostField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "LBL_Host"));
        hostField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "LBL_Host"));
        hostField.addKeyListener(new SomeChangesListener());

        hostLabel.setLabelFor(hostField);

        portLabel = new JLabel();
        org.openide.awt.Mnemonics.setLocalizedText(portLabel, NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "LBL_Port")); // NOI18N

        portField = new JTextField();
        portField.setColumns(20);
        portField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "LBL_Port"));
        portField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "LBL_Port"));
        //portField.setEditable(false);
        portField.addKeyListener(new SomeChangesListener());

        portLabel.setLabelFor(portField);

        userLabel = new JLabel(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "LBL_User"));//NOI18N
        userField = new JTextField();
        userField.addKeyListener(new SomeChangesListener());

        passwordLabel = new JLabel(NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "LBL_Password"));//NOI18N
        passwordField = new JPasswordField();
        passwordField.addKeyListener(new SomeChangesListener());


        setLayout(new java.awt.GridBagLayout());

        setFocusable(false);

        setMinimumSize(new java.awt.Dimension(280, 217));
       //   setNextFocusableComponent(domainPathField);


        //-------------- some label --------------------
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 5);
        add(label1, gridBagConstraints);



        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 5);

        add(serverType, gridBagConstraints);


        //-------------- domain ---------------
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 5);
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        add(domainLabel, gridBagConstraints);


        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 5);
        add(domainField, gridBagConstraints);




        //-------------- domain path ---------------
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 5);
        add(domainPathLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 5);
        add(domainPathField, gridBagConstraints);

        //-------------- host ---------------
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 5);
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        add(hostLabel, gridBagConstraints);


        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 5);
        add(hostField, gridBagConstraints);


        //-------------- port ---------------
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 0);
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        add(portLabel, gridBagConstraints);


        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 5);
        add(portField, gridBagConstraints);


        //-------------- User ---------------
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 5);
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        add(userLabel, gridBagConstraints);


        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 5);
        add(userField, gridBagConstraints);



        //-------------- Password ---------------
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 5);
        gridBagConstraints.anchor = GridBagConstraints.WEST;
        add(passwordLabel, gridBagConstraints);


        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 12, 5);
        add(passwordField, gridBagConstraints);

        //-------------  panell to fill out free space ------------------------
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;


        domainPathField.setEnabled(false);

        userField.setVisible(false);
        userLabel.setVisible(false);
        passwordField.setVisible(false);
        passwordLabel.setVisible(false);


        serverType.setVisible(false);

        add(panel1, gridBagConstraints);

        hostField.setText("localhost");//NOI18N
        portField.setText(WildflyPluginUtils.getHTTPConnectorPort(domainPathField.getText()));//NOI18N
    //    serverTypeChanged();
        domainChanged();

    }


    class SomeChangesListener implements KeyListener{

        @Override
        public void keyTyped(KeyEvent e){}

        @Override
        public void keyPressed(KeyEvent e){}

        @Override
        public void keyReleased(KeyEvent e){ somethingChanged();}

    }

    private String browseDomainLocation(){
        String insLocation = null;
        JFileChooser chooser = getJFileChooser();
        int returnValue = chooser.showDialog(this, NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "LBL_ChooseButton")); //NOI18N

        if(returnValue == JFileChooser.APPROVE_OPTION){
            insLocation = chooser.getSelectedFile().getAbsolutePath();
        }
        return insLocation;
    }

    private JFileChooser getJFileChooser(){
        JFileChooser chooser = new JFileChooser();

        chooser.setDialogTitle("LBL_Chooser_Name"); //NOI18N
        chooser.setDialogType(JFileChooser.CUSTOM_DIALOG);

        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        chooser.setApproveButtonMnemonic("Choose_Button_Mnemonic".charAt(0)); //NOI18N
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(new dirFilter());
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setApproveButtonToolTipText("LBL_Chooser_Name"); //NOI18N

        chooser.getAccessibleContext().setAccessibleName("LBL_Chooser_Name"); //NOI18N
        chooser.getAccessibleContext().setAccessibleDescription("LBL_Chooser_Name"); //NOI18N

        return chooser;
    }

    private static class dirFilter extends javax.swing.filechooser.FileFilter {

        @Override
        public boolean accept(File f) {
            if(!f.exists() || !f.canRead() || !f.isDirectory() ) {
                return false;
            }else{
                return true;
            }
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(AddServerPropertiesVisualPanel.class, "LBL_DirType"); //NOI18N
        }

    }

}


class DomainComboModel extends AbstractListModel implements ComboBoxModel{
    private int current = -1;
    private String[][] domains = null;


    public void addDomain(String domain, String path){
        String[][] newDomains = new String[domains.length+1][2];
        int i = 0;
        for(;i<domains.length; i++){
            newDomains[i][0] = domains[i][0];
            newDomains[i][1] = domains[i][1];
        }
        newDomains[i][0] = domain;
        newDomains[i][1] = path;
        domains = newDomains;

    }

    public DomainComboModel(Map domains){
        setDomains(domains);
    }

    public void setDomains(Map domains) {

        current = -1;
        this.domains = null;

        int len = domains.size();
        this.domains = new String[len][2];
        Set en = domains.keySet();

        if (len > 0) current = 0;

        int i = 0;
        for(Object key : en) {
            this.domains[i][0] = (String)key;
            this.domains[i][1] = (String)domains.get(this.domains[i][0]);
            if(this.domains[i][0].equalsIgnoreCase("default")) //NOI18N
                current=i;
            i++;
        }
    }

    @Override
    public Object  getSelectedItem() {
        if (current ==-1 )
            return "";
        return domains[current][0];
    }

    @Override
    public void setSelectedItem(Object anItem) {
        for (int i = 0; i < getSize(); i++){
            if (domains[i][0].equals(anItem)){
                current = i;
                fireContentsChanged(this, -1, -1);
                return;
            }
        }
        current = -1;
        //currentVal = (String)anItem;
        fireContentsChanged(this, -1, -1);
    }

    @Override
    public Object getElementAt(int index){
        return domains[index][0];
    }

    @Override
    public int 	getSize(){
        return domains.length;
    }
    //----------------------------------------------------

    public String getCurrentPath(){
        if (current == -1) return "";
        return domains[current][1];
    }

    public boolean hasDomain(String domain){
        for (int i = 0; i < getSize(); i++){
            if (domains[i][0].equals(domain)){
                return true;
            }
        }
        return false;
    }

}





