/*
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _CLUTTER_DRAG_SERVER_H_
#define _CLUTTER_DRAG_SERVER_H_

#include <glib.h>
#include <clutter/clutter.h>

#include "clutter-drag-dest.h"

#define CLUTTER_TYPE_DRAG_SERVER (clutter_drag_server_get_type ())

#define CLUTTER_DRAG_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	CLUTTER_TYPE_DRAG_SERVER, ClutterDragServer))

#define CLUTTER_DRAG_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	CLUTTER_TYPE_DRAG_SERVER, ClutterDragServerClass))

#define CLUTTER_IS_DRAG_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	CLUTTER_TYPE_DRAG_SERVER))

#define CLUTTER_IS_DRAG_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	CLUTTER_TYPE_DRAG_SERVER))

#define CLUTTER_DRAG_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	CLUTTER_TYPE_DRAG_SERVER, ClutterDragServerClass))

typedef struct _ClutterDragServer        ClutterDragServer;
typedef struct _ClutterDragServerClass   ClutterDragServerClass;
typedef struct _ClutterDragServerPrivate ClutterDragServerPrivate;
 
struct _ClutterDragServer
{
  GObject        parent;	

  ClutterDragServerPrivate *priv;
};

struct _ClutterDragServerClass
{
  GObjectClass   parent_class;

  /*<signals>*/
  void (*drag_started)  (ClutterDragServer *server);
  void (*drag_finished) (ClutterDragServer *server);
};

GType               clutter_drag_server_get_type (void) G_GNUC_CONST;

ClutterDragServer * clutter_drag_server_get_default (void);

void                clutter_drag_server_add_drag_dest    (ClutterDragServer *server,
                                                          ClutterDragDest *dest);
void                clutter_drag_server_remove_drag_dest (ClutterDragServer *server,
                                                          ClutterDragDest *dest);


void                clutter_drag_server_begin_drag       (ClutterDragServer *server,
                                                          ClutterActor      *context,
                                                          gpointer           udata);

void                clutter_drag_server_finish_drag      (ClutterDragServer *);

#endif /* _CLUTTER_DRAG_SERVER_H_ */

