#ifndef FILE_L2HOFE
#define FILE_L2HOFE

/*********************************************************************/
/* File:   l2hofe.hpp                                                */
/* Author: Start                                                     */
/* Date:   6. Feb. 2003                                              */
/*********************************************************************/

/**
  High order finite elements for H^1
*/
class L2HighOrderFiniteElement : public NodalFiniteElement
{
public:
  ///
  L2HighOrderFiniteElement (int dim, ELEMENT_TYPE aeltype);

  void SetOrder (int o);
  virtual void ComputeNDof () = 0;
private:
  virtual const ARRAY<IPData> & GetIPData () const
  {
    throw Exception ("GetIPData not available for L2HighOrderFE");
  }
};



/*
  High order segment finite element
*/
/*
class L2HighOrderSegm : public L2HighOrderFiniteElement
{
public:
  L2HighOrderSegm (int aorder);
  virtual void ComputeNDof();

  /// compute shape
  virtual void CalcShape (const IntegrationPoint & ip, 
			  FlatVector<> shape) const;
  
  /// compute gradient of shape
  virtual void CalcDShape (const IntegrationPoint & ip, 
			   FlatMatrix<> dshape) const;
};
*/

/**
  High order triangular finite element
*/
class L2HighOrderTrig : public L2HighOrderFiniteElement
{
  typedef TrigShapesInnerLegendre T_INNERSHAPES;
  // typedef TrigShapesInnerJacobi T_INNERSHAPES;
public:
  L2HighOrderTrig (int aorder);
  virtual void ComputeNDof();

  /// compute shape
  virtual void CalcShape (const IntegrationPoint & ip, 
			  FlatVector<> shape) const;

  /*  
  /// compute gradient of shape
  virtual void CalcDShape (const IntegrationPoint & ip, 
			   FlatMatrix<> dshape) const;
  */
};

#ifdef abc
/**
  High order quadrilateral finite element
*/
template <class T_EXT>
class L2HighOrderQuad : public L2HighOrderFiniteElement
{
  typedef T_EXT T_EDGESHAPES;
  typedef VertexExtensionOptimal<3> T_VERTEXSHAPES;

public:
  L2HighOrderQuad (int aorder);
  virtual void ComputeNDof();

  /// compute shape
  virtual void CalcShape (const IntegrationPoint & ip, 
			  FlatVector<> shape) const;
  
  /// compute gradient of shape
  virtual void CalcDShape (const IntegrationPoint & ip, 
			   FlatMatrix<> dshape) const;

private:
  void CalcShapeDShape (const IntegrationPoint & ip, 
			ARRAY<AutoDiff<2> > & shape) const;
};


/**
  High order tetrahedral finite element
*/
template <class T_EXT>
class L2HighOrderTet : public L2HighOrderFiniteElement
{
  typedef T_EXT T_EDGESHAPES;

  typedef TetShapesInnerLegendre T_INNERSHAPES;
  typedef TetShapesFaceLegendre T_FACESHAPES;

  // typedef TetShapesInnerJacobi T_INNERSHAPES;
  // typedef TetShapesFaceJacobi T_FACESHAPES;

  // typedef TetShapesFaceOpt1 T_FACESHAPES;

  typedef VertexExtensionOptimal<3> T_VERTEXSHAPES;
  // typedef VertexStandard T_VERTEXSHAPES;
public:
  L2HighOrderTet (int aorder);
  virtual void ComputeNDof();

  /// compute shape
  virtual void CalcShape (const IntegrationPoint & ip, 
			  FlatVector<> shape) const;
  
  /// compute gradient of shape
  virtual void CalcDShape (const IntegrationPoint & ip, 
			   FlatMatrix<> dshape) const;

private:
  void CalcShapeDShape (const IntegrationPoint & ip, 
			ARRAY<AutoDiff<3> > & shape) const;
};


/**
  High order prismatic finite element
*/
template <class T_EXT>
class L2HighOrderPrism : public L2HighOrderFiniteElement
{
  typedef T_EXT T_EDGESHAPES;
  typedef TrigShapesInnerLegendre T_TRIGSHAPES;
  typedef VertexExtensionOptimal<3> T_VERTEXSHAPES;

public:
  L2HighOrderPrism (int aorder);
  virtual void ComputeNDof();

  /// compute shape
  virtual void CalcShape (const IntegrationPoint & ip, 
			  FlatVector<> shape) const;
  
  /// compute gradient of shape
  virtual void CalcDShape (const IntegrationPoint & ip, 
			   FlatMatrix<> dshape) const;

  void CalcShapeDShape (const IntegrationPoint & ip, 
			ARRAY<AutoDiff<3> > & shape) const;
};



/**
  High order hexahedral finite element
*/
template <class T_EXT>
class L2HighOrderHex : public L2HighOrderFiniteElement
{
  typedef T_EXT T_EDGESHAPES;
  typedef VertexExtensionOptimal<3> T_VERTEXSHAPES;

public:
  L2HighOrderHex (int aorder);
  virtual void ComputeNDof();

  /// compute shape
  virtual void CalcShape (const IntegrationPoint & ip, 
			  FlatVector<> shape) const;
  
  /// compute gradient of shape
  virtual void CalcDShape (const IntegrationPoint & ip, 
			   FlatMatrix<> dshape) const;

  void CalcShapeDShape (const IntegrationPoint & ip, 
			ARRAY<AutoDiff<3> > & shape) const;
};


/**
  High order pyramid finite element
*/
template <class T_EXT>
class L2HighOrderPyramid : public L2HighOrderFiniteElement
{
  typedef T_EXT T_EDGESHAPES;
  typedef TrigShapesInnerLegendre T_TRIGSHAPES;
  typedef VertexExtensionOptimal<3> T_VERTEXSHAPES;

public:
  L2HighOrderPyramid (int aorder);
  virtual void ComputeNDof();

  /// compute shape
  virtual void CalcShape (const IntegrationPoint & ip, 
			  FlatVector<> shape) const;
  
  /*
  /// compute gradient of shape
  virtual void CalcDShape (const IntegrationPoint & ip, 
			   FlatMatrix<> dshape) const;
  */
};
#endif


#endif
