geometry = ngsolve/pde_tutorial/capacitor_3d.geo
mesh = ngsolve/pde_tutorial/capacitor_3d.vol


define coefficient coef_lam
1,

define coefficient coef_alpha
0, 1e5, 1e5, 

define coefficient coef_g
0, 1e5, -1e5,

define fespace v -order=3
#  -augmented=1
define gridfunction u -fespace=v

define bilinearform a -fespace=v -symmetric
laplace coef_lam
robin coef_alpha

define linearform f -fespace=v
neumann coef_g

# define preconditioner c -type=direct -bilinearform=a
# define preconditioner c -type=local -bilinearform=a
define preconditioner c -type=multigrid -bilinearform=a -smoothingsteps=1


numproc bvp np1 -bilinearform=a -linearform=f -gridfunction=u -preconditioner=c -maxsteps=1000


numproc drawflux np2 -bilinearform=a -solution=u -label=flux


# error estimator:

define fespace verr -l2 -order=0
define gridfunction err -fespace=verr

numproc zzerrorestimator np3 -bilinearform=a -linearform=f -solution=u -error=err -minlevel=1
numproc markelements np4 -error=err -minlevel=1 -factor=0.5
