geometry = ngsolve/pde_tutorial/cube.geo
mesh = ngsolve/pde_tutorial/cube.vol

define constant secondorder = 0

define coefficient lam
1,

define coefficient rho
1,

define coefficient penalty
1e5, 1e5, 1e5, 0, 0, 1e5,

define coefficient coef_source
1,

define fespace v -order=2
define fespace vp -order=1 -dim=3

define gridfunction u -fespace=v -nested
define gridfunction p -fespace=vp

define bilinearform a -fespace=v -symmetric
laplace lam
mass rho
robin penalty

define bilinearform aid -fespace=v -symmetric -nonassemble
mass rho
robin rho


define linearform f -fespace=v
source coef_source


# define preconditioner c -type=direct -bilinearform=a
# define preconditioner c -type=local -bilinearform=a
define preconditioner c -type=multigrid -bilinearform=a -smoothingsteps=1
# define preconditioner c -type=amg -bilinearform=a -coefe=lam -notiming -test

numproc bvp np1 -bilinearform=a -linearform=f -gridfunction=u -preconditioner=c -maxsteps=1000 -print
numproc calcflux np2 -bilinearform=a -solution=u -flux=p -applyd

numproc drawflux np3 -bilinearform=aid -solution=u -noapplyd -label=sol
