.ngmenu.solve add command -label "Preprocessor" \
    -command { preprocessordialog }




set preprocvar(selspace) v

set preprocvar(selgf) u


set ppvar(spaces) {}



proc preprocessordialog { } {

    set w .preproc_dlg
    global preprocvar
    
    if {[winfo exists .preproc_dlg] == 1} {
	wm withdraw $w
	wm deiconify $w
	focus $w 
    } {

	toplevel $w


	tixNoteBook $w.nb -ipadx 6 -ipady 6
	
	$w.nb add coefs -label "Coef" -underline 0
	$w.nb add spaces -label "Space"   -underline 0
	$w.nb add gridfunc -label "Gridfunc" -underline 0
	$w.nb add bilinearf -label "Bi-Form"   -underline 0
	$w.nb add linearf -label "Li-Form"   -underline 0
	$w.nb add precond -label "Precond"   -underline 0
	$w.nb add solver -label "Solve"   -underline 0

	pack $w.nb -expand yes -fill both -padx 5 -pady 5 -side top	


	# Coefficient page
	set f [$w.nb subwidget coefs]


	
	tixNoteBook $f.lnb -ipadx 6 -ipady 6

	$f.lnb add domain -label "Domain" -under 0
	$f.lnb add boundary -label "Boundary" -under 0

	set ff [$f.lnb subwidget domain]
    
	button $ff.addcoef -text "Add Coef"
	pack $ff.addcoef



	tixScrolledGrid $ff.g -bd 0 -height 200
	pack $ff.g -expand yes -fill both -padx 3 -pady 3

	set grid [$ff.g subwidget grid]
#	$grid config -formatcmd "SimpleFormat $grid"
	
	$grid config \
	    -formatcmd "EditGrid_format $grid" \
	    -editnotifycmd "EditGrid_editNotify" \
	    -editdonecmd "EditGrid_editDone" \
	    -selectunit cell \
	    -selectmode single


	global editgrid
	set editgrid(g)   $grid
	set editgrid(top) 1
	set editgrid(bot) 3
	set editgrid(result) 5
	

	# Set the size of the columns
	#
	$grid size col 0 -size 10char
	$grid size col default -size auto
	$grid size row default -size 1.1char -pad0 3

	
	for {set y 1} {$y < 20} {incr y} {
	    $grid set 0 $y -itemtype text -text "Domain $y"
	}

	set coefnames { E nu lam rho }
	set coefdefault { 2.1E11 0.2 1 6700 }
	set x 1
	foreach h $coefnames {
	    $grid set $x 0 -itemtype text -text $h 
	    incr x
	}

#	for {set x 1} {$x < 10} {incr x} {
#	    $grid set $x 0 -itemtype text -text "Coeff $x"
#	}

	for {set y 1} {$y < 20} {incr y} {
	    set x 1
	    foreach h $coefdefault {
		$grid set $x $y -itemtype text -text $h 
		incr x
	    }
	}


	pack $ff.g
	pack $f.lnb




	
	# Space definition
	set f [$w.nb subwidget spaces]

	
	tixOptionMenu $f.selspace \
	    -label "FE Space: " \
	    -variable preprocvar(selspace) \
	    -command { preproc_update_selspace } \
	    -options {
		label.width  10
		label.anchor e
		menubutton.width 10
	    } 

	pack $f.selspace

	frame $f.bu 
	button $f.bu.add -text "New Space" -command {
	    set value [preproc_readname "New Space"];
	    puts "new space: $value"
	    set f [.preproc_dlg.nb subwidget spaces]
	    $f.selspace add command $value -label $value;
	    set ppvar($value,spacetype) Nodal
	    set ppvar($value,spacedim) 1
	    set ppvar($value,spaceorder) 1
	    lappend ppvar(spaces) $value
	    preproc_update_selspace $value
	}

	button $f.bu.del -text "Delete Space" -command "puts {del space}"
	
	pack $f.bu
	pack $f.bu.add $f.bu.del -side left

	

	set spacetype { Nodal Non-conforming Edge Element }
	tixOptionMenu $f.spacetype \
	    -label "Type:" \
	    -options {
		label.width  10
		label.anchor e
		menubutton.width 10
	    } 
	pack $f.spacetype
	foreach it $spacetype {
	    $f.spacetype add command $it -label $it
	}



	tixControl $f.dim -label "Dimension: " -integer true \
	    -min 1 -max 6 \
	    -options {
		entry.width 3
		label.width 10
		label.anchor e
	    }	

	tixControl $f.order -label "Order: " -integer true \
	    -min 0 -max 2 \
	    -options {
		entry.width 3
		label.width 10
		label.anchor e
	    }	

	pack $f.spacetype $f.dim $f.order












	
	# Gridfunction definition
	set f [$w.nb subwidget gridfunc]
	
	tixOptionMenu $f.selgf \
	    -label "Grid-function: " \
	    -variable preprocvar(selgf) \
	    -command { preproc_update_selgf } \
	    -options {
		label.width  20
		label.anchor e
		menubutton.width 10
	    } 


	pack $f.selgf



	frame $f.bu 
	button $f.bu.add -text "New Grid-Func" -command {
	    set value [preproc_readname "New Gridfunction"];
	    puts "new gf: $value"
	    set f [.preproc_dlg.nb subwidget gridfunc]
	    $f.selgf add command $value -label $value;
	    set ppvar($value,selgfspc) v
	    preproc_update_selgf $value
	}

	button $f.bu.del -text "Delete Grid-Func" -command "puts {del gf}"
	
	pack $f.bu
	pack $f.bu.add $f.bu.del -side left

	

	tixOptionMenu $f.selgfspc \
	    -label "FE Space: " \
	    -options {
		label.width  20
		label.anchor e
		menubutton.width 10
	    } 

	pack $f.selgfspc









	frame $w.bu
	pack $w.bu -fill x -ipady 3

	button $w.bu.ok -text "Done" -command {
	    wm withdraw .preproc_dlg
	}

	button $w.bu.update -text "Update" -command {
	    preproc_update
	}

	button $w.bu.apply -text "Apply" -command {
	    preproc_apply
	}

	pack  $w.bu.ok $w.bu.update $w.bu.apply -side left -expand yes
    
	
	wm withdraw $w
	wm geom $w +100+100
	wm deiconify $w
	wm title $w "Preprocessor"
	focus .preproc_dlg
    }
}


proc preproc_readname { label } {
    puts "label $label"
    set w .preproc_read
    toplevel $w
    grab $w
    
    global value
    set value v
    tixLabelEntry $w.ent -label $label \
	    -options {
		entry.width 20
		label.width 20
		label.anchor e   
		entry.textVariable value
	    }	

    pack $w.ent

    tixButtonBox $w.box -orientation horizontal
    $w.box add ok     -text Ok     -underline 0 -command "destroy $w" \
	-width 6
    $w.box add cancel -text Cancel -underline 0 -command "destroy $w" \
	-width 6

    pack $w.box -side bottom -fill x
    while  {[winfo exists .preproc_read] == 1} {
	update
    }

    return $value
}



proc preproc_update { } {

    global preprocvar
    global ppvar

    set w .preproc_dlg
    set f [$w.nb subwidget spaces]
    

    set ppvar(spaces) {}
    set nspaces [NGS_GetData numspaces]
    for { set i 1 } { $i <= $nspaces } { incr i } {
	set name [NGS_GetData spacename $i]
	lappend ppvar(spaces) $name
	set ppvar($name,spacetype) [NGS_GetData spacetype $name] 
	set ppvar($name,spaceorder) [NGS_GetData spaceorder $name] 
	set ppvar($name,spacedim) [NGS_GetData spacedim $name] 
    }


    set ppvar(gridfunctions) {}
    set ngf [NGS_GetData numgridfunctions]
    for { set i 1 } { $i <= $nspaces } { incr i } {
	set name [NGS_GetData gridfunctionname $i]
	lappend ppvar(gridfunctions) $name
	set ppvar($name,gfspace) [NGS_GetData gridfunctionspace $name] 
    }


    set oldent [$f.selspace entries]
    foreach it $oldent { 
	$f.selspace del $it }
    foreach it $ppvar(spaces) {
	$f.selspace add command $it -label $it
    }


    preproc_update_selspace  $preprocvar(selspace)




    set f [$w.nb subwidget gridfunc]

    set oldent [$f.selgfspc entries]
    foreach it $oldent {
	$f.selgfspc del $it }
    foreach it $ppvar(spaces) {
	$f.selgfspc add command $it -label $it }

    set oldent [$f.selgf entries]
    foreach it $oldent {
	$f.selgf del $it }
    foreach it $ppvar(gridfunctions) {
	$f.selgf add command $it -label $it }

   
}


proc preproc_update_selspace { spc } {
    global ppvar

    set f [.preproc_dlg.nb subwidget spaces]

    $f.order configure -variable ppvar($spc,spaceorder)
    $f.dim configure -variable ppvar($spc,spacedim)
    $f.spacetype configure -variable ppvar($spc,spacetype)
}



proc preproc_update_selgf { gf } {
    global ppvar

    set f [.preproc_dlg.nb subwidget gridfunc]

    $f.selgfspc configure -variable ppvar($gf,gfspace)
}



proc preproc_apply { } {
    global ppvar

    puts "spaces = $ppvar(spaces)"
    foreach spc $ppvar(spaces) {
	puts "space $spc, type = $ppvar($spc,spacetype), order = $ppvar($spc,spaceorder), dim = $ppvar($spc,spacedim)"
    }

    puts "gridfunctions = $ppvar(gridfunctions)"
    foreach gf $ppvar(gridfunctions) {
	puts "gridfunction $gf, space = $ppvar($gf,gfspace)"
    }
}







proc SimpleFormat {w area x1 y1 x2 y2} {

    global margin
    set bg(s-margin) gray65
    set bg(x-margin) gray65
    set bg(y-margin) gray65
    set bg(main)     gray20

    case $area {
	main {
	    # The "grid" format is consecutive boxes without 3d borders
	    #
	    $w format grid $x1 $y1 $x2 $y2 \
		-relief raised -bd 1 -bordercolor $bg($area) -filled 0 -bg red\
		-xon 1 -yon 1 -xoff 0 -yoff 0 -anchor se
	}
	{x-margin y-margin s-margin} {
	    # border specifies consecutive 3d borders
	    #
	    $w format border $x1 $y1 $x2 $y2 \
		-fill 1 -relief raised -bd 1 -bg $bg($area) \
		-selectbackground gray80
	}
    }
}
   


# EditGrid_format --
#
#	This command is called whenever the background of the grid
#	needs to be reformatted. The x1, y1, x2, y2 sprcifies the four
#	corners of the area that needs to be reformatted.
#
proc EditGrid_format {w area x1 y1 x2 y2} {
    global editgrid

    set bg(s-margin) gray65
    set bg(x-margin) gray65
    set bg(y-margin) gray65
    set bg(main)     gray20

    case $area {
	main {
	    foreach col {2 4} {
		$w format border $col 1 $col $editgrid(bot) \
		    -relief flat -filled 1 -yon 1 -yoff 1\
		    -bd 0 -bg #b0b0f0 -selectbackground #a0b0ff
		$w format border $col 2 $col $editgrid(bot) \
		    -relief flat -filled 1 -yon 1 -yoff 1\
		    -bd 0 -bg #80b080 -selectbackground #80b0ff
	    }

	    $w format grid $x1 $y1 $x2 $y2 \
		-relief raised -bd 1 -bordercolor $bg($area) -filled 0 -bg red\
		-xon 1 -yon 1 -xoff 0 -yoff 0 -anchor se
	}
	y-margin {
	    $w format border $x1 $y1 $x2 $y2 \
		-fill 1 -relief raised -bd 1 -bg $bg($area) \
		-selectbackground gray80
	}
	default {
	    $w format border $x1 $y1 $x2 $y2 \
		-filled 1 \
		-relief raised -bd 1 -bg $bg($area) \
		-selectbackground gray80
	}
    }

#    case $area {
#	{main y-margin} {
#	    set y [expr $editgrid(bot) + 1]
#	    $w format border 0 $y 100 $y -bg black -filled 1 -bd 0
#	}
#   }
}

# EditGrid_edit --
#
#	Prompts the user to edit a cell.
#
proc EditGrid_edit {} {
    global editgrid
    set grid $editgrid(g)

    set ent [$grid anchor get]
    if [string comp $ent ""] {
	$grid edit set [lindex $ent 0]  [lindex $ent 1]
    }
}





# EditGrid_calIncome --
#
#	Calculates the average income.
#
proc EditGrid_calIncome {} {
    global editgrid
    set grid $editgrid(g)

    set income 0
    set total_pop 0
    for {set i $editgrid(top)} {$i <= $editgrid(bot)} {incr i} {
	set pop [$grid entrycget 2 $i -text]
	set inc [$grid entrycget 4 $i -text]
	set income [expr $income + $pop.0 * $inc]
	incr total_pop $pop
    }

    $grid set 4 $editgrid(result) -text [expr $income/$total_pop]

}

# EditGrid_calculate --
#
#	Recalculates both columns.
#
proc EditGrid_calculate {} {
    global editgrid
    set grid $editgrid(g)

    $grid edit apply
    EditGrid_calIncome
}

# EditGrid_editNotify --
#
#	Returns true if an entry can be edited.
#
proc EditGrid_editNotify {x y} {
    global editgrid
    set grid $editgrid(g)

    puts "notify, x = $x, y = $y"
    if { $x >= 1 && $y >= 0 } {
	set editgrid(oldValue) [$grid entrycget $x $y -text]
	return 1;
    }
    
#    if {$x == 2 || $x == 4} {
#	if {$y >= $editgrid(top) && $y <= $editgrid(bot)} {
#	    set editgrid(oldValue) [$grid entrycget $x $y -text]
#	    return 1
#	}
#    }	
    return 0
}

# EditGrid_editDone --
#
#	Gets called when the user is done editing an entry.
#
proc EditGrid_editDone {x y} {
    global editgrid
    set grid $editgrid(g)

#    if {$x == 2} {
#	set pop [$grid entrycget $x $y -text]
#	if [catch {
#	    format %d $pop
#	}] {
#	    $grid entryconfig $x $y -text $editgrid(oldValue)
#	    tk_dialog .editGridWarn "" \
#		"$pop is not an valid integer. Try again" \
#		warning 0 Ok
#        } else {
#	    $grid entryconfig 4 $editgrid(result) -text "-"
#	    puts "Edit done" 
#	}
#    } else {
#	set income [$grid entrycget $x $y -text]
#	if [catch {
#	    format %f $income
#	}] {
#	    $grid entryconfig $x $y -text $editgrid(oldValue)
#	    tk_dialog .editGridWarn "" \
\#		"$income is not an valid floating number. Try again" \
\#		warning 0 Ok
 #       } else {
#	    $grid entryconfig 4 $editgrid(result) -text "-"
#	}
#    }
}






preprocessordialog
wm withdraw .preproc_dlg

