#ifndef FILE_DEMOVIEW
#define FILE_DEMOVIEW

/*********************************************************************/
/* File:   demoview.hpp                                              */
/* Author: Robert, Joachim                                           */
/* Date:   6. Mar. 2003                                              */
/*********************************************************************/

using namespace netgen;


enum TOKEN_TYPE
  { 
    TOK_MINUS = '-', TOK_LP = '(', TOK_RP = ')', TOK_LSP = '[', TOK_RSP = ']',
    TOK_EQU = '=', TOK_COMMA = ',', TOK_SEMICOLON = ';', TOK_COLON = ':', TOK_PLUS = '+',
    TOK_NUM = 100, TOK_STRING, TOK_TIME, TOK_CAMPOS, TOK_CAMPOINT, TOK_CAMUP,
    TOK_END 
  };

struct kwstruct
{
  TOKEN_TYPE kw; 
  char * name;
};

static kwstruct defkw[] =
  {
    { TOK_TIME,     "t" },
    { TOK_CAMPOS,   "camerapos" },
    { TOK_CAMPOINT, "camerapointto" },
    { TOK_CAMUP,    "cameraup" }
  };



class DemoScanner
{
  TOKEN_TYPE token;
  double num_value;
  string string_value;
    
  int linenum;
  ifstream * scanin;

public:

  DemoScanner (ifstream & ascanin);

  TOKEN_TYPE GetToken() const
  { return token; }

  double GetNumValue() const
  { return num_value; }

  const string & GetStringValue() const
  { return string_value; }

  void ReadNext();
  void Error (const string & err);
};


void ParseChar (DemoScanner & scan, char ch);

double ParseNumber(DemoScanner & scan);

Vec<3> ParseVector (DemoScanner & scan);



template <class S>
class InterpolationPoint
{
  double t;
  S s;

public:
  InterpolationPoint()
  {};

  ~InterpolationPoint()
  {};

  double GetT() const
  { return t; };

  S GetS() const
  { return s; };

  void SetTS(double at, S as)
  { t = at; s = as; };

  InterpolationPoint & operator= (const InterpolationPoint<S> & ip2)
  {
    SetTS (ip2.t, ip2.s);
    return (*this);
  };

};




template <class S>
class InterpolationSpline
{
protected:
  ARRAY < InterpolationPoint<S>[3] > ip;
  int finished;

public:
  InterpolationSpline() : finished(0)
  {};

  InterpolationSpline( S s1 ) : finished(0)
  {
    AddSpline (-1e99, -1e99, -1e99, s1, s1, s1);
    InterpolationSpline();
  }

  ~InterpolationSpline()
  {};

  void AddSpline(double t1, double t2, double t3, S s1, S s2, S s3);

  S Evaluate (double t);

  int IsFinished() const
  {
    return finished;
  }
};





class DemoView
{
  InterpolationSpline< Vec<3> > campos;
  InterpolationSpline< Vec<3> > campoint;
  InterpolationSpline< Vec<3> > camup;

public:
  DemoView (const char * filename);
  ~DemoView ();
  
  int SetTime (double time);
};



#endif
