/*
 * Copyright 2006 James Bursa <bursa@users.sourceforge.net>
 * Copyright 2006 Adrian Lees <adrianl@users.sourceforge.net>
 *
 * This file is part of NetSurf, http://www.netsurf-browser.org/
 *
 * NetSurf is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; version 2 of the License.
 *
 * NetSurf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/** \file
 * Content for text/plain (interface).
 */

#ifndef _NETSURF_RENDER_TEXTPLAIN_H_
#define _NETSURF_RENDER_TEXTPLAIN_H_

#include <stddef.h>
#include "desktop/mouse.h"

struct content;
struct hlcache_handle;
struct http_parameter;
struct rect;

struct textplain_line {
	size_t	start;
	size_t	length;
};

struct content_textplain_data {
	char *encoding;
	void *inputstream;
	char *utf8_data;
	size_t utf8_data_size;
	size_t utf8_data_allocated;
	unsigned long physical_line_count;
	struct textplain_line *physical_line;
	int formatted_width;
};

bool textplain_create(struct content *c, const struct http_parameter *params);
bool textplain_process_data(struct content *c, 
		const char *data, unsigned int size);
bool textplain_convert(struct content *c);
void textplain_mouse_track(struct content *c, struct browser_window *bw,
			browser_mouse_state mouse, int x, int y);
void textplain_mouse_action(struct content *c, struct browser_window *bw,
			browser_mouse_state mouse, int x, int y);
void textplain_reformat(struct content *c, int width, int height);
void textplain_destroy(struct content *c);
bool textplain_redraw(struct content *c, int x, int y,
		int width, int height, const struct rect *clip,
		float scale, colour background_colour);
bool textplain_clone(const struct content *old, struct content *new_content);

/* access to lines for text selection and searching */
unsigned long textplain_line_count(struct hlcache_handle *h);
size_t textplain_size(struct hlcache_handle *h);

size_t textplain_offset_from_coords(struct hlcache_handle *h, int x, int y, 
		int dir);
void textplain_coords_from_range(struct hlcache_handle *h,
		unsigned start, unsigned end, struct rect *r);
char *textplain_get_line(struct hlcache_handle *h, unsigned lineno,
		size_t *poffset, size_t *plen);
int textplain_find_line(struct hlcache_handle *h, unsigned offset);
char *textplain_get_raw_data(struct hlcache_handle *h,
		unsigned start, unsigned end, size_t *plen);

#endif
