/*
                                  NETWOX
                             Network toolbox
                Copyright(c) 1999-2005 Laurent Constantin
                                  -----

  Main server    : http://www.laurentconstantin.com/
  Backup servers : http://go.to/laurentconstantin/
                   http://laurentconstantin.est-la.com/
                   http://laurentconstantin.free.fr/
                   http://membres.lycos.fr/lauconstantin/
  [my current email address is on the web servers]

                                  -----
  This file is part of Netwox.

  Netwox is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  version 2 as published by the Free Software Foundation.

  Netwox is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  General Public License for more details (http://www.gnu.org/).

------------------------------------------------------------------------
*/

/*-------------------------------------------------------------*/
#include "../../netwox.h"

/*-------------------------------------------------------------*/
typedef enum {
  NETWOX_WEBSPIDERCF_VAR_UNKNOWN = 1,
  NETWOX_WEBSPIDERCF_VAR_LOCALROOTDIR,
  NETWOX_WEBSPIDERCF_VAR_URLTODOWNLOAD,
  NETWOX_WEBSPIDERCF_VAR_PROXYHOST,
  NETWOX_WEBSPIDERCF_VAR_PROXYPORT,
  NETWOX_WEBSPIDERCF_VAR_PROXYUSER,
  NETWOX_WEBSPIDERCF_VAR_PROXYPASS,
  NETWOX_WEBSPIDERCF_VAR_MAXRECURSION,
  NETWOX_WEBSPIDERCF_VAR_MAXTHREADS,
  NETWOX_WEBSPIDERCF_VAR_MAXSEGMENTLEN,
  NETWOX_WEBSPIDERCF_VAR_MAXTOTALLEN,
  NETWOX_WEBSPIDERCF_VAR_MILLISLEEP,
  NETWOX_WEBSPIDERCF_VAR_ACL,
  NETWOX_WEBSPIDERCF_VAR_GETIMAGE,
  NETWOX_WEBSPIDERCF_VAR_GETMULTIMEDIA,
  NETWOX_WEBSPIDERCF_VAR_GETCODE,
  NETWOX_WEBSPIDERCF_VAR_LINKCONVERSION,
  NETWOX_WEBSPIDERCF_VAR_USERAGENT,
  NETWOX_WEBSPIDERCF_VAR_LOGLEVEL,
  NETWOX_WEBSPIDERCF_VAR_FTPPASSIVE,
  NETWOX_WEBSPIDERCF_VAR_TIMEOUTMS
} netwox_webspidercf_var;
#define NETWOX_WEBSPIDERCF_VARNAME_LOCALROOTDIR "localrootdir"
#define NETWOX_WEBSPIDERCF_VARNAME_URLTODOWNLOAD "urltodownload"
#define NETWOX_WEBSPIDERCF_VARNAME_PROXYHOST "proxyhost"
#define NETWOX_WEBSPIDERCF_VARNAME_PROXYPORT "proxyport"
#define NETWOX_WEBSPIDERCF_VARNAME_PROXYUSER "proxyuser"
#define NETWOX_WEBSPIDERCF_VARNAME_PROXYPASS "proxypass"
#define NETWOX_WEBSPIDERCF_VARNAME_MAXRECURSION "maxrecursion"
#define NETWOX_WEBSPIDERCF_VARNAME_MAXTHREADS "maxthreads"
#define NETWOX_WEBSPIDERCF_VARNAME_MAXSEGMENTLEN "maxsegmentlen"
#define NETWOX_WEBSPIDERCF_VARNAME_MAXTOTALLEN "maxtotallen"
#define NETWOX_WEBSPIDERCF_VARNAME_MILLISLEEP "millisleep"
#define NETWOX_WEBSPIDERCF_VARNAME_ACL "acl"
#define NETWOX_WEBSPIDERCF_VARNAME_GETIMAGE "getimage"
#define NETWOX_WEBSPIDERCF_VARNAME_GETMULTIMEDIA "getmultimedia"
#define NETWOX_WEBSPIDERCF_VARNAME_GETCODE "getcode"
#define NETWOX_WEBSPIDERCF_VARNAME_LINKCONVERSION "linkconversion"
#define NETWOX_WEBSPIDERCF_VARNAME_USERAGENT "useragent"
#define NETWOX_WEBSPIDERCF_VARNAME_LOGLEVEL "loglevel"
#define NETWOX_WEBSPIDERCF_VARNAME_FTPPASSIVE "ftppassive"
#define NETWOX_WEBSPIDERCF_VARNAME_TIMEOUTMS "timeoutms"

/*-------------------------------------------------------------*/
static netwib_err netwox_webspidercf_var_init_buf(netwib_constbuf *pbuf,
                                                  netwox_webspidercf_var *pvar)
{
  netwib_data data;
  netwib_uint32 datasize;
  netwib_byte firstchar;

  data = netwib__buf_ref_data_ptr(pbuf);
  datasize = netwib__buf_ref_data_size(pbuf);

  if (datasize == 0) {
    if (pvar != NULL) *pvar = NETWOX_WEBSPIDERCF_VAR_UNKNOWN;
    return(NETWIB_ERR_OK);
  }

  firstchar = data[0];
#define netwox_webspidercf_var_init_buf_text(item,v) if (!netwib_c_memcmp(data, (netwib_constdata)item, datasize)) { if (pvar != NULL) *pvar = v; return(NETWIB_ERR_OK);}
  switch(firstchar) {
  case 'a' :
    if (datasize == 3) {
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_ACL, NETWOX_WEBSPIDERCF_VAR_ACL);
    }
    break;
  case 'f' :
    if (datasize == 10) {
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_FTPPASSIVE, NETWOX_WEBSPIDERCF_VAR_FTPPASSIVE);
    }
    break;
  case 'g' :
    switch(datasize) {
    case 7 :
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_GETCODE, NETWOX_WEBSPIDERCF_VAR_GETCODE);
      break;
    case 8 :
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_GETIMAGE, NETWOX_WEBSPIDERCF_VAR_GETIMAGE);
      break;
    case 13 :
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_GETMULTIMEDIA, NETWOX_WEBSPIDERCF_VAR_GETMULTIMEDIA);
      break;
    }
    break;
  case 'l' :
    switch(datasize) {
    case 8 :
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_LOGLEVEL, NETWOX_WEBSPIDERCF_VAR_LOGLEVEL);
      break;
    case 12 :
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_LOCALROOTDIR, NETWOX_WEBSPIDERCF_VAR_LOCALROOTDIR);
      break;
    case 14 :
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_LINKCONVERSION, NETWOX_WEBSPIDERCF_VAR_LINKCONVERSION);
      break;
    }
    break;
  case 'm' :
    switch(datasize) {
    case 10 :
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_MAXTHREADS, NETWOX_WEBSPIDERCF_VAR_MAXTHREADS);
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_MILLISLEEP, NETWOX_WEBSPIDERCF_VAR_MILLISLEEP);
      break;
    case 11 :
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_MAXTOTALLEN, NETWOX_WEBSPIDERCF_VAR_MAXTOTALLEN);
      break;
    case 12 :
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_MAXRECURSION, NETWOX_WEBSPIDERCF_VAR_MAXRECURSION);
      break;
    case 13 :
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_MAXSEGMENTLEN, NETWOX_WEBSPIDERCF_VAR_MAXSEGMENTLEN);
      break;
    }
    break;
  case 'p' :
    if (datasize == 9) {
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_PROXYHOST, NETWOX_WEBSPIDERCF_VAR_PROXYHOST);
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_PROXYPORT, NETWOX_WEBSPIDERCF_VAR_PROXYPORT);
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_PROXYUSER, NETWOX_WEBSPIDERCF_VAR_PROXYUSER);
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_PROXYPASS, NETWOX_WEBSPIDERCF_VAR_PROXYPASS);
    }
    break;
  case 't' :
    if (datasize == 9) {
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_TIMEOUTMS, NETWOX_WEBSPIDERCF_VAR_TIMEOUTMS);
    }
    break;
  case 'u' :
    switch(datasize) {
    case 9 :
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_USERAGENT, NETWOX_WEBSPIDERCF_VAR_USERAGENT);
      break;
    case 13 :
      netwox_webspidercf_var_init_buf_text(NETWOX_WEBSPIDERCF_VARNAME_URLTODOWNLOAD, NETWOX_WEBSPIDERCF_VAR_URLTODOWNLOAD);
      break;
    }
    break;
  }

  if (pvar != NULL) *pvar = NETWOX_WEBSPIDERCF_VAR_UNKNOWN;
  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_webspidercf_write_sample(netwib_constbuf *pfilename)
{
  netwib_io *pio;
  netwib_bufpool *pbufpool;
  netwib_buf cmt, var, val;

  netwib_er(netwib_bufpool_initdefault(&pbufpool));
  netwib_er(netwox_io_init_conffile_write(pfilename, &pio));

  netwib_er(netwox_conffile_write_help(pbufpool, pio));

  netwib_er(netwib_buf_init_ext_text("Variable localrootdir contains directory name where files have to be saved", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_LOCALROOTDIR, &var));
  netwib_er(netwib_buf_init_ext_text(NETWOX_DIREX, &val));
  netwib_er(netwox_conffile_write_var(pbufpool, pio, &var, &val));
  netwib_er(netwox_conffile_write_empty(pio));

  netwib_er(netwib_buf_init_ext_text("Variable urltodownload contains url to download", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_URLTODOWNLOAD, &var));
  netwib_er(netwib_buf_init_ext_text("http://www.example.com/dir/page.html", &val));
  netwib_er(netwox_conffile_write_var(pbufpool, pio, &var, &val));
  netwib_er(netwox_conffile_write_empty(pio));

  netwib_er(netwib_buf_init_ext_text("Variables proxyuser, proxypass, proxyhost, proxyport contains proxy", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text("information (comment it if you do not have a proxy)", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_PROXYHOST, &var));
  netwib_er(netwib_buf_init_ext_text("proxy.example.com", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_PROXYPORT, &var));
  netwib_er(netwox_conffile_write_varcmt_uint32(pbufpool, pio, &var, 8080));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_PROXYUSER, &var));
  netwib_er(netwib_buf_init_ext_text("joe", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_PROXYPASS, &var));
  netwib_er(netwib_buf_init_ext_text("mypwd", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwox_conffile_write_empty(pio));

  netwib_er(netwib_buf_init_ext_text("Variable maxrecursion contains maximum recursion level", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text("(0 means no limit)", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_MAXRECURSION, &var));
  netwib_er(netwox_conffile_write_var_uint32(pbufpool, pio, &var, 0));
  netwib_er(netwox_conffile_write_empty(pio));

  netwib_er(netwib_buf_init_ext_text("Variable maxthreads contains maximum number of threads to use", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text("(recommended : forlocalsite=1, forremotesite=5)", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_MAXTHREADS, &var));
  netwib_er(netwox_conffile_write_var_uint32(pbufpool, pio, &var, 5));
  netwib_er(netwox_conffile_write_empty(pio));

  netwib_er(netwib_buf_init_ext_text("Variable maxsegmentlen specifies maximum length of a segment ", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text("of file/directory (recommended : 32 ; minimum : 8)", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_MAXSEGMENTLEN, &var));
  netwib_er(netwox_conffile_write_var_uint32(pbufpool, pio, &var, 32));
  netwib_er(netwox_conffile_write_empty(pio));

  netwib_er(netwib_buf_init_ext_text("Variable maxtotallen specifies maximum length of the full ", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text("pathname (recommended : 230)", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_MAXTOTALLEN, &var));
  netwib_er(netwox_conffile_write_var_uint32(pbufpool, pio, &var, 230));
  netwib_er(netwox_conffile_write_empty(pio));

  netwib_er(netwib_buf_init_ext_text("Variable millisleep contains time to wait between each download", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text("(recommended : 1000)", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_MILLISLEEP, &var));
  netwib_er(netwox_conffile_write_var_uint32(pbufpool, pio, &var, 0));
  netwib_er(netwox_conffile_write_empty(pio));

  netwib_er(netwib_buf_init_ext_text("This block defines ACL for urls, expressed as regular expressions. Syntax", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text("can be very complex (read rulesfile.h). Starting chain is 1. Comment this", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text("part to allow everything. ACL definition is enclosed between acl=url", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text("and acl=end", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));

  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_ACL, &var));
  netwib_er(netwib_buf_init_ext_text("url", &val));
  netwib_er(netwox_conffile_write_var(pbufpool, pio, &var, &val));
  /**/
  netwib_er(netwib_buf_init_ext_text("First example (only accept /dir subdirectory):", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_DEFAULTTARGET, &var));
  netwib_er(netwib_buf_init_ext_text("reject", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_CHAINNUMBER, &var));
  netwib_er(netwox_conffile_write_varcmt_uint32(pbufpool, pio, &var, 1));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_CHAINDEFAULTTARGET, &var));
  netwib_er(netwib_buf_init_ext_text("reject", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_RULETARGET, &var));
  netwib_er(netwib_buf_init_ext_text("accept", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_RULE, &var));
  netwib_er(netwib_buf_init_ext_text("^http://www\\.example\\.com/dir/", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  /**/
  netwib_er(netwib_buf_init_ext_text("Second example (only accept /dir and /mydir subdirectories):", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_DEFAULTTARGET, &var));
  netwib_er(netwib_buf_init_ext_text("reject", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_CHAINNUMBER, &var));
  netwib_er(netwox_conffile_write_varcmt_uint32(pbufpool, pio, &var, 1));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_CHAINDEFAULTTARGET, &var));
  netwib_er(netwib_buf_init_ext_text("reject", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_RULETARGET, &var));
  netwib_er(netwib_buf_init_ext_text("accept", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_RULE, &var));
  netwib_er(netwib_buf_init_ext_text("^http://www\\.example\\.com/dir/", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_RULETARGET, &var));
  netwib_er(netwib_buf_init_ext_text("accept", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_RULE, &var));
  netwib_er(netwib_buf_init_ext_text("^http://www\\.example\\.com/mydir/", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  /**/
  netwib_er(netwib_buf_init_ext_text("Third example (subdirectory /dir except privatedir and mp3):", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_DEFAULTTARGET, &var));
  netwib_er(netwib_buf_init_ext_text("reject", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_CHAINNUMBER, &var));
  netwib_er(netwox_conffile_write_varcmt_uint32(pbufpool, pio, &var, 1));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_CHAINDEFAULTTARGET, &var));
  netwib_er(netwib_buf_init_ext_text("return", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_RULETARGET, &var));
  netwib_er(netwib_buf_init_ext_text("jump 2", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_RULE, &var));
  netwib_er(netwib_buf_init_ext_text("^http://www\\.example\\.com/dir/", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_RULETARGET, &var));
  netwib_er(netwib_buf_init_ext_text("jump 2", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_RULE, &var));
  netwib_er(netwib_buf_init_ext_text("^http://1.2.3.4/dir/", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_CHAINNUMBER, &var));
  netwib_er(netwox_conffile_write_varcmt_uint32(pbufpool, pio, &var, 2));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_CHAINDEFAULTTARGET, &var));
  netwib_er(netwib_buf_init_ext_text("accept", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_RULETARGET, &var));
  netwib_er(netwib_buf_init_ext_text("reject", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_RULE, &var));
  netwib_er(netwib_buf_init_ext_text("/privatedir/", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_RULETARGET, &var));
  netwib_er(netwib_buf_init_ext_text("reject", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_RULESFILE_VARNAME_RULE, &var));
  netwib_er(netwib_buf_init_ext_text("\\.mp3$", &val));
  netwib_er(netwox_conffile_write_varcmt(pbufpool, pio, &var, &val));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_ACL, &var));
  netwib_er(netwib_buf_init_ext_text("end", &val));
  netwib_er(netwox_conffile_write_var(pbufpool, pio, &var, &val));
  netwib_er(netwox_conffile_write_empty(pio));

  netwib_er(netwib_buf_init_ext_text("Variable getimage indicates if we want to download", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text("images (0=no, 1=yes)", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_GETIMAGE, &var));
  netwib_er(netwox_conffile_write_var_uint32(pbufpool, pio, &var, 1));
  netwib_er(netwox_conffile_write_empty(pio));

  netwib_er(netwib_buf_init_ext_text("Variable getmultimedia indicates if we want to download", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text("multimedia documents (0=no, 1=yes)", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_GETMULTIMEDIA, &var));
  netwib_er(netwox_conffile_write_var_uint32(pbufpool, pio, &var, 1));
  netwib_er(netwox_conffile_write_empty(pio));

  netwib_er(netwib_buf_init_ext_text("Variable getcode indicates if we want to download", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text("script code (0=no, 1=yes)", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_GETCODE, &var));
  netwib_er(netwox_conffile_write_var_uint32(pbufpool, pio, &var, 1));
  netwib_er(netwox_conffile_write_empty(pio));

  netwib_er(netwib_buf_init_ext_text("Variable linkconversion indicates how to convert links in files after", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text("downloading (0: no conversion, 1: point links not downloaded to the", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text("web location)", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_LINKCONVERSION, &var));
  netwib_er(netwox_conffile_write_var_uint32(pbufpool, pio, &var, 1));
  netwib_er(netwox_conffile_write_empty(pio));

  netwib_er(netwib_buf_init_ext_text("Variable useragent contains the name of User-Agent", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_USERAGENT, &var));
  netwib_er(netwib_buf_init_ext_text("Mozilla/4.79", &val));
  netwib_er(netwox_conffile_write_var(pbufpool, pio, &var, &val));
  netwib_er(netwox_conffile_write_empty(pio));

  netwib_er(netwib_buf_init_ext_text("Variable loglevel indicates how to log events on", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text("stdout (0:none ; 1:normal ; 2:'...' ; 3:threadnumber%10 ; 4:scale ;", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text("5:fraction)", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_LOGLEVEL, &var));
  netwib_er(netwox_conffile_write_var_uint32(pbufpool, pio, &var, 1));
  netwib_er(netwox_conffile_write_empty(pio));

  netwib_er(netwib_buf_init_ext_text("Variable ftppassive indicates if use passive FTP (instead of active FTP)", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_FTPPASSIVE,
                                     &var));
  netwib_er(netwox_conffile_write_var_uint32(pbufpool, pio, &var, 1));
  netwib_er(netwox_conffile_write_empty(pio));

  netwib_er(netwib_buf_init_ext_text("Variable timeoutms indicates timeout in milli-seconds", &cmt));
  netwib_er(netwox_conffile_write_cmt(pbufpool, pio, &cmt));
  netwib_er(netwib_buf_init_ext_text(NETWOX_WEBSPIDERCF_VARNAME_TIMEOUTMS, &var));
  netwib_er(netwox_conffile_write_var_uint32(pbufpool, pio, &var, 30000));
  netwib_er(netwox_conffile_write_empty(pio));

  netwib_er(netwib_io_close(&pio));
  netwib_er(netwib_bufpool_close(&pbufpool));

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
static netwib_err netwox_webspidercf_update(netwox_webspider *pwebspider,
                                            netwib_constbuf *pvar,
                                            netwib_constbuf *pvalbuf,
                                            netwib_bool valuintdecoded,
                                            netwib_uint32 valuint,
                                            netwib_bool *pinacl,
                                           netwox_rulesfile_state *prulesstate)
{
  netwox_webspidercf_var var;

  netwib_er(netwox_webspidercf_var_init_buf(pvar, &var));

  /* simple toggle for ACL */
  if (var == NETWOX_WEBSPIDERCF_VAR_ACL) {
    *pinacl = ! *pinacl;
    return(NETWIB_ERR_OK);
  }

  /* if in ACL, give info to specific function */
  if (*pinacl) {
    pwebspider->aclurlset = NETWIB_TRUE;
    return(netwox_rulesfile_state_addvar(pwebspider->paclurl, prulesstate,
                                         pvar, pvalbuf));
  }

  /* check if variable name is known */
  if (var == NETWOX_WEBSPIDERCF_VAR_UNKNOWN) {
    netwib_er(netwib_fmt_display("Error : variable %{buf} is not recognized\n",
                                 pvar));
    return(NETWIB_ERR_PAINVALIDTYPE);
  }

  /* check integers */
  switch(var) {
  case NETWOX_WEBSPIDERCF_VAR_PROXYPORT :
  case NETWOX_WEBSPIDERCF_VAR_MAXRECURSION :
  case NETWOX_WEBSPIDERCF_VAR_MAXTHREADS :
  case NETWOX_WEBSPIDERCF_VAR_MAXSEGMENTLEN :
  case NETWOX_WEBSPIDERCF_VAR_MAXTOTALLEN :
  case NETWOX_WEBSPIDERCF_VAR_MILLISLEEP :
  case NETWOX_WEBSPIDERCF_VAR_GETIMAGE :
  case NETWOX_WEBSPIDERCF_VAR_GETMULTIMEDIA :
  case NETWOX_WEBSPIDERCF_VAR_GETCODE :
  case NETWOX_WEBSPIDERCF_VAR_LINKCONVERSION :
  case NETWOX_WEBSPIDERCF_VAR_LOGLEVEL :
  case NETWOX_WEBSPIDERCF_VAR_FTPPASSIVE :
  case NETWOX_WEBSPIDERCF_VAR_TIMEOUTMS :
    if (!valuintdecoded) {
      netwib_er(netwib_fmt_display("Error : variable %{buf} must be set to an integer ('%{buf}' is not an integer)\n", pvar, pvalbuf));
      return(NETWIB_ERR_PAINVALIDTYPE);
    }
    break;
  default:
    break;
  }

  /* set variable */
  switch(var) {
  case NETWOX_WEBSPIDERCF_VAR_LOCALROOTDIR :
    netwib__buf_reinit(&pwebspider->localrootdir);
    netwib_er(netwib_path_canon(pvalbuf, &pwebspider->localrootdir));
    break;
  case NETWOX_WEBSPIDERCF_VAR_URLTODOWNLOAD :
    netwib_er(netwox_webspider_add_canon(pwebspider, pvalbuf));
    break;
  case NETWOX_WEBSPIDERCF_VAR_PROXYHOST :
    pwebspider->httpclictx.useproxy = NETWIB_TRUE;
    netwib_er(netwox_dnscache_ip(&pwebspider->httpclictx.dnscache, pvalbuf,
                                 &pwebspider->httpclictx.proxy_ip));
    break;
  case NETWOX_WEBSPIDERCF_VAR_PROXYPORT :
    pwebspider->httpclictx.proxy_port = valuint;
    break;
  case NETWOX_WEBSPIDERCF_VAR_PROXYUSER :
    netwib__buf_reinit(&pwebspider->httpclictx.proxy_login);
    netwib_er(netwib_buf_append_buf(pvalbuf,
                                    &pwebspider->httpclictx.proxy_login));
    break;
  case NETWOX_WEBSPIDERCF_VAR_PROXYPASS :
    netwib__buf_reinit(&pwebspider->httpclictx.proxy_password);
    netwib_er(netwib_buf_append_buf(pvalbuf,
                                    &pwebspider->httpclictx.proxy_password));
    break;
  case NETWOX_WEBSPIDERCF_VAR_MAXRECURSION :
    pwebspider->maxrecursion = valuint;
    break;
  case NETWOX_WEBSPIDERCF_VAR_MAXTHREADS :
    if (valuint == 0) {
      pwebspider->maxthreads = 100;
    } else {
      pwebspider->maxthreads = valuint;
    }
    break;
  case NETWOX_WEBSPIDERCF_VAR_MAXSEGMENTLEN :
    pwebspider->maxsegmentlen = valuint;
    break;
  case NETWOX_WEBSPIDERCF_VAR_MAXTOTALLEN :
    pwebspider->maxtotallen = valuint;
    break;
  case NETWOX_WEBSPIDERCF_VAR_MILLISLEEP :
    pwebspider->millisleep = valuint;
    break;
  case NETWOX_WEBSPIDERCF_VAR_GETIMAGE :
    pwebspider->getimage = valuint;
    break;
  case NETWOX_WEBSPIDERCF_VAR_GETMULTIMEDIA :
    pwebspider->getmultimedia = valuint;
    break;
  case NETWOX_WEBSPIDERCF_VAR_GETCODE :
    pwebspider->getcode = valuint;
    break;
  case NETWOX_WEBSPIDERCF_VAR_LINKCONVERSION :
    pwebspider->linkconv = valuint;
    break;
  case NETWOX_WEBSPIDERCF_VAR_USERAGENT :
    netwib__buf_reinit(&pwebspider->httpclictx.useragent);
    netwib_er(netwib_buf_append_buf(pvalbuf,
                                    &pwebspider->httpclictx.useragent));
    break;
  case NETWOX_WEBSPIDERCF_VAR_LOGLEVEL :
    pwebspider->loglevel = valuint;
    break;
  case NETWOX_WEBSPIDERCF_VAR_FTPPASSIVE :
    pwebspider->httpclictx.ftp_passive = valuint;
    break;
  case NETWOX_WEBSPIDERCF_VAR_TIMEOUTMS :
    pwebspider->httpclictx.timeoutms = valuint;
    break;
  default:
    return(NETWOX_ERR_INTERNALERROR);
    break;
  }

  return(NETWIB_ERR_OK);
}

/*-------------------------------------------------------------*/
netwib_err netwox_webspidercf_read(netwib_constbuf *pfilename,
                                   netwox_webspider *pwebspider)
{
  netwib_io *pio;
  netwib_buf *pvar, *pval;
  netwib_bufpool *pbufpool;
  netwib_bool uidec, inacl;
  netwox_rulesfile_state rulesstate;
  netwib_uint32 ui;
  netwib_err ret;

  netwib_er(netwib_bufpool_initdefault(&pbufpool));

  netwib_er(netwox_io_init_conffile_read(pfilename, &pio));
  netwib_er(netwib_bufpool_buf_init(pbufpool, &pvar));
  netwib_er(netwib_bufpool_buf_init(pbufpool, &pval));
  netwib_er(netwox_rulesfile_state_init(&rulesstate));

  ret = NETWIB_ERR_OK;
  inacl = NETWIB_FALSE;
  while (NETWIB_TRUE) {
    /* read */
    netwib__buf_reinit(pvar);
    netwib__buf_reinit(pval);
    ret = netwox_conffile_read_var(pbufpool, pio, pvar, pval, &uidec, &ui);
    if (ret != NETWIB_ERR_OK) {
      if (ret == NETWIB_ERR_DATAEND) ret = NETWIB_ERR_OK;
      break;
    }
    /*
    if (uidec) {
      netwib_er(netwib_fmt_display("%{buf} =u %{uint32}\n", pvar, ui));
    } else {
      netwib_er(netwib_fmt_display("%{buf} = %{buf}\n", pvar, pval));
    }
    */
    /* update configuration */
    ret = netwox_webspidercf_update(pwebspider, pvar, pval, uidec, ui,
                                    &inacl, &rulesstate);
    if (ret != NETWIB_ERR_OK) {
      break;
    }
  }

  netwib_er(netwox_rulesfile_state_close(&rulesstate));
  netwib_er(netwib_bufpool_buf_close(pbufpool, &pvar));
  netwib_er(netwib_bufpool_buf_close(pbufpool, &pval));
  netwib_er(netwib_io_close(&pio));

  netwib_er(netwib_bufpool_close(&pbufpool));

  return(ret);
}
