/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddRepEntity.cpp: implementation of the DlgAddRepEntity class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgAddRepEntity.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgAddRepEntity, wxDialog)
    EVT_BUTTON(IDC_OK, DlgAddRepEntity::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgAddRepEntity::OnCancel)
    EVT_RADIOBUTTON(IDC_KEY_SERVER_ENTITY, DlgAddRepEntity::OnServerKeyEntity)
    EVT_RADIOBUTTON(IDC_KEY_ENGINE_ENTITY, DlgAddRepEntity::OnEngineKeyEntity)
END_EVENT_TABLE()


DlgAddRepEntity::DlgAddRepEntity(wxWindow * wParent, PkiClient * ClientPki):DlgAddEntity(wParent, _("Add Repository Entity"), ClientPki)
{
	wxString mPort;
	DlgAddRepEntity_SetWindow(this);

	LoadKeyLen((wxComboBox *)FindWindow(IDC_LIST_LEN_ENTITY));

	((wxTextCtrl *)FindWindow(IDC_SERVER))->SetValue(ClientPki->GetRemoteServer().c_str());
	mPort.sprintf("%d", ClientPki->GetRemotePort());
	((wxTextCtrl *)FindWindow(IDC_PORT))->SetValue(mPort);

	wxCommandEvent event2;
	OnServerKeyEntity(event2);

	CenterOnScreen();
	ShowModal();
}

DlgAddRepEntity::~DlgAddRepEntity()
{
}

void DlgAddRepEntity::OnOk(wxCommandEvent& event)
{
	int nItem;
	wxString m_KeyId;
	int RsaLen;	
	GenPrivateKey entity_key;
	wxString m_EntityName;
	wxString m_EntityMail;
	wxString m_Server;
	wxString m_Port;
	unsigned int port;


	m_EntityName = ((wxTextCtrl *)FindWindow(IDC_ENTITY_NAME))->GetValue();
	if(!m_EntityName.Len())
	{
		return;
	}
	m_EntityMail = ((wxTextCtrl *)FindWindow(IDC_EMAIL))->GetValue();
	if(!m_EntityMail.Len())
	{
		return;
	}
	m_Port = ((wxTextCtrl *)FindWindow(IDC_PORT))->GetValue();
	if(!m_Port.Len())
	{
		return;
	}
	m_Server = ((wxTextCtrl *)FindWindow(IDC_SERVER))->GetValue();
	if(!m_Server.Len())
	{
		return;
	}
	sscanf((char*)m_Port.GetData(), "%d", &port);
		
	// Entity Cert KEY
	if( ((wxRadioButton *)FindWindow(IDC_KEY_ENGINE_ENTITY))->GetValue() )
	{
		if( !((wxTextCtrl *)FindWindow(IDC_KEY_ID_ENTITY))->GetValue().Len() )
		{
			return;
		}
		m_KeyId = ENGINE_HEAD;
		m_KeyId += ((wxTextCtrl *)FindWindow(IDC_KEY_ID_ENTITY))->GetValue();
		
		if(!entity_key.set_type(GEN_PRIVATE_KEY_TYPE_ENGINE))
		{
			HandleErrorResult(NULL, this, 0);
			return;
		}
		entity_key.set_keyid(m_KeyId.GetData());
	}
	else
	{
		nItem = ((wxComboBox *)FindWindow(IDC_LIST_LEN_ENTITY))->GetSelection();
		RsaLen = (long)((wxComboBox *)FindWindow(IDC_LIST_LEN_ENTITY))->GetClientData(nItem);
		
		if(!entity_key.set_type(GEN_PRIVATE_KEY_TYPE_KEYLEN))
		{
			HandleErrorResult(NULL, this, 0);
			return;
		}
		entity_key.set_keylen(RsaLen);
	}

	if(!AddEntity(m_EntityName.GetData(), m_EntityMail.GetData(), ENTITY_TYPE_REPOSITORY, entity_key, PubCreationReq::EmptyInstance, m_Server.GetData(), port))
		return;

	m_IsOK = true;
	Close(TRUE);
}

void DlgAddRepEntity::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}


void DlgAddRepEntity::OnServerKeyEntity(wxCommandEvent &event)
{
	OnServerKey(IDC_LBL_KEYID_ENTITY, IDC_KEY_ID_ENTITY, IDC_LBL_KEYLEN_ENTITY, IDC_LIST_LEN_ENTITY);
}

void DlgAddRepEntity::OnEngineKeyEntity(wxCommandEvent &event)
{
	OnEngineKey(IDC_LBL_KEYID_ENTITY, IDC_KEY_ID_ENTITY, IDC_LBL_KEYLEN_ENTITY, IDC_LIST_LEN_ENTITY);
}

