/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgConfigureRA.cpp: implementation of the DlgConfigureRA class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgManageExt.h"
#include "DlgConfigurePlugin.h"
#include "DlgConfigureRA.h"
#include "DlgAddValueDN.h"
#include "DlgAddValuePol.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////


BEGIN_EVENT_TABLE(DlgConfigureRA, wxDialog)
    EVT_BUTTON(IDC_OK, DlgConfigureEntity::OnOk)
	EVT_CHECKBOX(IDC_FROM_LDAP_PROFILE, DlgConfigureRA::OnLdapImport)
	EVT_CHECKBOX(IDC_LDAP_AUTO_SYNCH, DlgConfigureRA::OnLdapAutoSynch)
    EVT_BUTTON(IDC_CANCEL, DlgConfigureEntity::OnCancel)
    EVT_BUTTON(IDC_DN_ADD, DlgConfigureRA::OnAddDnValue)
    EVT_BUTTON(IDC_DN_DEL, DlgConfigureRA::OnDelDnValue)
    EVT_BUTTON(IDC_DN_MOD, DlgConfigureRA::OnModifyDnValue)
    EVT_BUTTON(IDC_MOVE_UP, DlgConfigureRA::OnMoveDnUp)
    EVT_BUTTON(IDC_MOVE_DOWN, DlgConfigureRA::OnMoveDnDown)
    EVT_BUTTON(IDC_POL_ADD, DlgConfigureRA::OnAddPolValue)
    EVT_BUTTON(IDC_POL_DEL, DlgConfigureRA::OnDelPolValue)
    EVT_BUTTON(IDC_POL_MOD, DlgConfigureRA::OnModifyPolValue)
END_EVENT_TABLE()


DlgConfigureRA::DlgConfigureRA(wxWindow * wParent, const PKI_CERT & entity_cert, PkiClient * ClientPki):DlgConfigureEntity(wParent, entity_cert, ClientPki)
{
	DlgConfigureRA_SetWindow(this);
	Frames = (wxNotebook*)FindWindow(ID_NOTEBOOK);
	
	
	((wxComboBox *)Frames->FindWindow(IDC_MIN_KEY_LEN))->Append("8192 bits", (void*)8192);
	((wxComboBox *)Frames->FindWindow(IDC_MIN_KEY_LEN))->Append("4096 bits", (void*)4096);
	((wxComboBox *)Frames->FindWindow(IDC_MIN_KEY_LEN))->Append("2048 bits", (void*)2048);
	((wxComboBox *)Frames->FindWindow(IDC_MIN_KEY_LEN))->Append("1024 bits", (void*)1024);
	((wxComboBox *)Frames->FindWindow(IDC_MIN_KEY_LEN))->Append("512 bits", (void*)512);
	((wxComboBox *)Frames->FindWindow(IDC_MIN_KEY_LEN))->SetSelection(3);
	
	
	wxIcon ico;
	m_imageListSmall = new wxImageList(16, 16, TRUE);	
	ico.CopyFromBitmap(DlgConfigureRA_GetBitmap(0));
	m_imageListSmall->Add(ico);
	ico.CopyFromBitmap(DlgConfigureRA_GetBitmap(1));
	m_imageListSmall->Add(ico);



	m_listPol = (wxListCtrl*)Frames->FindWindow(IDC_LIST_POL);
	m_listPol->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);

	m_listPol->InsertColumn(0, _("Field"), wxLIST_FORMAT_LEFT, 135);
	m_listPol->InsertColumn(1, _("Value"), wxLIST_FORMAT_LEFT, 198);
	

	m_listDn = (wxListCtrl*)Frames->FindWindow(IDC_LIST_DN);
	m_listDn->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);

	m_listDn->InsertColumn(0, _("Name"), wxLIST_FORMAT_LEFT, 150);
	m_listDn->InsertColumn(1, _("Value"), wxLIST_FORMAT_LEFT, 140);
	m_listDn->InsertColumn(2, _("Comment"), wxLIST_FORMAT_LEFT, 140);
	m_listDn->InsertColumn(3, _("Min"), wxLIST_FORMAT_LEFT, 35);
	m_listDn->InsertColumn(4, _("Max"), wxLIST_FORMAT_LEFT, 35);


	if(!Init(ENTITY_TYPE_RA))
	{
		Close(TRUE);
		return;
	}

	CenterOnScreen();
	ShowModal();		
}

DlgConfigureRA::~DlgConfigureRA()
{
}

bool DlgConfigureRA::DisplayConf()
{
	wxString Port;
	size_t i;
	wxString Value;
	int selection;

	if(ASN1_BIT_STRING_get_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_ALLOW_SERVER_SIDE_KEY_GEN))
		((wxCheckBox *)Frames->FindWindow(IDC_FROM_RA_KEYGEN))->SetValue(TRUE);
	else
		((wxCheckBox *)Frames->FindWindow(IDC_FROM_RA_KEYGEN))->SetValue(FALSE);

	if(ASN1_BIT_STRING_get_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_ALLOW_PKCS10_IMPORT))
		((wxCheckBox *)Frames->FindWindow(IDC_ALLOW_PKCS10_IMPORT))->SetValue(TRUE);
	else
		((wxCheckBox *)Frames->FindWindow(IDC_ALLOW_PKCS10_IMPORT))->SetValue(FALSE);

	if(ASN1_BIT_STRING_get_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_ALLOW_OP_SC_KEY_GEN))
		((wxCheckBox *)Frames->FindWindow(IDC_RA_GEN_KEY_SC))->SetValue(TRUE);
	else
		((wxCheckBox *)Frames->FindWindow(IDC_RA_GEN_KEY_SC))->SetValue(FALSE);

	if(ASN1_BIT_STRING_get_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_PUSH_KEYS_TO_KEY_ESCROW))
		((wxCheckBox *)Frames->FindWindow(IDC_PUBLISH_ALL_TO_KEY_ESCROW))->SetValue(TRUE);
	else
		((wxCheckBox *)Frames->FindWindow(IDC_PUBLISH_ALL_TO_KEY_ESCROW))->SetValue(FALSE);

	if(ASN1_BIT_STRING_get_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_REMOVE_UNKNOWN_DN_FIELDS))
		((wxCheckBox *)Frames->FindWindow(IDC_REMOVE_UNKNOWN_DN))->SetValue(TRUE);
	else
		((wxCheckBox *)Frames->FindWindow(IDC_REMOVE_UNKNOWN_DN))->SetValue(FALSE);

	if(ASN1_BIT_STRING_get_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_ALLOW_LDAP_PROFILE_IMPORT))
		((wxCheckBox *)Frames->FindWindow(IDC_FROM_LDAP_PROFILE))->SetValue(TRUE);
	else
		((wxCheckBox *)Frames->FindWindow(IDC_FROM_LDAP_PROFILE))->SetValue(FALSE);

	if(m_EntityConf.get_raConf().RA_CONF_PTR.get_ldapUtf8())
		((wxCheckBox *)Frames->FindWindow(IDC_UTF8))->SetValue(TRUE);
	else
		((wxCheckBox *)Frames->FindWindow(IDC_UTF8))->SetValue(FALSE);

	if(ASN1_BIT_STRING_get_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_ALLOW_LDAP_AUTO_SYNCH))
		((wxCheckBox *)Frames->FindWindow(IDC_LDAP_AUTO_SYNCH))->SetValue(TRUE);
	else
		((wxCheckBox *)Frames->FindWindow(IDC_LDAP_AUTO_SYNCH))->SetValue(FALSE);

	if(ASN1_BIT_STRING_get_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_WARN_PROFILE_OWNER_EXPIRING))
		((wxCheckBox *)Frames->FindWindow(IDC_WARN_EXPIRY))->SetValue(TRUE);
	else
		((wxCheckBox *)Frames->FindWindow(IDC_WARN_EXPIRY))->SetValue(FALSE);

	if(ASN1_BIT_STRING_get_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_EE_PROFILES_REQUIRE_VALIDATION))
		((wxCheckBox *)Frames->FindWindow(IDC_ADMIN_VALIDATE_EE))->SetValue(TRUE);
	else
		((wxCheckBox *)Frames->FindWindow(IDC_ADMIN_VALIDATE_EE))->SetValue(FALSE);

	if(m_EntityConf.get_raConf().RA_CONF_PTR.get_ldapPort())
		Port.sprintf("%ld", m_EntityConf.get_raConf().RA_CONF_PTR.get_ldapPort());
	else
		Port = "389";

	((wxTextCtrl *)Frames->FindWindow(IDC_SERVER))->SetValue(m_EntityConf.get_raConf().RA_CONF_PTR.get_ldapServer().c_str());
	((wxTextCtrl *)Frames->FindWindow(IDC_PORT))->SetValue(Port);
	((wxTextCtrl *)Frames->FindWindow(IDC_USERNAME))->SetValue(m_EntityConf.get_raConf().RA_CONF_PTR.get_ldapUsername().c_str());
	((wxTextCtrl *)Frames->FindWindow(IDC_PASSWORD))->SetValue(m_EntityConf.get_raConf().RA_CONF_PTR.get_ldapPassword().c_str());
	((wxTextCtrl *)Frames->FindWindow(IDC_BASE))->SetValue(m_EntityConf.get_raConf().RA_CONF_PTR.get_ldapBase().c_str());
	((wxTextCtrl *)Frames->FindWindow(IDC_FILTERS))->SetValue(m_EntityConf.get_raConf().RA_CONF_PTR.get_ldapFilters().c_str());
	((wxTextCtrl *)Frames->FindWindow(IDC_ATTR_NAME))->SetValue(m_EntityConf.get_raConf().RA_CONF_PTR.get_ldapAttrName().c_str());


	if(m_EntityConf.get_raConf().RA_CONF_PTR.get_defaultValidity())
		Port.sprintf("%ld", m_EntityConf.get_raConf().RA_CONF_PTR.get_defaultValidity());
	else
		Port = "365";
	((wxTextCtrl *)Frames->FindWindow(IDC_VALIDITY))->SetValue(Port);


	for(i=0; i<(size_t)((wxComboBox *)Frames->FindWindow(IDC_MIN_KEY_LEN))->GetCount(); i++)
	{
		if( (unsigned long)((wxComboBox *)Frames->FindWindow(IDC_MIN_KEY_LEN))->GetClientData(i) == m_EntityConf.get_raConf().RA_CONF_PTR.get_minkeylen())
		{
			((wxComboBox *)Frames->FindWindow(IDC_MIN_KEY_LEN))->SetSelection(i);
			break;
		}
	}

	Value.sprintf("%ld", m_EntityConf.get_raConf().RA_CONF_PTR.get_minpwdlen());
	if(Value != "0")
		((wxTextCtrl *)Frames->FindWindow(IDC_MIN_PWD_LEN))->SetValue(Value);


	

	selection = 0;
	for(i=0; i<m_Groups.size(); i++)
	{
		((wxComboBox *)Frames->FindWindow(IDC_GROUPS))->Append(m_Groups[i].get_name().c_str(), (void*)m_Groups[i].get_serial());
		((wxComboBox *)Frames->FindWindow(IDC_EE_GROUPS))->Append(m_Groups[i].get_name().c_str(), (void*)m_Groups[i].get_serial());

		if(m_Groups[i].get_serial() == 
			m_EntityConf.get_raConf().get_conf1().get_eeProfilesGroup())
			selection = i;
	}
	((wxComboBox *)Frames->FindWindow(IDC_GROUPS))->SetSelection(0);
	((wxComboBox *)Frames->FindWindow(IDC_EE_GROUPS))->SetSelection(selection);
	
	
	
	
	LoadListDn();
	LoadListPol();

	wxCommandEvent event;
	OnLdapImport(event);
	return true;
}

bool DlgConfigureRA::SetConf()
{
	wxString Value;
	long lng;
	int SelectedItem;
	unsigned long OwnerGroup;

	if(((wxCheckBox *)Frames->FindWindow(IDC_FROM_RA_KEYGEN))->GetValue())
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_ALLOW_SERVER_SIDE_KEY_GEN, 1);
	else
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_ALLOW_SERVER_SIDE_KEY_GEN, 0);

	if(((wxCheckBox *)Frames->FindWindow(IDC_ALLOW_PKCS10_IMPORT))->GetValue())
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_ALLOW_PKCS10_IMPORT, 1);
	else
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_ALLOW_PKCS10_IMPORT, 0);

	if(((wxCheckBox *)Frames->FindWindow(IDC_RA_GEN_KEY_SC))->GetValue())
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_ALLOW_OP_SC_KEY_GEN, 1);
	else
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_ALLOW_OP_SC_KEY_GEN, 0);

	if(((wxCheckBox *)Frames->FindWindow(IDC_PUBLISH_ALL_TO_KEY_ESCROW))->GetValue())
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_PUSH_KEYS_TO_KEY_ESCROW, 1);
	else
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_PUSH_KEYS_TO_KEY_ESCROW, 0);

	if(((wxCheckBox *)Frames->FindWindow(IDC_REMOVE_UNKNOWN_DN))->GetValue())
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_REMOVE_UNKNOWN_DN_FIELDS, 1);
	else
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_REMOVE_UNKNOWN_DN_FIELDS, 0);

	if(((wxCheckBox *)Frames->FindWindow(IDC_WARN_EXPIRY))->GetValue())
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_WARN_PROFILE_OWNER_EXPIRING, 1);
	else
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_WARN_PROFILE_OWNER_EXPIRING, 0);

	if(((wxCheckBox *)Frames->FindWindow(IDC_ADMIN_VALIDATE_EE))->GetValue())
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_EE_PROFILES_REQUIRE_VALIDATION, 1);
	else
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_EE_PROFILES_REQUIRE_VALIDATION, 0);

	if(((wxCheckBox *)Frames->FindWindow(IDC_FROM_LDAP_PROFILE))->GetValue())
	{
		Value = ((wxTextCtrl *)Frames->FindWindow(IDC_SERVER))->GetValue();
		if(!Value.Len())
		{
			HandleError(_("\"Server\" must have a value"), this);
			return false;
		}
		m_EntityConf.get_raConf().RA_CONF_PTR.set_ldapServer(Value.GetData());

		Value = ((wxTextCtrl *)Frames->FindWindow(IDC_PORT))->GetValue();
		if(!Value.Len())
		{
			HandleError(_("\"Port\" must have a value"), this);
			return false;
		}
		Value.ToLong(&lng);
		m_EntityConf.get_raConf().RA_CONF_PTR.set_ldapPort(lng);

		Value = ((wxTextCtrl *)Frames->FindWindow(IDC_USERNAME))->GetValue();
		m_EntityConf.get_raConf().RA_CONF_PTR.set_ldapUsername(Value.GetData());
		
		Value = ((wxTextCtrl *)Frames->FindWindow(IDC_PASSWORD))->GetValue();
		m_EntityConf.get_raConf().RA_CONF_PTR.set_ldapPassword(Value.GetData());

		Value = ((wxTextCtrl *)Frames->FindWindow(IDC_BASE))->GetValue();
		m_EntityConf.get_raConf().RA_CONF_PTR.set_ldapBase(Value.GetData());

		Value = ((wxTextCtrl *)Frames->FindWindow(IDC_ATTR_NAME))->GetValue();
		m_EntityConf.get_raConf().RA_CONF_PTR.set_ldapAttrName(Value.GetData());

		ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_ALLOW_LDAP_PROFILE_IMPORT, 1);

		Value = ((wxTextCtrl *)Frames->FindWindow(IDC_FILTERS))->GetValue();
		m_EntityConf.get_raConf().RA_CONF_PTR.set_ldapFilters(Value.GetData());

		if(((wxCheckBox *)Frames->FindWindow(IDC_UTF8))->GetValue())
			m_EntityConf.get_raConf().RA_CONF_PTR.set_ldapUtf8(1);
		else
			m_EntityConf.get_raConf().RA_CONF_PTR.set_ldapUtf8(0);

		if(((wxCheckBox *)Frames->FindWindow(IDC_LDAP_AUTO_SYNCH))->GetValue())
			ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_ALLOW_LDAP_AUTO_SYNCH, 1);
		else
			ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_ALLOW_LDAP_AUTO_SYNCH, 0);

		if(((wxCheckBox *)Frames->FindWindow(IDC_LDAP_AUTO_SYNCH))->GetValue())
		{
			if(!Value.Len())
			{
				HandleError(_("\"Unique Id attribute\" must have a value"), this);
				return false;
			}
		}

		SelectedItem = ((wxComboBox *)Frames->FindWindow(IDC_GROUPS))->GetSelection();
		if(SelectedItem == -1)
		{
			OwnerGroup = 0;
		}
		else
		{
			OwnerGroup = (unsigned long)((wxComboBox *)Frames->FindWindow(IDC_GROUPS))->GetClientData(SelectedItem);
		}
		if(!OwnerGroup)
		{
			ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_ALLOW_LDAP_AUTO_SYNCH, 0);
		}
		m_EntityConf.get_raConf().RA_CONF_PTR.set_ldapProfilesGroup(OwnerGroup);
	}
	else
	{
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_ALLOW_LDAP_PROFILE_IMPORT, 0);
		ASN1_BIT_STRING_set_bit(m_EntityConf.get_raConf().RA_CONF_PTR.get_flags(), RA_ALLOW_LDAP_AUTO_SYNCH, 0);
	}


	Value = ((wxTextCtrl *)Frames->FindWindow(IDC_VALIDITY))->GetValue();
	Value.ToLong(&lng);
	m_EntityConf.get_raConf().RA_CONF_PTR.set_defaultValidity(lng);

	int i = ((wxComboBox *)Frames->FindWindow(IDC_MIN_KEY_LEN))->GetSelection();
	m_EntityConf.get_raConf().RA_CONF_PTR.set_minkeylen((long)((wxComboBox *)Frames->FindWindow(IDC_MIN_KEY_LEN))->GetClientData(i));


	Value = ((wxTextCtrl *)Frames->FindWindow(IDC_MIN_PWD_LEN))->GetValue();
	Value.ToLong(&lng);
	m_EntityConf.get_raConf().RA_CONF_PTR.set_minpwdlen(lng);

	SelectedItem = ((wxComboBox *)Frames->FindWindow(IDC_EE_GROUPS))->GetSelection();
	if(SelectedItem == -1)
		OwnerGroup = 0;
	else
		OwnerGroup = (unsigned long)((wxComboBox *)Frames->FindWindow(IDC_EE_GROUPS))->GetClientData(SelectedItem);
	m_EntityConf.get_raConf().RA_CONF_PTR.set_eeProfilesGroup(OwnerGroup);


	return true;
}

void DlgConfigureRA::LoadListDn()
{
	size_t i;
	char Val[30];

	m_listDn->DeleteAllItems();

	for(i=0; i<m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs().size(); i++)
	{
		m_listDn->InsertItem(i, m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs()[i].get_name().c_str(), 0);
		m_listDn->SetItemData(i, (long)i);

		m_listDn->SetItem(i, 1, m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs()[i].get_default().c_str());
		m_listDn->SetItem(i, 2, m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs()[i].get_comment().c_str());
		sprintf(Val, "%ld", m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs()[i].get_min());
		m_listDn->SetItem(i, 3, Val);
		sprintf(Val, "%ld", m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs()[i].get_max());
		m_listDn->SetItem(i, 4, Val);
	}
}

void DlgConfigureRA::LoadListPol()
{
	size_t i;

	m_listPol->DeleteAllItems();

	for(i=0; i<m_EntityConf.get_raConf().RA_CONF_PTR.get_policies().size(); i++)
	{
		m_listPol->InsertItem(i, m_EntityConf.get_raConf().RA_CONF_PTR.get_policies()[i].get_name().c_str(), 1);
		m_listPol->SetItemData(i, (long)i);
		m_listPol->SetItem(i, 1, m_EntityConf.get_raConf().RA_CONF_PTR.get_policies()[i].get_value().c_str());
	}
}

void DlgConfigureRA::OnAddDnValue(wxCommandEvent& event)
{
	DnSpecs Value;
	size_t i;

	DlgAddValueDN Dlg(this, DnSpecs::EmptyInstance);

	if(!Dlg.IsOK()) return;
	Value = Dlg.GetValue();
	if(!Value)
		return;
	if(!IsValidObject(Value.get_name()))
	{
		HandleError(NEWPKIerrGetStr(ERROR_BAD_DATAS_FORMAT), this);
		return;
	}

	//Search if we already have one with this name!
	for(i=0; i<m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs().size(); i++)
	{
		if(m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs()[i].get_name() == Value.get_name())
		{
			m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs().erase(m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs().begin() + i);
			break;	
		}

	}

	m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs().push_back(Value);

	LoadListDn();
}

void DlgConfigureRA::OnDelDnValue(wxCommandEvent& event)
{
	size_t index;
	long SelectedItem;
	mString name;

	SelectedItem = m_listDn->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	index = (size_t)m_listDn->GetItemData(SelectedItem);

	name = m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs()[index].get_name();
	m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs().erase(
		m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs().begin() + index);

	LoadListDn();

	// Remove associated DN Policy
	for(index=0; index<m_EntityConf.get_raConf().RA_CONF_PTR.get_policies().size(); index++)
	{
		if(m_EntityConf.get_raConf().RA_CONF_PTR.get_policies()[index].get_name() == name)
		{
			m_EntityConf.get_raConf().RA_CONF_PTR.get_policies().erase(
				m_EntityConf.get_raConf().RA_CONF_PTR.get_policies().begin() + index);
			break;
		}
	}
	LoadListPol();
}

void DlgConfigureRA::OnModifyDnValue(wxCommandEvent& event)
{
	size_t index;
	long SelectedItem;

	SelectedItem = m_listDn->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	index = (size_t)m_listDn->GetItemData(SelectedItem);

	DlgAddValueDN Dlg(this, m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs()[index]);
	if(!Dlg.IsOK()) return;
	m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs()[index] = Dlg.GetValue();
	LoadListDn();
}

void DlgConfigureRA::OnMoveDnUp(wxCommandEvent& event)
{
	DnSpecs Value;
	long SelectedItem;
	size_t index;

	SelectedItem = m_listDn->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1 || SelectedItem == 0) return;
	index = (size_t)m_listDn->GetItemData(SelectedItem);

	if(index == 0)
		return;

	Value = m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs()[index-1];
	m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs()[index-1] = m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs()[index];
	m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs()[index] = Value;
	LoadListDn();
}

void DlgConfigureRA::OnMoveDnDown(wxCommandEvent& event)
{
	DnSpecs Value;
	long SelectedItem;
	size_t index;

	SelectedItem = m_listDn->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1 || SelectedItem == 0) return;
	index = (size_t)m_listDn->GetItemData(SelectedItem);

	if((index+1) == m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs().size())
		return;

	Value = m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs()[index+1];
	m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs()[index+1] = m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs()[index];
	m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs()[index] = Value;
	LoadListDn();
}

void DlgConfigureRA::OnAddPolValue(wxCommandEvent& event)
{
	mString mName;
	mString mValue;
	PolicyValue Value;
	size_t i;

	DlgAddValuePol Dlg(this, "", "", m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs());
	if(!Dlg.IsOK()) return;

	mName = Dlg.GetName();
	//Search if we already have one with this name!
	for(i=0; i<m_EntityConf.get_raConf().RA_CONF_PTR.get_policies().size(); i++)
	{
		if(m_EntityConf.get_raConf().RA_CONF_PTR.get_policies()[i].get_name() == mName)
		{
			m_EntityConf.get_raConf().RA_CONF_PTR.get_policies().erase(m_EntityConf.get_raConf().RA_CONF_PTR.get_policies().begin() + i);
			break;
		}

	}

	mValue = Dlg.GetValue();


	Value.set_name(mName);
	Value.set_value(mValue);
	m_EntityConf.get_raConf().RA_CONF_PTR.get_policies().push_back(Value);

	LoadListPol();
}

void DlgConfigureRA::OnModifyPolValue(wxCommandEvent& event)
{
	long SelectedItem;
	size_t index;
	
	SelectedItem = m_listPol->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	index = (size_t)m_listPol->GetItemData(SelectedItem);

	DlgAddValuePol Dlg(this, m_EntityConf.get_raConf().RA_CONF_PTR.get_policies()[index].get_name(), m_EntityConf.get_raConf().RA_CONF_PTR.get_policies()[index].get_value(), m_EntityConf.get_raConf().RA_CONF_PTR.get_dnspecs());
	if(!Dlg.IsOK()) return;

	m_EntityConf.get_raConf().RA_CONF_PTR.get_policies()[index].set_name(Dlg.GetName());
	m_EntityConf.get_raConf().RA_CONF_PTR.get_policies()[index].set_value(Dlg.GetValue());

	LoadListPol();
}

void DlgConfigureRA::OnDelPolValue(wxCommandEvent& event)
{
	long SelectedItem;
	size_t index;

	SelectedItem = m_listPol->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;
	index = (size_t)m_listPol->GetItemData(SelectedItem);

	m_EntityConf.get_raConf().RA_CONF_PTR.get_policies().erase(m_EntityConf.get_raConf().RA_CONF_PTR.get_policies().begin() + index);
	LoadListPol();
}

void DlgConfigureRA::OnLdapImport(wxCommandEvent &event)
{
	bool value = ((wxCheckBox *)Frames->FindWindow(IDC_FROM_LDAP_PROFILE))->GetValue();

	((wxStaticText *)Frames->FindWindow(IDC_LBL_SERVER))->Enable(value);
	((wxStaticText *)Frames->FindWindow(IDC_LBL_PORT))->Enable(value);
	((wxStaticText *)Frames->FindWindow(IDC_LBL_USERNAME))->Enable(value);
	((wxStaticText *)Frames->FindWindow(IDC_LBL_PASSWORD))->Enable(value);
	((wxStaticText *)Frames->FindWindow(IDC_LBL_BASE))->Enable(value);
	((wxStaticText *)Frames->FindWindow(IDC_LBL_ATTR_NAME))->Enable(value);
	((wxStaticText *)Frames->FindWindow(IDC_LBL_FILTERS))->Enable(value);

	((wxTextCtrl *)Frames->FindWindow(IDC_SERVER))->Enable(value);
	((wxTextCtrl *)Frames->FindWindow(IDC_PORT))->Enable(value);
	((wxTextCtrl *)Frames->FindWindow(IDC_USERNAME))->Enable(value);
	((wxTextCtrl *)Frames->FindWindow(IDC_PASSWORD))->Enable(value);
	((wxTextCtrl *)Frames->FindWindow(IDC_BASE))->Enable(value);
	((wxTextCtrl *)Frames->FindWindow(IDC_ATTR_NAME))->Enable(value);
	((wxTextCtrl *)Frames->FindWindow(IDC_FILTERS))->Enable(value);
	((wxCheckBox *)Frames->FindWindow(IDC_UTF8))->Enable(value);

	if(!((wxComboBox *)Frames->FindWindow(IDC_GROUPS))->GetCount())
	{
		((wxCheckBox *)Frames->FindWindow(IDC_LDAP_AUTO_SYNCH))->Enable(FALSE);
	}
	else
	{
		((wxCheckBox *)Frames->FindWindow(IDC_LDAP_AUTO_SYNCH))->Enable(value);
	}

	OnLdapAutoSynch(event);

	if(!value)
	{
		((wxStaticText *)Frames->FindWindow(IDC_LBL_GROUP))->Enable(FALSE);
		((wxComboBox *)Frames->FindWindow(IDC_GROUPS))->Enable(FALSE);
	}
}

void DlgConfigureRA::OnLdapAutoSynch(wxCommandEvent &event)
{
	bool value = ((wxCheckBox *)Frames->FindWindow(IDC_LDAP_AUTO_SYNCH))->GetValue();

	((wxStaticText *)Frames->FindWindow(IDC_LBL_GROUP))->Enable(value);
	((wxComboBox *)Frames->FindWindow(IDC_GROUPS))->Enable(value);
}
