/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

#ifndef _WIN32
# define __USE_LARGEFILE64      1
#endif

#include "FileLog.h"
#include <CriticalSection.h>

LOG_LEVEL debuglevel=LOG_LEVEL_NONE;
FILE * fd = NULL;
CriticalSection fdAccess;

#ifdef _WIN32
	#define LOG_SEP "\r\n"
#else
	#define LOG_SEP "\n"
#endif
#define DELIM_PATT "%s"LOG_SEP

LOG_LEVEL GetDebugLevel()
{
	return debuglevel;
}

bool InitFileLog(const char * File, LOG_LEVEL level)
{
	fd = fopen(File, "ab");
	if(!fd)
	{
		return false;
	}

	debuglevel = level;
	return true;
}

void CleanFileLog()
{
	if(fd)
		fclose(fd);
}

void LogInsertDelimiter(const char * Delimiter)
{
	if(!fd)
		return;

	fdAccess.EnterCS();
		fprintf(fd, DELIM_PATT, Delimiter);
		fflush(fd);
	fdAccess.LeaveCS();
}

void LogInFile(const char * prog, const char * pattern, ...)
{
	va_list marker;
	time_t timet;
	struct tm * tmt;
	char * strtime;

	if(!fd)
		return;

	time(&timet);
	tmt = localtime(&timet);
	strtime = asctime(tmt);
	if(!strtime) return;
	strtime[strlen(strtime)-1] = 0;

	va_start( marker, pattern );
		fdAccess.EnterCS();
			fprintf(fd, "##### {%s} > %s# ", prog, strtime);
			vfprintf(fd, pattern, marker);
			fprintf(fd, LOG_SEP);
			fflush(fd);
		fdAccess.LeaveCS();
	va_end( marker );
}

void NewpkiDebug(LOG_LEVEL level, const char * prog, const char * pattern, ...)
{
	va_list marker;
	time_t timet;
	struct tm * tmt;
	char * strtime;

	if(debuglevel == LOG_LEVEL_NONE || debuglevel < level || !fd)
	{
		return;
	}

	time(&timet);
	tmt = localtime(&timet);
	strtime = asctime(tmt);
	if(!strtime) return;
	strtime[strlen(strtime)-1] = 0;


	va_start( marker, pattern );
		fdAccess.EnterCS();
			fprintf(fd, "##### Debug(%d) {%s} > %s# ", level, prog, strtime);
			vfprintf(fd, pattern, marker);
			fprintf(fd, LOG_SEP);
			fflush(fd);
		fdAccess.LeaveCS();
	va_end( marker );
}

