/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/

// PKI_PLUG_PUB.h: interface for AC plug
//
//////////////////////////////////////////////////////////////////////

#ifndef PKI_PLUG_PUB_H
#define PKI_PLUG_PUB_H

#include <HashTable/HashTable_String.h>
#include <PKI_CERT.h>
#include <PKI_P7B.h>
#include <PKI_CRL.h>
#include <mString.h>

/*!
  This structure lists the callback functions
  returned by a Publication plugin.
*/
typedef struct st_PKI_PLUG_PUB
{
	int (*InitLib)(const HashTable_String & Options);	//!< Function is called to initialize the plugin
	int (*ClearLib)(const HashTable_String & Options);	//!< Function is called to cleanup the plugin
	int (*OnNewCertificate)(const HashTable_String & Options, const PKI_CERT & Certificate, const PKI_P7B & P7B, const mString & RDN); //!< Function is called when a new certificate has been generated
	int (*OnNewRevocation)(const HashTable_String & Options, const PKI_CERT & Certificate, const mString & RDN); //!< Function is called when a certificate has been revoked
	int (*OnNewCrl)(const HashTable_String & Options, const PKI_CRL & Crl);  //!< Function is called when a new CRL has been generated
	const char * (*GetLibLastError)(); //!< Function is called to return the last error
}PKI_PLUG_PUB;

typedef PKI_PLUG_PUB * (*GET_FUNCTIONS)();	 //!< Function is called to get the list of functions

#endif
