/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


#ifndef UNIX_WINDOWS_H
#define UNIX_WINDOWS_H
	#ifdef _WIN32
		#include <windows.h>
		#define socklen_t int
		#define GetLastSocketError() WSAGetLastError()
	#else
		#include <unistd.h>
		#include <netinet/in.h>
		#include <sys/types.h>
		#include <sys/socket.h>
		#include <arpa/inet.h>
		#include <netdb.h>
		#include <errno.h>

		#ifndef closesocket
			#define closesocket close
		#endif

		#define SOCKET int
		#define INVALID_SOCKET  (SOCKET)(~0)
		#define SOCKET_ERROR            (-1)
		#define GetLastSocketError() errno
	#endif

#endif //UNIX_WINDOWS_H

