/**** BSIM4.2.1, Released by Xuemei Xi 10/05/2001 ****/

/**********
 * Copyright 2001 Regents of the University of California. All rights reserved.
 * File: b4.c of BSIM4.2.1.
 * Author: 2000 Weidong Liu
 * Authors: Xuemei Xi, Kanyu M. Cao, Hui Wan, Mansun Chan, Chenming Hu.
 * Project Director: Prof. Chenming Hu.
 *
 * Modified by Xuemei Xi, 10/05/2001.
 **********/

#include "ngspice.h"
#include <stdio.h>
#include "devdefs.h"
#include "bsim4def.h"
#include "suffix.h"

IFparm BSIM4pTable[] = { /* parameters */
IOP( "l",   BSIM4_L,      IF_REAL   , "Length"),
IOP( "w",   BSIM4_W,      IF_REAL   , "Width"),
IOP( "nf",  BSIM4_NF,     IF_REAL   , "Number of fingers"),
IOP( "min",  BSIM4_MIN,   IF_INTEGER , "Minimize either D or S"),
IOP( "ad",  BSIM4_AD,     IF_REAL   , "Drain area"),
IOP( "as",  BSIM4_AS,     IF_REAL   , "Source area"),
IOP( "pd",  BSIM4_PD,     IF_REAL   , "Drain perimeter"),
IOP( "ps",  BSIM4_PS,     IF_REAL   , "Source perimeter"),
IOP( "nrd", BSIM4_NRD,    IF_REAL   , "Number of squares in drain"),
IOP( "nrs", BSIM4_NRS,    IF_REAL   , "Number of squares in source"),
IOP( "off", BSIM4_OFF,    IF_FLAG   , "Device is initially off"),
IOP( "rbdb", BSIM4_RBDB,  IF_REAL   , "Body resistance"),
IOP( "rbsb", BSIM4_RBSB,  IF_REAL   , "Body resistance"),
IOP( "rbpb", BSIM4_RBPB,  IF_REAL   , "Body resistance"),
IOP( "rbps", BSIM4_RBPS,  IF_REAL   , "Body resistance"),
IOP( "rbpd", BSIM4_RBPD,  IF_REAL   , "Body resistance"),

IOP( "trnqsmod", BSIM4_TRNQSMOD, IF_INTEGER, "Transient NQS model selector"),
IOP( "acnqsmod", BSIM4_ACNQSMOD, IF_INTEGER, "AC NQS model selector"),
IOP( "rbodymod", BSIM4_RBODYMOD, IF_INTEGER, "Distributed body R model selector"),
IOP( "rgatemod", BSIM4_RGATEMOD, IF_INTEGER, "Gate resistance model selector"),
IOP( "geomod", BSIM4_GEOMOD, IF_INTEGER, "Geometry dependent parasitics model selector"),
IOP( "rgeomod", BSIM4_RGEOMOD, IF_INTEGER, "S/D resistance and contact model selector"),
IP( "ic",  BSIM4_IC,     IF_REALVEC , "Vector of DS,GS,BS initial voltages"),
OP( "gmbs",         BSIM4_GMBS,       IF_REAL,    "Gmb"),
OP( "gm",           BSIM4_GM,         IF_REAL,    "Gm"),
OP( "gds",          BSIM4_GDS,        IF_REAL,    "Gds"),
OP( "vdsat",        BSIM4_VDSAT,      IF_REAL,    "Vdsat"),
OP( "vth",          BSIM4_VON,        IF_REAL,    "Vth"),
OP( "id",           BSIM4_CD,         IF_REAL,    "Ids"),
OP( "ibd",          BSIM4_CBD,        IF_REAL,    "Ibd"),
OP( "ibs",          BSIM4_CBS,        IF_REAL,    "Ibs"),
OP( "isub",         BSIM4_CSUB,       IF_REAL,    "Isub"),
OP( "igidl",        BSIM4_IGIDL,      IF_REAL,    "Igidl"),
OP( "igisl",        BSIM4_IGISL,      IF_REAL,    "Igisl"),
OP( "igs",          BSIM4_IGS,        IF_REAL,    "Igs"),
OP( "igd",          BSIM4_IGD,        IF_REAL,    "Igd"),
OP( "igb",          BSIM4_IGB,        IF_REAL,    "Igb"),
OP( "igcs",         BSIM4_IGCS,       IF_REAL,    "Igcs"),
OP( "igcd",         BSIM4_IGCD,       IF_REAL,    "Igcd"),
OP( "vbs",          BSIM4_VBS,        IF_REAL,    "Vbs"),
OP( "vgs",          BSIM4_VGS,        IF_REAL,    "Vgs"),
OP( "vds",          BSIM4_VDS,        IF_REAL,    "Vds"),
OP( "cgg",         BSIM4_CGGB,       IF_REAL,    "Cggb"),
OP( "cgs",         BSIM4_CGSB,       IF_REAL,    "Cgsb"),
OP( "cgd",         BSIM4_CGDB,       IF_REAL,    "Cgdb"),
OP( "cbg",         BSIM4_CBGB,       IF_REAL,    "Cbgb"),
OP( "cbd",         BSIM4_CBDB,       IF_REAL,    "Cbdb"),
OP( "cbs",         BSIM4_CBSB,       IF_REAL,    "Cbsb"),
OP( "cdg",         BSIM4_CDGB,       IF_REAL,    "Cdgb"),
OP( "cdd",         BSIM4_CDDB,       IF_REAL,    "Cddb"),
OP( "cds",         BSIM4_CDSB,       IF_REAL,    "Cdsb"),
OP( "csg",         BSIM4_CSGB,       IF_REAL,    "Csgb"),
OP( "csd",         BSIM4_CSDB,       IF_REAL,    "Csdb"),
OP( "css",         BSIM4_CSSB,       IF_REAL,    "Cssb"),
OP( "cgb",         BSIM4_CGBB,       IF_REAL,    "Cgbb"),
OP( "cdb",         BSIM4_CDBB,       IF_REAL,    "Cdbb"),
OP( "csb",         BSIM4_CSBB,       IF_REAL,    "Csbb"),
OP( "cbb",         BSIM4_CBBB,       IF_REAL,    "Cbbb"),
OP( "capbd",       BSIM4_CAPBD,      IF_REAL,    "Capbd"),
OP( "capbs",       BSIM4_CAPBS,      IF_REAL,    "Capbs"),
OP( "qg",          BSIM4_QG,         IF_REAL,    "Qgate"),
OP( "qb",          BSIM4_QB,         IF_REAL,    "Qbulk"),
OP( "qd",          BSIM4_QD,         IF_REAL,    "Qdrain"),
OP( "qs",          BSIM4_QS,         IF_REAL,    "Qsource"),
OP( "qinv",        BSIM4_QINV,       IF_REAL,    "Qinversion"),
};

IFparm BSIM4mPTable[] = { /* model parameters */
IOP( "capmod", BSIM4_MOD_CAPMOD, IF_INTEGER, "Capacitance model selector"),
IOP( "diomod", BSIM4_MOD_DIOMOD, IF_INTEGER, "Diode IV model selector"),
IOP( "rdsmod", BSIM4_MOD_RDSMOD, IF_INTEGER, "Bias-dependent S/D resistance model selector"),
IOP( "trnqsmod", BSIM4_MOD_TRNQSMOD, IF_INTEGER, "Transient NQS model selector"),
IOP( "acnqsmod", BSIM4_MOD_ACNQSMOD, IF_INTEGER, "AC NQS model selector"),
IOP( "mobmod", BSIM4_MOD_MOBMOD, IF_INTEGER, "Mobility model selector"),
IOP( "rbodymod", BSIM4_MOD_RBODYMOD, IF_INTEGER, "Distributed body R model selector"),
IOP( "rgatemod", BSIM4_MOD_RGATEMOD, IF_INTEGER, "Gate R model selector"),
IOP( "permod", BSIM4_MOD_PERMOD, IF_INTEGER, "Pd and Ps model selector"),
IOP( "geomod", BSIM4_MOD_GEOMOD, IF_INTEGER, "Geometry dependent parasitics model selector"),
IOP( "fnoimod", BSIM4_MOD_FNOIMOD, IF_INTEGER, "Flicker noise model selector"),
IOP( "tnoimod", BSIM4_MOD_TNOIMOD, IF_INTEGER, "Thermal noise model selector"),
IOP( "igcmod", BSIM4_MOD_IGCMOD, IF_INTEGER, "Gate-to-channel Ig model selector"),
IOP( "igbmod", BSIM4_MOD_IGBMOD, IF_INTEGER, "Gate-to-body Ig model selector"),
IOP( "paramchk", BSIM4_MOD_PARAMCHK, IF_INTEGER, "Model parameter checking selector"),
IOP( "binunit", BSIM4_MOD_BINUNIT, IF_INTEGER, "Bin  unit  selector"),
IOP( "version", BSIM4_MOD_VERSION, IF_STRING, "parameter for model version"),
IOP( "toxe", BSIM4_MOD_TOXE, IF_REAL, "Electrical gate oxide thickness in meters"),
IOP( "toxp", BSIM4_MOD_TOXP, IF_REAL, "Physical gate oxide thickness in meters"),
IOP( "toxm", BSIM4_MOD_TOXM, IF_REAL, "Gate oxide thickness at which parameters are extracted"),
IOP( "toxref", BSIM4_MOD_TOXREF, IF_REAL, "Target tox value"),
IOP( "dtox", BSIM4_MOD_DTOX, IF_REAL, "Defined as (toxe - toxp) "),
IOP( "epsrox", BSIM4_MOD_EPSROX, IF_REAL, "Dielectric constant of the gate oxide relative to vacuum"),
IOP( "cdsc", BSIM4_MOD_CDSC, IF_REAL, "Drain/Source and channel coupling capacitance"),
IOP( "cdscb", BSIM4_MOD_CDSCB, IF_REAL, "Body-bias dependence of cdsc"), 
IOP( "cdscd", BSIM4_MOD_CDSCD, IF_REAL, "Drain-bias dependence of cdsc"), 
IOP( "cit", BSIM4_MOD_CIT, IF_REAL, "Interface state capacitance"),
IOP( "nfactor", BSIM4_MOD_NFACTOR, IF_REAL, "Subthreshold swing Coefficient"),
IOP( "xj", BSIM4_MOD_XJ, IF_REAL, "Junction depth in meters"),
IOP( "vsat", BSIM4_MOD_VSAT, IF_REAL, "Saturation velocity at tnom"),
IOP( "at", BSIM4_MOD_AT, IF_REAL, "Temperature coefficient of vsat"),
IOP( "a0", BSIM4_MOD_A0, IF_REAL, "Non-uniform depletion width effect coefficient."), 
IOP( "ags", BSIM4_MOD_AGS, IF_REAL, "Gate bias  coefficient of Abulk."), 
IOP( "a1", BSIM4_MOD_A1, IF_REAL, "Non-saturation effect coefficient"),
IOP( "a2", BSIM4_MOD_A2, IF_REAL, "Non-saturation effect coefficient"),
IOP( "keta", BSIM4_MOD_KETA, IF_REAL, "Body-bias coefficient of non-uniform depletion width effect."),
IOP( "nsub", BSIM4_MOD_NSUB, IF_REAL, "Substrate doping concentration"),
IOP( "ndep", BSIM4_MOD_NDEP, IF_REAL, "Channel doping concentration at the depletion edge"),
IOP( "nsd", BSIM4_MOD_NSD, IF_REAL, "S/D doping concentration"),
IOP( "phin", BSIM4_MOD_PHIN, IF_REAL, "Adjusting parameter for surface potential due to non-uniform vertical doping"),
IOP( "ngate", BSIM4_MOD_NGATE, IF_REAL, "Poly-gate doping concentration"),
IOP( "gamma1", BSIM4_MOD_GAMMA1, IF_REAL, "Vth body coefficient"),
IOP( "gamma2", BSIM4_MOD_GAMMA2, IF_REAL, "Vth body coefficient"),
IOP( "vbx", BSIM4_MOD_VBX, IF_REAL, "Vth transition body Voltage"),
IOP( "vbm", BSIM4_MOD_VBM, IF_REAL, "Maximum body voltage"),

IOP( "xt", BSIM4_MOD_XT, IF_REAL, "Doping depth"),
IOP( "k1", BSIM4_MOD_K1, IF_REAL, "Bulk effect coefficient 1"),
IOP( "kt1", BSIM4_MOD_KT1, IF_REAL, "Temperature coefficient of Vth"),
IOP( "kt1l", BSIM4_MOD_KT1L, IF_REAL, "Temperature coefficient of Vth"),
IOP( "kt2",  BSIM4_MOD_KT2, IF_REAL, "Body-coefficient of kt1"),
IOP( "k2",   BSIM4_MOD_K2,  IF_REAL, "Bulk effect coefficient 2"),
IOP( "k3",   BSIM4_MOD_K3,  IF_REAL, "Narrow width effect coefficient"),
IOP( "k3b",  BSIM4_MOD_K3B, IF_REAL, "Body effect coefficient of k3"),
IOP( "w0",   BSIM4_MOD_W0,  IF_REAL, "Narrow width effect parameter"),
IOP( "dvtp0",  BSIM4_MOD_DVTP0, IF_REAL, "First parameter for Vth shift due to pocket"),
IOP( "dvtp1",  BSIM4_MOD_DVTP1, IF_REAL, "Second parameter for Vth shift due to pocket"),
IOP( "lpe0",  BSIM4_MOD_LPE0, IF_REAL, "Equivalent length of pocket region at zero bias"),
IOP( "lpeb",  BSIM4_MOD_LPEB, IF_REAL, "Equivalent length of pocket region accounting for body bias"),
IOP( "dvt0", BSIM4_MOD_DVT0, IF_REAL, "Short channel effect coeff. 0"),
IOP( "dvt1", BSIM4_MOD_DVT1, IF_REAL, "Short channel effect coeff. 1"),
IOP( "dvt2", BSIM4_MOD_DVT2, IF_REAL, "Short channel effect coeff. 2"),
IOP( "dvt0w", BSIM4_MOD_DVT0W, IF_REAL, "Narrow Width coeff. 0"),
IOP( "dvt1w", BSIM4_MOD_DVT1W, IF_REAL, "Narrow Width effect coeff. 1"),
IOP( "dvt2w", BSIM4_MOD_DVT2W, IF_REAL, "Narrow Width effect coeff. 2"),
IOP( "drout", BSIM4_MOD_DROUT, IF_REAL, "DIBL coefficient of output resistance"),
IOP( "dsub", BSIM4_MOD_DSUB, IF_REAL, "DIBL coefficient in the subthreshold region"),
IOP( "vth0", BSIM4_MOD_VTH0, IF_REAL,"Threshold voltage"),
IOP( "vtho", BSIM4_MOD_VTH0, IF_REAL,"Threshold voltage"),
IOP( "ua", BSIM4_MOD_UA, IF_REAL, "Linear gate dependence of mobility"),
IOP( "ua1", BSIM4_MOD_UA1, IF_REAL, "Temperature coefficient of ua"),
IOP( "ub", BSIM4_MOD_UB, IF_REAL, "Quadratic gate dependence of mobility"),
IOP( "ub1", BSIM4_MOD_UB1, IF_REAL, "Temperature coefficient of ub"),
IOP( "uc", BSIM4_MOD_UC, IF_REAL, "Body-bias dependence of mobility"),
IOP( "uc1", BSIM4_MOD_UC1, IF_REAL, "Temperature coefficient of uc"),
IOP( "u0", BSIM4_MOD_U0, IF_REAL, "Low-field mobility at Tnom"),
IOP( "eu", BSIM4_MOD_EU, IF_REAL, "Mobility exponent"),
IOP( "ute", BSIM4_MOD_UTE, IF_REAL, "Temperature coefficient of mobility"),
IOP( "voff", BSIM4_MOD_VOFF, IF_REAL, "Threshold voltage offset"),
IOP( "minv", BSIM4_MOD_MINV, IF_REAL, "Fitting parameter for moderate invversion in Vgsteff"),
IOP( "voffl", BSIM4_MOD_VOFFL, IF_REAL, "Length dependence parameter for Vth offset"),
IOP( "tnom", BSIM4_MOD_TNOM, IF_REAL, "Parameter measurement temperature"),
IOP( "cgso", BSIM4_MOD_CGSO, IF_REAL, "Gate-source overlap capacitance per width"),
IOP( "cgdo", BSIM4_MOD_CGDO, IF_REAL, "Gate-drain overlap capacitance per width"),
IOP( "cgbo", BSIM4_MOD_CGBO, IF_REAL, "Gate-bulk overlap capacitance per length"),
IOP( "xpart", BSIM4_MOD_XPART, IF_REAL, "Channel charge partitioning"),
IOP( "delta", BSIM4_MOD_DELTA, IF_REAL, "Effective Vds parameter"),
IOP( "rsh", BSIM4_MOD_RSH, IF_REAL, "Source-drain sheet resistance"),
IOP( "rdsw", BSIM4_MOD_RDSW, IF_REAL, "Source-drain resistance per width"),    
IOP( "rdswmin", BSIM4_MOD_RDSWMIN, IF_REAL, "Source-drain resistance per width at high Vg"),
IOP( "rsw", BSIM4_MOD_RSW, IF_REAL, "Source resistance per width"),
IOP( "rdw", BSIM4_MOD_RDW, IF_REAL, "Drain resistance per width"),
IOP( "rdwmin", BSIM4_MOD_RDWMIN, IF_REAL, "Drain resistance per width at high Vg"),
IOP( "rswmin", BSIM4_MOD_RSWMIN, IF_REAL, "Source resistance per width at high Vg"),

IOP( "prwg", BSIM4_MOD_PRWG, IF_REAL, "Gate-bias effect on parasitic resistance "),    
IOP( "prwb", BSIM4_MOD_PRWB, IF_REAL, "Body-effect on parasitic resistance "),    

IOP( "prt", BSIM4_MOD_PRT, IF_REAL, "Temperature coefficient of parasitic resistance "),    
IOP( "eta0", BSIM4_MOD_ETA0, IF_REAL, "Subthreshold region DIBL coefficient"),
IOP( "etab", BSIM4_MOD_ETAB, IF_REAL, "Subthreshold region DIBL coefficient"),
IOP( "pclm", BSIM4_MOD_PCLM, IF_REAL, "Channel length modulation Coefficient"),
IOP( "pdiblc1", BSIM4_MOD_PDIBL1, IF_REAL, "Drain-induced barrier lowering coefficient"),   
IOP( "pdiblc2", BSIM4_MOD_PDIBL2, IF_REAL, "Drain-induced barrier lowering coefficient"),   
IOP( "pdiblcb", BSIM4_MOD_PDIBLB, IF_REAL, "Body-effect on drain-induced barrier lowering"),   
IOP( "fprout", BSIM4_MOD_FPROUT, IF_REAL, "Rout degradation coefficient for pocket devices"),
IOP( "pdits", BSIM4_MOD_PDITS, IF_REAL, "Coefficient for drain-induced Vth shifts"),
IOP( "pditsl", BSIM4_MOD_PDITSL, IF_REAL, "Length dependence of drain-induced Vth shifts"),
IOP( "pditsd", BSIM4_MOD_PDITSD, IF_REAL, "Vds dependence of drain-induced Vth shifts"),
IOP( "pscbe1", BSIM4_MOD_PSCBE1, IF_REAL, "Substrate current body-effect coefficient"),   
IOP( "pscbe2", BSIM4_MOD_PSCBE2, IF_REAL, "Substrate current body-effect coefficient"),   
IOP( "pvag", BSIM4_MOD_PVAG, IF_REAL, "Gate dependence of output resistance parameter"),   

IOP( "jss", BSIM4_MOD_JSS, IF_REAL, "Bottom source junction reverse saturation current density"),
IOP( "jsws", BSIM4_MOD_JSWS, IF_REAL, "Isolation edge sidewall source junction reverse saturation current density"),
IOP( "jswgs", BSIM4_MOD_JSWGS, IF_REAL, "Gate edge source junction reverse saturation current density"),
IOP( "pbs", BSIM4_MOD_PBS, IF_REAL, "Source junction built-in potential"),
IOP( "njs", BSIM4_MOD_NJS, IF_REAL, "Source junction emission coefficient"),
IOP( "xtis", BSIM4_MOD_XTIS, IF_REAL, "Source junction current temperature exponent"),
IOP( "mjs", BSIM4_MOD_MJS, IF_REAL, "Source bottom junction capacitance grading coefficient"),
IOP( "pbsws", BSIM4_MOD_PBSWS, IF_REAL, "Source sidewall junction capacitance built in potential"),
IOP( "mjsws", BSIM4_MOD_MJSWS, IF_REAL, "Source sidewall junction capacitance grading coefficient"),
IOP( "pbswgs", BSIM4_MOD_PBSWGS, IF_REAL, "Source (gate side) sidewall junction capacitance built in potential"),
IOP( "mjswgs", BSIM4_MOD_MJSWGS, IF_REAL, "Source (gate side) sidewall junction capacitance grading coefficient"),
IOP( "cjs", BSIM4_MOD_CJS, IF_REAL, "Source bottom junction capacitance per unit area"),
IOP( "cjsws", BSIM4_MOD_CJSWS, IF_REAL, "Source sidewall junction capacitance per unit periphery"),
IOP( "cjswgs", BSIM4_MOD_CJSWGS, IF_REAL, "Source (gate side) sidewall junction capacitance per unit width"),

IOP( "jsd", BSIM4_MOD_JSD, IF_REAL, "Bottom drain junction reverse saturation current density"),
IOP( "jswd", BSIM4_MOD_JSWD, IF_REAL, "Isolation edge sidewall drain junction reverse saturation current density"),
IOP( "jswgd", BSIM4_MOD_JSWGD, IF_REAL, "Gate edge drain junction reverse saturation current density"),
IOP( "pbd", BSIM4_MOD_PBD, IF_REAL, "Drain junction built-in potential"),
IOP( "njd", BSIM4_MOD_NJD, IF_REAL, "Drain junction emission coefficient"),
IOP( "xtid", BSIM4_MOD_XTID, IF_REAL, "Drainjunction current temperature exponent"),
IOP( "mjd", BSIM4_MOD_MJD, IF_REAL, "Drain bottom junction capacitance grading coefficient"),
IOP( "pbswd", BSIM4_MOD_PBSWD, IF_REAL, "Drain sidewall junction capacitance built in potential"),
IOP( "mjswd", BSIM4_MOD_MJSWD, IF_REAL, "Drain sidewall junction capacitance grading coefficient"),
IOP( "pbswgd", BSIM4_MOD_PBSWGD, IF_REAL, "Drain (gate side) sidewall junction capacitance built in potential"),
IOP( "mjswgd", BSIM4_MOD_MJSWGD, IF_REAL, "Drain (gate side) sidewall junction capacitance grading coefficient"),
IOP( "cjd", BSIM4_MOD_CJD, IF_REAL, "Drain bottom junction capacitance per unit area"),
IOP( "cjswd", BSIM4_MOD_CJSWD, IF_REAL, "Drain sidewall junction capacitance per unit periphery"),
IOP( "cjswgd", BSIM4_MOD_CJSWGD, IF_REAL, "Drain (gate side) sidewall junction capacitance per unit width"),

IOP( "vfbcv", BSIM4_MOD_VFBCV, IF_REAL, "Flat Band Voltage parameter for capmod=0 only"),
IOP( "vfb", BSIM4_MOD_VFB, IF_REAL, "Flat Band Voltage"),
IOP( "tpb", BSIM4_MOD_TPB, IF_REAL, "Temperature coefficient of pb"),
IOP( "tcj", BSIM4_MOD_TCJ, IF_REAL, "Temperature coefficient of cj"),
IOP( "tpbsw", BSIM4_MOD_TPBSW, IF_REAL, "Temperature coefficient of pbsw"),
IOP( "tcjsw", BSIM4_MOD_TCJSW, IF_REAL, "Temperature coefficient of cjsw"),
IOP( "tpbswg", BSIM4_MOD_TPBSWG, IF_REAL, "Temperature coefficient of pbswg"),
IOP( "tcjswg", BSIM4_MOD_TCJSWG, IF_REAL, "Temperature coefficient of cjswg"),
IOP( "acde", BSIM4_MOD_ACDE, IF_REAL, "Exponential coefficient for finite charge thickness"),
IOP( "moin", BSIM4_MOD_MOIN, IF_REAL, "Coefficient for gate-bias dependent surface potential"),
IOP( "noff", BSIM4_MOD_NOFF, IF_REAL, "C-V turn-on/off parameter"),
IOP( "voffcv", BSIM4_MOD_VOFFCV, IF_REAL, "C-V lateral-shift parameter"),
IOP( "dmcg", BSIM4_MOD_DMCG, IF_REAL, "Distance of Mid-Contact to Gate edge"),
IOP( "dmci", BSIM4_MOD_DMCI, IF_REAL, "Distance of Mid-Contact to Isolation"),
IOP( "dmdg", BSIM4_MOD_DMDG, IF_REAL, "Distance of Mid-Diffusion to Gate edge"),
IOP( "dmcgt", BSIM4_MOD_DMCGT, IF_REAL, "Distance of Mid-Contact to Gate edge in Test structures"),
IOP( "xgw",  BSIM4_MOD_XGW, IF_REAL, "Distance from gate contact center to device edge"),
IOP( "xgl",  BSIM4_MOD_XGL, IF_REAL, "Variation in Ldrawn"),
IOP( "rshg", BSIM4_MOD_RSHG, IF_REAL, "Gate sheet resistance"),
IOP( "ngcon", BSIM4_MOD_NGCON, IF_REAL, "Number of gate contacts"),
IOP( "xrcrg1",  BSIM4_MOD_XRCRG1, IF_REAL, "First fitting parameter the bias-dependent Rg"),
IOP( "xrcrg2",  BSIM4_MOD_XRCRG2, IF_REAL, "Second fitting parameter the bias-dependent Rg"),
IOP( "lint", BSIM4_MOD_LINT, IF_REAL, "Length reduction parameter"),
IOP( "ll",   BSIM4_MOD_LL, IF_REAL, "Length reduction parameter"),
IOP( "llc",  BSIM4_MOD_LLC, IF_REAL, "Length reduction parameter for CV"),
IOP( "lln",  BSIM4_MOD_LLN, IF_REAL, "Length reduction parameter"),
IOP( "lw",   BSIM4_MOD_LW,  IF_REAL, "Length reduction parameter"),
IOP( "lwc",  BSIM4_MOD_LWC, IF_REAL, "Length reduction parameter for CV"),
IOP( "lwn",  BSIM4_MOD_LWN, IF_REAL, "Length reduction parameter"),
IOP( "lwl",  BSIM4_MOD_LWL, IF_REAL, "Length reduction parameter"),
IOP( "lwlc", BSIM4_MOD_LWLC, IF_REAL, "Length reduction parameter for CV"),
IOP( "lmin", BSIM4_MOD_LMIN, IF_REAL, "Minimum length for the model"),
IOP( "lmax", BSIM4_MOD_LMAX, IF_REAL, "Maximum length for the model"),

IOP( "wr",   BSIM4_MOD_WR, IF_REAL, "Width dependence of rds"),
IOP( "wint", BSIM4_MOD_WINT, IF_REAL, "Width reduction parameter"),
IOP( "dwg",  BSIM4_MOD_DWG, IF_REAL, "Width reduction parameter"),
IOP( "dwb",  BSIM4_MOD_DWB, IF_REAL, "Width reduction parameter"),

IOP( "wl",   BSIM4_MOD_WL, IF_REAL, "Width reduction parameter"),
IOP( "wlc",  BSIM4_MOD_WLC, IF_REAL, "Width reduction parameter for CV"),
IOP( "wln",  BSIM4_MOD_WLN, IF_REAL, "Width reduction parameter"),
IOP( "ww",   BSIM4_MOD_WW, IF_REAL, "Width reduction parameter"),
IOP( "wwc",  BSIM4_MOD_WWC, IF_REAL, "Width reduction parameter for CV"),
IOP( "wwn",  BSIM4_MOD_WWN, IF_REAL, "Width reduction parameter"),
IOP( "wwl",  BSIM4_MOD_WWL, IF_REAL, "Width reduction parameter"),
IOP( "wwlc", BSIM4_MOD_WWLC, IF_REAL, "Width reduction parameter for CV"),
IOP( "wmin", BSIM4_MOD_WMIN, IF_REAL, "Minimum width for the model"),
IOP( "wmax", BSIM4_MOD_WMAX, IF_REAL, "Maximum width for the model"),

IOP( "b0",  BSIM4_MOD_B0, IF_REAL, "Abulk narrow width parameter"),
IOP( "b1",  BSIM4_MOD_B1, IF_REAL, "Abulk narrow width parameter"),

IOP( "cgsl", BSIM4_MOD_CGSL, IF_REAL, "New C-V model parameter"),
IOP( "cgdl", BSIM4_MOD_CGDL, IF_REAL, "New C-V model parameter"),
IOP( "ckappas", BSIM4_MOD_CKAPPAS, IF_REAL, "S/G overlap C-V parameter "),
IOP( "ckappad", BSIM4_MOD_CKAPPAD, IF_REAL, "D/G overlap C-V parameter"),
IOP( "cf",  BSIM4_MOD_CF, IF_REAL, "Fringe capacitance parameter"),
IOP( "clc", BSIM4_MOD_CLC, IF_REAL, "Vdsat parameter for C-V model"),
IOP( "cle", BSIM4_MOD_CLE, IF_REAL, "Vdsat parameter for C-V model"),
IOP( "dwc", BSIM4_MOD_DWC, IF_REAL, "Delta W for C-V model"),
IOP( "dlc", BSIM4_MOD_DLC, IF_REAL, "Delta L for C-V model"),
IOP( "xw", BSIM4_MOD_XW, IF_REAL, "W offset for channel width due to mask/etch effect"),
IOP( "xl", BSIM4_MOD_XL, IF_REAL, "L offset for channel length due to mask/etch effect"),
IOP( "dlcig", BSIM4_MOD_DLCIG, IF_REAL, "Delta L for Ig model"),
IOP( "dwj", BSIM4_MOD_DWJ, IF_REAL, "Delta W for S/D junctions"),

IOP( "alpha0", BSIM4_MOD_ALPHA0, IF_REAL, "substrate current model parameter"),
IOP( "alpha1", BSIM4_MOD_ALPHA1, IF_REAL, "substrate current model parameter"),
IOP( "beta0", BSIM4_MOD_BETA0, IF_REAL, "substrate current model parameter"),
IOP( "agidl", BSIM4_MOD_AGIDL, IF_REAL, "Pre-exponential constant for GIDL"),
IOP( "bgidl", BSIM4_MOD_BGIDL, IF_REAL, "Exponential constant for GIDL"),
IOP( "cgidl", BSIM4_MOD_CGIDL, IF_REAL, "Parameter for body-bias dependence of GIDL"),
IOP( "egidl", BSIM4_MOD_EGIDL, IF_REAL, "Fitting parameter for Bandbending"),
IOP( "aigc", BSIM4_MOD_AIGC, IF_REAL, "Parameter for Igc"),
IOP( "bigc", BSIM4_MOD_BIGC, IF_REAL, "Parameter for Igc"),
IOP( "cigc", BSIM4_MOD_CIGC, IF_REAL, "Parameter for Igc"),
IOP( "aigsd", BSIM4_MOD_AIGSD, IF_REAL, "Parameter for Igs,d"),
IOP( "bigsd", BSIM4_MOD_BIGSD, IF_REAL, "Parameter for Igs,d"),
IOP( "cigsd", BSIM4_MOD_CIGSD, IF_REAL, "Parameter for Igs,d"),
IOP( "aigbacc", BSIM4_MOD_AIGBACC, IF_REAL, "Parameter for Igb"),
IOP( "bigbacc", BSIM4_MOD_BIGBACC, IF_REAL, "Parameter for Igb"),
IOP( "cigbacc", BSIM4_MOD_CIGBACC, IF_REAL, "Parameter for Igb"),
IOP( "aigbinv", BSIM4_MOD_AIGBINV, IF_REAL, "Parameter for Igb"),
IOP( "bigbinv", BSIM4_MOD_BIGBINV, IF_REAL, "Parameter for Igb"),
IOP( "cigbinv", BSIM4_MOD_CIGBINV, IF_REAL, "Parameter for Igb"),
IOP( "nigc", BSIM4_MOD_NIGC, IF_REAL, "Parameter for Igc slope"),
IOP( "nigbinv", BSIM4_MOD_NIGBINV, IF_REAL, "Parameter for Igbinv slope"),
IOP( "nigbacc", BSIM4_MOD_NIGBACC, IF_REAL, "Parameter for Igbacc slope"),
IOP( "ntox", BSIM4_MOD_NTOX, IF_REAL, "Exponent for Tox ratio"),
IOP( "eigbinv", BSIM4_MOD_EIGBINV, IF_REAL, "Parameter for the Si bandgap for Igbinv"),
IOP( "pigcd", BSIM4_MOD_PIGCD, IF_REAL, "Parameter for Igc partition"),
IOP( "poxedge", BSIM4_MOD_POXEDGE, IF_REAL, "Factor for the gate edge Tox"),

IOP( "ijthdfwd", BSIM4_MOD_IJTHDFWD, IF_REAL, "Forward drain diode forward limiting current"),
IOP( "ijthsfwd", BSIM4_MOD_IJTHSFWD, IF_REAL, "Forward source diode forward limiting current"),
IOP( "ijthdrev", BSIM4_MOD_IJTHDREV, IF_REAL, "Reverse drain diode forward limiting current"),
IOP( "ijthsrev", BSIM4_MOD_IJTHSREV, IF_REAL, "Reverse source diode forward limiting current"),
IOP( "xjbvd", BSIM4_MOD_XJBVD, IF_REAL, "Fitting parameter for drain diode breakdown current"),
IOP( "xjbvs", BSIM4_MOD_XJBVS, IF_REAL, "Fitting parameter for source diode breakdown current"),
IOP( "bvd", BSIM4_MOD_BVD, IF_REAL, "Drain diode breakdown voltage"),
IOP( "bvs", BSIM4_MOD_BVS, IF_REAL, "Source diode breakdown voltage"),

IOP( "gbmin", BSIM4_MOD_GBMIN, IF_REAL, "Minimum body conductance"),
IOP( "rbdb", BSIM4_MOD_RBDB, IF_REAL, "Resistance between bNode and dbNode"),
IOP( "rbpb", BSIM4_MOD_RBPB, IF_REAL, "Resistance between bNodePrime and bNode"),
IOP( "rbsb", BSIM4_MOD_RBSB, IF_REAL, "Resistance between bNode and sbNode"),
IOP( "rbps", BSIM4_MOD_RBPS, IF_REAL, "Resistance between bNodePrime and sbNode"),
IOP( "rbpd", BSIM4_MOD_RBPD, IF_REAL, "Resistance between bNodePrime and bNode"),

IOP( "lcdsc",  BSIM4_MOD_LCDSC, IF_REAL, "Length dependence of cdsc"),
IOP( "lcdscb", BSIM4_MOD_LCDSCB, IF_REAL, "Length dependence of cdscb"),
IOP( "lcdscd", BSIM4_MOD_LCDSCD, IF_REAL, "Length dependence of cdscd"),
IOP( "lcit",   BSIM4_MOD_LCIT,  IF_REAL, "Length dependence of cit"),
IOP( "lnfactor", BSIM4_MOD_LNFACTOR, IF_REAL, "Length dependence of nfactor"),
IOP( "lxj", BSIM4_MOD_LXJ, IF_REAL, "Length dependence of xj"),
IOP( "lvsat", BSIM4_MOD_LVSAT, IF_REAL, "Length dependence of vsat"),
IOP( "lat", BSIM4_MOD_LAT, IF_REAL, "Length dependence of at"),
IOP( "la0", BSIM4_MOD_LA0, IF_REAL, "Length dependence of a0"), 
IOP( "lags", BSIM4_MOD_LAGS, IF_REAL, "Length dependence of ags"), 
IOP( "la1", BSIM4_MOD_LA1, IF_REAL, "Length dependence of a1"),
IOP( "la2", BSIM4_MOD_LA2, IF_REAL, "Length dependence of a2"),
IOP( "lketa", BSIM4_MOD_LKETA, IF_REAL, "Length dependence of keta"),
IOP( "lnsub", BSIM4_MOD_LNSUB, IF_REAL, "Length dependence of nsub"),
IOP( "lndep",  BSIM4_MOD_LNDEP, IF_REAL, "Length dependence of ndep"),
IOP( "lnsd",  BSIM4_MOD_LNSD, IF_REAL, "Length dependence of nsd"),
IOP( "lphin", BSIM4_MOD_LPHIN, IF_REAL, "Length dependence of phin"),
IOP( "lngate", BSIM4_MOD_LNGATE, IF_REAL, "Length dependence of ngate"),
IOP( "lgamma1", BSIM4_MOD_LGAMMA1, IF_REAL, "Length dependence of gamma1"),
IOP( "lgamma2", BSIM4_MOD_LGAMMA2, IF_REAL, "Length dependence of gamma2"),
IOP( "lvbx", BSIM4_MOD_LVBX, IF_REAL, "Length dependence of vbx"),
IOP( "lvbm", BSIM4_MOD_LVBM, IF_REAL, "Length dependence of vbm"),
IOP( "lxt",  BSIM4_MOD_LXT,  IF_REAL, "Length dependence of xt"),
IOP( "lk1",   BSIM4_MOD_LK1,  IF_REAL, "Length dependence of k1"),
IOP( "lkt1",  BSIM4_MOD_LKT1, IF_REAL, "Length dependence of kt1"),
IOP( "lkt1l", BSIM4_MOD_LKT1L, IF_REAL, "Length dependence of kt1l"),
IOP( "lkt2",  BSIM4_MOD_LKT2, IF_REAL, "Length dependence of kt2"),
IOP( "lk2",   BSIM4_MOD_LK2,  IF_REAL, "Length dependence of k2"),
IOP( "lk3",   BSIM4_MOD_LK3,  IF_REAL, "Length dependence of k3"),
IOP( "lk3b",  BSIM4_MOD_LK3B, IF_REAL, "Length dependence of k3b"),
IOP( "lw0",   BSIM4_MOD_LW0,  IF_REAL, "Length dependence of w0"),
IOP( "ldvtp0",  BSIM4_MOD_LDVTP0, IF_REAL, "Length dependence of dvtp0"),
IOP( "ldvtp1",  BSIM4_MOD_LDVTP1, IF_REAL, "Length dependence of dvtp1"),
IOP( "llpe0",  BSIM4_MOD_LLPE0, IF_REAL, "Length dependence of lpe0"),
IOP( "llpeb",  BSIM4_MOD_LLPEB, IF_REAL, "Length dependence of lpeb"),
IOP( "ldvt0", BSIM4_MOD_LDVT0, IF_REAL, "Length dependence of dvt0"),
IOP( "ldvt1", BSIM4_MOD_LDVT1, IF_REAL, "Length dependence of dvt1"),
IOP( "ldvt2", BSIM4_MOD_LDVT2, IF_REAL, "Length dependence of dvt2"),
IOP( "ldvt0w", BSIM4_MOD_LDVT0W, IF_REAL, "Length dependence of dvt0w"),
IOP( "ldvt1w", BSIM4_MOD_LDVT1W, IF_REAL, "Length dependence of dvt1w"),
IOP( "ldvt2w", BSIM4_MOD_LDVT2W, IF_REAL, "Length dependence of dvt2w"),
IOP( "ldrout", BSIM4_MOD_LDROUT, IF_REAL, "Length dependence of drout"),
IOP( "ldsub", BSIM4_MOD_LDSUB, IF_REAL, "Length dependence of dsub"),
IOP( "lvth0", BSIM4_MOD_LVTH0, IF_REAL,"Length dependence of vto"),
IOP( "lvtho", BSIM4_MOD_LVTH0, IF_REAL,"Length dependence of vto"),
IOP( "lua",  BSIM4_MOD_LUA, IF_REAL, "Length dependence of ua"),
IOP( "lua1", BSIM4_MOD_LUA1, IF_REAL, "Length dependence of ua1"),
IOP( "lub", BSIM4_MOD_LUB, IF_REAL, "Length dependence of ub"),
IOP( "lub1", BSIM4_MOD_LUB1, IF_REAL, "Length dependence of ub1"),
IOP( "luc",  BSIM4_MOD_LUC, IF_REAL, "Length dependence of uc"),
IOP( "luc1", BSIM4_MOD_LUC1, IF_REAL, "Length dependence of uc1"),
IOP( "lu0",  BSIM4_MOD_LU0, IF_REAL, "Length dependence of u0"),
IOP( "lute", BSIM4_MOD_LUTE, IF_REAL, "Length dependence of ute"),
IOP( "lvoff", BSIM4_MOD_LVOFF, IF_REAL, "Length dependence of voff"),
IOP( "lminv", BSIM4_MOD_LMINV, IF_REAL, "Length dependence of minv"),
IOP( "ldelta", BSIM4_MOD_LDELTA, IF_REAL, "Length dependence of delta"),
IOP( "lrdsw", BSIM4_MOD_LRDSW,  IF_REAL, "Length dependence of rdsw "),    
IOP( "lrsw", BSIM4_MOD_LRSW, IF_REAL, "Length dependence of rsw"),
IOP( "lrdw", BSIM4_MOD_LRDW, IF_REAL, "Length dependence of rdw"),

IOP( "lprwg", BSIM4_MOD_LPRWG,  IF_REAL, "Length dependence of prwg "),    
IOP( "lprwb", BSIM4_MOD_LPRWB,  IF_REAL, "Length dependence of prwb "),    

IOP( "lprt", BSIM4_MOD_LPRT, IF_REAL, "Length dependence of prt "),    
IOP( "leta0", BSIM4_MOD_LETA0, IF_REAL, "Length dependence of eta0"),   
IOP( "letab", BSIM4_MOD_LETAB, IF_REAL, "Length dependence of etab"),   
IOP( "lpclm", BSIM4_MOD_LPCLM, IF_REAL, "Length dependence of pclm"),   
IOP( "lpdiblc1", BSIM4_MOD_LPDIBL1, IF_REAL, "Length dependence of pdiblc1"),   
IOP( "lpdiblc2", BSIM4_MOD_LPDIBL2, IF_REAL, "Length dependence of pdiblc2"),   
IOP( "lpdiblcb", BSIM4_MOD_LPDIBLB, IF_REAL, "Length dependence of pdiblcb"),   
IOP( "lfprout", BSIM4_MOD_LFPROUT, IF_REAL, "Length dependence of pdiblcb"),
IOP( "lpdits", BSIM4_MOD_LPDITS, IF_REAL, "Length dependence of pdits"),
IOP( "lpditsd", BSIM4_MOD_LPDITSD, IF_REAL, "Length dependence of pditsd"),
IOP( "lpscbe1",  BSIM4_MOD_LPSCBE1, IF_REAL, "Length dependence of pscbe1"),   
IOP( "lpscbe2",  BSIM4_MOD_LPSCBE2, IF_REAL, "Length dependence of pscbe2"),   
IOP( "lpvag", BSIM4_MOD_LPVAG, IF_REAL, "Length dependence of pvag"),   
IOP( "lwr",  BSIM4_MOD_LWR, IF_REAL, "Length dependence of wr"),
IOP( "ldwg", BSIM4_MOD_LDWG, IF_REAL, "Length dependence of dwg"),
IOP( "ldwb", BSIM4_MOD_LDWB, IF_REAL, "Length dependence of dwb"),
IOP( "lb0",  BSIM4_MOD_LB0, IF_REAL, "Length dependence of b0"),
IOP( "lb1",  BSIM4_MOD_LB1, IF_REAL, "Length dependence of b1"),
IOP( "lcgsl", BSIM4_MOD_LCGSL, IF_REAL, "Length dependence of cgsl"),
IOP( "lcgdl", BSIM4_MOD_LCGDL, IF_REAL, "Length dependence of cgdl"),
IOP( "lckappas", BSIM4_MOD_LCKAPPAS, IF_REAL, "Length dependence of ckappas"),
IOP( "lckappad", BSIM4_MOD_LCKAPPAD, IF_REAL, "Length dependence of ckappad"),
IOP( "lcf",  BSIM4_MOD_LCF,  IF_REAL, "Length dependence of cf"),
IOP( "lclc", BSIM4_MOD_LCLC, IF_REAL, "Length dependence of clc"),
IOP( "lcle", BSIM4_MOD_LCLE, IF_REAL, "Length dependence of cle"),
IOP( "lalpha0", BSIM4_MOD_LALPHA0, IF_REAL, "Length dependence of alpha0"),
IOP( "lalpha1", BSIM4_MOD_LALPHA1, IF_REAL, "Length dependence of alpha1"),
IOP( "lbeta0", BSIM4_MOD_LBETA0, IF_REAL, "Length dependence of beta0"),
IOP( "lagidl", BSIM4_MOD_LAGIDL, IF_REAL, "Length dependence of agidl"),
IOP( "lbgidl", BSIM4_MOD_LBGIDL, IF_REAL, "Length dependence of bgidl"),
IOP( "lcgidl", BSIM4_MOD_LCGIDL, IF_REAL, "Length dependence of cgidl"),
IOP( "legidl", BSIM4_MOD_LEGIDL, IF_REAL, "Length dependence of egidl"),
IOP( "laigc", BSIM4_MOD_LAIGC, IF_REAL, "Length dependence of aigc"),
IOP( "lbigc", BSIM4_MOD_LBIGC, IF_REAL, "Length dependence of bigc"),
IOP( "lcigc", BSIM4_MOD_LCIGC, IF_REAL, "Length dependence of cigc"),
IOP( "laigsd", BSIM4_MOD_LAIGSD, IF_REAL, "Length dependence of aigsd"),
IOP( "lbigsd", BSIM4_MOD_LBIGSD, IF_REAL, "Length dependence of bigsd"),
IOP( "lcigsd", BSIM4_MOD_LCIGSD, IF_REAL, "Length dependence of cigsd"),
IOP( "laigbacc", BSIM4_MOD_LAIGBACC, IF_REAL, "Length dependence of aigbacc"),
IOP( "lbigbacc", BSIM4_MOD_LBIGBACC, IF_REAL, "Length dependence of bigbacc"),
IOP( "lcigbacc", BSIM4_MOD_LCIGBACC, IF_REAL, "Length dependence of cigbacc"),
IOP( "laigbinv", BSIM4_MOD_LAIGBINV, IF_REAL, "Length dependence of aigbinv"),
IOP( "lbigbinv", BSIM4_MOD_LBIGBINV, IF_REAL, "Length dependence of bigbinv"),
IOP( "lcigbinv", BSIM4_MOD_LCIGBINV, IF_REAL, "Length dependence of cigbinv"),
IOP( "lnigc", BSIM4_MOD_LNIGC, IF_REAL, "Length dependence of nigc"),
IOP( "lnigbinv", BSIM4_MOD_LNIGBINV, IF_REAL, "Length dependence of nigbinv"),
IOP( "lnigbacc", BSIM4_MOD_LNIGBACC, IF_REAL, "Length dependence of nigbacc"),
IOP( "lntox", BSIM4_MOD_LNTOX, IF_REAL, "Length dependence of ntox"),
IOP( "leigbinv", BSIM4_MOD_LEIGBINV, IF_REAL, "Length dependence for eigbinv"),
IOP( "lpigcd", BSIM4_MOD_LPIGCD, IF_REAL, "Length dependence for pigcd"),
IOP( "lpoxedge", BSIM4_MOD_LPOXEDGE, IF_REAL, "Length dependence for poxedge"),

IOP( "lvfbcv", BSIM4_MOD_LVFBCV, IF_REAL, "Length dependence of vfbcv"),
IOP( "lvfb", BSIM4_MOD_LVFB, IF_REAL, "Length dependence of vfb"),
IOP( "lacde", BSIM4_MOD_LACDE, IF_REAL, "Length dependence of acde"),
IOP( "lmoin", BSIM4_MOD_LMOIN, IF_REAL, "Length dependence of moin"),
IOP( "lnoff", BSIM4_MOD_LNOFF, IF_REAL, "Length dependence of noff"),
IOP( "lvoffcv", BSIM4_MOD_LVOFFCV, IF_REAL, "Length dependence of voffcv"),
IOP( "lxrcrg1",  BSIM4_MOD_LXRCRG1, IF_REAL, "Length dependence of xrcrg1"),
IOP( "lxrcrg2",  BSIM4_MOD_LXRCRG2, IF_REAL, "Length dependence of xrcrg2"),
IOP( "leu",  BSIM4_MOD_LEU, IF_REAL, "Length dependence of eu"),
IOP( "wcdsc",  BSIM4_MOD_WCDSC, IF_REAL, "Width dependence of cdsc"),
IOP( "wcdscb", BSIM4_MOD_WCDSCB, IF_REAL, "Width dependence of cdscb"),  
IOP( "wcdscd", BSIM4_MOD_WCDSCD, IF_REAL, "Width dependence of cdscd"),  
IOP( "wcit",   BSIM4_MOD_WCIT,  IF_REAL, "Width dependence of cit"),
IOP( "wnfactor", BSIM4_MOD_WNFACTOR, IF_REAL, "Width dependence of nfactor"),
IOP( "wxj", BSIM4_MOD_WXJ, IF_REAL, "Width dependence of xj"),
IOP( "wvsat", BSIM4_MOD_WVSAT, IF_REAL, "Width dependence of vsat"),
IOP( "wat", BSIM4_MOD_WAT, IF_REAL, "Width dependence of at"),
IOP( "wa0", BSIM4_MOD_WA0, IF_REAL, "Width dependence of a0"), 
IOP( "wags", BSIM4_MOD_WAGS, IF_REAL, "Width dependence of ags"), 
IOP( "wa1", BSIM4_MOD_WA1, IF_REAL, "Width dependence of a1"),
IOP( "wa2", BSIM4_MOD_WA2, IF_REAL, "Width dependence of a2"),
IOP( "wketa", BSIM4_MOD_WKETA, IF_REAL, "Width dependence of keta"),
IOP( "wnsub", BSIM4_MOD_WNSUB, IF_REAL, "Width dependence of nsub"),
IOP( "wndep",  BSIM4_MOD_WNDEP, IF_REAL, "Width dependence of ndep"),
IOP( "wnsd",  BSIM4_MOD_WNSD, IF_REAL, "Width dependence of nsd"),
IOP( "wphin", BSIM4_MOD_WPHIN, IF_REAL, "Width dependence of phin"),
IOP( "wngate", BSIM4_MOD_WNGATE, IF_REAL, "Width dependence of ngate"),
IOP( "wgamma1", BSIM4_MOD_WGAMMA1, IF_REAL, "Width dependence of gamma1"),
IOP( "wgamma2", BSIM4_MOD_WGAMMA2, IF_REAL, "Width dependence of gamma2"),
IOP( "wvbx", BSIM4_MOD_WVBX, IF_REAL, "Width dependence of vbx"),
IOP( "wvbm", BSIM4_MOD_WVBM, IF_REAL, "Width dependence of vbm"),
IOP( "wxt",  BSIM4_MOD_WXT,  IF_REAL, "Width dependence of xt"),
IOP( "wk1",   BSIM4_MOD_WK1,  IF_REAL, "Width dependence of k1"),
IOP( "wkt1",  BSIM4_MOD_WKT1, IF_REAL, "Width dependence of kt1"),
IOP( "wkt1l", BSIM4_MOD_WKT1L, IF_REAL, "Width dependence of kt1l"),
IOP( "wkt2",  BSIM4_MOD_WKT2, IF_REAL, "Width dependence of kt2"),
IOP( "wk2",   BSIM4_MOD_WK2,  IF_REAL, "Width dependence of k2"),
IOP( "wk3",   BSIM4_MOD_WK3,  IF_REAL, "Width dependence of k3"),
IOP( "wk3b",  BSIM4_MOD_WK3B, IF_REAL, "Width dependence of k3b"),
IOP( "ww0",   BSIM4_MOD_WW0,  IF_REAL, "Width dependence of w0"),
IOP( "wdvtp0",  BSIM4_MOD_WDVTP0, IF_REAL, "Width dependence of dvtp0"),
IOP( "wdvtp1",  BSIM4_MOD_WDVTP1, IF_REAL, "Width dependence of dvtp1"),
IOP( "wlpe0",  BSIM4_MOD_WLPE0, IF_REAL, "Width dependence of lpe0"),
IOP( "wlpeb",  BSIM4_MOD_WLPEB, IF_REAL, "Width dependence of lpeb"),
IOP( "wdvt0", BSIM4_MOD_WDVT0, IF_REAL, "Width dependence of dvt0"),
IOP( "wdvt1", BSIM4_MOD_WDVT1, IF_REAL, "Width dependence of dvt1"),
IOP( "wdvt2", BSIM4_MOD_WDVT2, IF_REAL, "Width dependence of dvt2"),
IOP( "wdvt0w", BSIM4_MOD_WDVT0W, IF_REAL, "Width dependence of dvt0w"),
IOP( "wdvt1w", BSIM4_MOD_WDVT1W, IF_REAL, "Width dependence of dvt1w"),
IOP( "wdvt2w", BSIM4_MOD_WDVT2W, IF_REAL, "Width dependence of dvt2w"),
IOP( "wdrout", BSIM4_MOD_WDROUT, IF_REAL, "Width dependence of drout"),
IOP( "wdsub", BSIM4_MOD_WDSUB, IF_REAL, "Width dependence of dsub"),
IOP( "wvth0", BSIM4_MOD_WVTH0, IF_REAL,"Width dependence of vto"),
IOP( "wvtho", BSIM4_MOD_WVTH0, IF_REAL,"Width dependence of vto"),
IOP( "wua",  BSIM4_MOD_WUA, IF_REAL, "Width dependence of ua"),
IOP( "wua1", BSIM4_MOD_WUA1, IF_REAL, "Width dependence of ua1"),
IOP( "wub", BSIM4_MOD_WUB, IF_REAL, "Width dependence of ub"),
IOP( "wub1", BSIM4_MOD_WUB1, IF_REAL, "Width dependence of ub1"),
IOP( "wuc",  BSIM4_MOD_WUC, IF_REAL, "Width dependence of uc"),
IOP( "wuc1", BSIM4_MOD_WUC1, IF_REAL, "Width dependence of uc1"),
IOP( "wu0",  BSIM4_MOD_WU0, IF_REAL, "Width dependence of u0"),
IOP( "wute", BSIM4_MOD_WUTE, IF_REAL, "Width dependence of ute"),
IOP( "wvoff", BSIM4_MOD_WVOFF, IF_REAL, "Width dependence of voff"),
IOP( "wminv", BSIM4_MOD_WMINV, IF_REAL, "Width dependence of minv"),
IOP( "wdelta", BSIM4_MOD_WDELTA, IF_REAL, "Width dependence of delta"),
IOP( "wrdsw", BSIM4_MOD_WRDSW,  IF_REAL, "Width dependence of rdsw "),
IOP( "wrsw", BSIM4_MOD_WRSW, IF_REAL, "Width dependence of rsw"),
IOP( "wrdw", BSIM4_MOD_WRDW, IF_REAL, "Width dependence of rdw"),

IOP( "wprwg", BSIM4_MOD_WPRWG,  IF_REAL, "Width dependence of prwg "),
IOP( "wprwb", BSIM4_MOD_WPRWB,  IF_REAL, "Width dependence of prwb "),

IOP( "wprt", BSIM4_MOD_WPRT, IF_REAL, "Width dependence of prt"),
IOP( "weta0", BSIM4_MOD_WETA0, IF_REAL, "Width dependence of eta0"),   
IOP( "wetab", BSIM4_MOD_WETAB, IF_REAL, "Width dependence of etab"),   
IOP( "wpclm", BSIM4_MOD_WPCLM, IF_REAL, "Width dependence of pclm"),   
IOP( "wpdiblc1", BSIM4_MOD_WPDIBL1, IF_REAL, "Width dependence of pdiblc1"),   
IOP( "wpdiblc2", BSIM4_MOD_WPDIBL2, IF_REAL, "Width dependence of pdiblc2"),   
IOP( "wpdiblcb", BSIM4_MOD_WPDIBLB, IF_REAL, "Width dependence of pdiblcb"),   
IOP( "wfprout", BSIM4_MOD_WFPROUT, IF_REAL, "Width dependence of pdiblcb"),
IOP( "wpdits", BSIM4_MOD_WPDITS, IF_REAL, "Width dependence of pdits"),
IOP( "wpditsd", BSIM4_MOD_WPDITSD, IF_REAL, "Width dependence of pditsd"),
IOP( "wpscbe1",  BSIM4_MOD_WPSCBE1, IF_REAL, "Width dependence of pscbe1"),   
IOP( "wpscbe2",  BSIM4_MOD_WPSCBE2, IF_REAL, "Width dependence of pscbe2"),   
IOP( "wpvag", BSIM4_MOD_WPVAG, IF_REAL, "Width dependence of pvag"),   
IOP( "wwr",  BSIM4_MOD_WWR, IF_REAL, "Width dependence of wr"),
IOP( "wdwg", BSIM4_MOD_WDWG, IF_REAL, "Width dependence of dwg"),
IOP( "wdwb", BSIM4_MOD_WDWB, IF_REAL, "Width dependence of dwb"),
IOP( "wb0",  BSIM4_MOD_WB0, IF_REAL, "Width dependence of b0"),
IOP( "wb1",  BSIM4_MOD_WB1, IF_REAL, "Width dependence of b1"),
IOP( "wcgsl", BSIM4_MOD_WCGSL, IF_REAL, "Width dependence of cgsl"),
IOP( "wcgdl", BSIM4_MOD_WCGDL, IF_REAL, "Width dependence of cgdl"),
IOP( "wckappas", BSIM4_MOD_WCKAPPAS, IF_REAL, "Width dependence of ckappas"),
IOP( "wckappad", BSIM4_MOD_WCKAPPAD, IF_REAL, "Width dependence of ckappad"),
IOP( "wcf",  BSIM4_MOD_WCF,  IF_REAL, "Width dependence of cf"),
IOP( "wclc", BSIM4_MOD_WCLC, IF_REAL, "Width dependence of clc"),
IOP( "wcle", BSIM4_MOD_WCLE, IF_REAL, "Width dependence of cle"),
IOP( "walpha0", BSIM4_MOD_WALPHA0, IF_REAL, "Width dependence of alpha0"),
IOP( "walpha1", BSIM4_MOD_WALPHA1, IF_REAL, "Width dependence of alpha1"),
IOP( "wbeta0", BSIM4_MOD_WBETA0, IF_REAL, "Width dependence of beta0"),
IOP( "wagidl", BSIM4_MOD_WAGIDL, IF_REAL, "Width dependence of agidl"),
IOP( "wbgidl", BSIM4_MOD_WBGIDL, IF_REAL, "Width dependence of bgidl"),
IOP( "wcgidl", BSIM4_MOD_WCGIDL, IF_REAL, "Width dependence of cgidl"),
IOP( "wegidl", BSIM4_MOD_WEGIDL, IF_REAL, "Width dependence of egidl"),
IOP( "waigc", BSIM4_MOD_WAIGC, IF_REAL, "Width dependence of aigc"),
IOP( "wbigc", BSIM4_MOD_WBIGC, IF_REAL, "Width dependence of bigc"),
IOP( "wcigc", BSIM4_MOD_WCIGC, IF_REAL, "Width dependence of cigc"),
IOP( "waigsd", BSIM4_MOD_WAIGSD, IF_REAL, "Width dependence of aigsd"),
IOP( "wbigsd", BSIM4_MOD_WBIGSD, IF_REAL, "Width dependence of bigsd"),
IOP( "wcigsd", BSIM4_MOD_WCIGSD, IF_REAL, "Width dependence of cigsd"),
IOP( "waigbacc", BSIM4_MOD_WAIGBACC, IF_REAL, "Width dependence of aigbacc"),
IOP( "wbigbacc", BSIM4_MOD_WBIGBACC, IF_REAL, "Width dependence of bigbacc"),
IOP( "wcigbacc", BSIM4_MOD_WCIGBACC, IF_REAL, "Width dependence of cigbacc"),
IOP( "waigbinv", BSIM4_MOD_WAIGBINV, IF_REAL, "Width dependence of aigbinv"),
IOP( "wbigbinv", BSIM4_MOD_WBIGBINV, IF_REAL, "Width dependence of bigbinv"),
IOP( "wcigbinv", BSIM4_MOD_WCIGBINV, IF_REAL, "Width dependence of cigbinv"),
IOP( "wnigc", BSIM4_MOD_WNIGC, IF_REAL, "Width dependence of nigc"),
IOP( "wnigbinv", BSIM4_MOD_WNIGBINV, IF_REAL, "Width dependence of nigbinv"),
IOP( "wnigbacc", BSIM4_MOD_WNIGBACC, IF_REAL, "Width dependence of nigbacc"),
IOP( "wntox", BSIM4_MOD_WNTOX, IF_REAL, "Width dependence of ntox"),
IOP( "weigbinv", BSIM4_MOD_WEIGBINV, IF_REAL, "Width dependence for eigbinv"),
IOP( "wpigcd", BSIM4_MOD_WPIGCD, IF_REAL, "Width dependence for pigcd"),
IOP( "wpoxedge", BSIM4_MOD_WPOXEDGE, IF_REAL, "Width dependence for poxedge"),
IOP( "wvfbcv", BSIM4_MOD_WVFBCV, IF_REAL, "Width dependence of vfbcv"),
IOP( "wvfb", BSIM4_MOD_WVFB, IF_REAL, "Width dependence of vfb"),
IOP( "wacde", BSIM4_MOD_WACDE, IF_REAL, "Width dependence of acde"),
IOP( "wmoin", BSIM4_MOD_WMOIN, IF_REAL, "Width dependence of moin"),
IOP( "wnoff", BSIM4_MOD_WNOFF, IF_REAL, "Width dependence of noff"),
IOP( "wvoffcv", BSIM4_MOD_WVOFFCV, IF_REAL, "Width dependence of voffcv"),
IOP( "wxrcrg1",  BSIM4_MOD_WXRCRG1, IF_REAL, "Width dependence of xrcrg1"),
IOP( "wxrcrg2",  BSIM4_MOD_WXRCRG2, IF_REAL, "Width dependence of xrcrg2"),
IOP( "weu",  BSIM4_MOD_WEU, IF_REAL, "Width dependence of eu"),

IOP( "pcdsc",  BSIM4_MOD_PCDSC, IF_REAL, "Cross-term dependence of cdsc"),
IOP( "pcdscb", BSIM4_MOD_PCDSCB, IF_REAL, "Cross-term dependence of cdscb"), 
IOP( "pcdscd", BSIM4_MOD_PCDSCD, IF_REAL, "Cross-term dependence of cdscd"),
IOP( "pcit",   BSIM4_MOD_PCIT,  IF_REAL, "Cross-term dependence of cit"),
IOP( "pnfactor", BSIM4_MOD_PNFACTOR, IF_REAL, "Cross-term dependence of nfactor"),
IOP( "pxj", BSIM4_MOD_PXJ, IF_REAL, "Cross-term dependence of xj"),
IOP( "pvsat", BSIM4_MOD_PVSAT, IF_REAL, "Cross-term dependence of vsat"),
IOP( "pat", BSIM4_MOD_PAT, IF_REAL, "Cross-term dependence of at"),
IOP( "pa0", BSIM4_MOD_PA0, IF_REAL, "Cross-term dependence of a0"), 
IOP( "pags", BSIM4_MOD_PAGS, IF_REAL, "Cross-term dependence of ags"),
IOP( "pa1", BSIM4_MOD_PA1, IF_REAL, "Cross-term dependence of a1"),
IOP( "pa2", BSIM4_MOD_PA2, IF_REAL, "Cross-term dependence of a2"),
IOP( "pketa", BSIM4_MOD_PKETA, IF_REAL, "Cross-term dependence of keta"),
IOP( "pnsub", BSIM4_MOD_PNSUB, IF_REAL, "Cross-term dependence of nsub"),
IOP( "pndep",  BSIM4_MOD_PNDEP, IF_REAL, "Cross-term dependence of ndep"),
IOP( "pnsd",  BSIM4_MOD_PNSD, IF_REAL, "Cross-term dependence of nsd"),
IOP( "pphin", BSIM4_MOD_PPHIN, IF_REAL, "Cross-term dependence of phin"),
IOP( "pngate", BSIM4_MOD_PNGATE, IF_REAL, "Cross-term dependence of ngate"),
IOP( "pgamma1", BSIM4_MOD_PGAMMA1, IF_REAL, "Cross-term dependence of gamma1"),
IOP( "pgamma2", BSIM4_MOD_PGAMMA2, IF_REAL, "Cross-term dependence of gamma2"),
IOP( "pvbx", BSIM4_MOD_PVBX, IF_REAL, "Cross-term dependence of vbx"),
IOP( "pvbm", BSIM4_MOD_PVBM, IF_REAL, "Cross-term dependence of vbm"),
IOP( "pxt",  BSIM4_MOD_PXT,  IF_REAL, "Cross-term dependence of xt"),
IOP( "pk1",   BSIM4_MOD_PK1,  IF_REAL, "Cross-term dependence of k1"),
IOP( "pkt1",  BSIM4_MOD_PKT1, IF_REAL, "Cross-term dependence of kt1"),
IOP( "pkt1l", BSIM4_MOD_PKT1L, IF_REAL, "Cross-term dependence of kt1l"),
IOP( "pkt2",  BSIM4_MOD_PKT2, IF_REAL, "Cross-term dependence of kt2"),
IOP( "pk2",   BSIM4_MOD_PK2,  IF_REAL, "Cross-term dependence of k2"),
IOP( "pk3",   BSIM4_MOD_PK3,  IF_REAL, "Cross-term dependence of k3"),
IOP( "pk3b",  BSIM4_MOD_PK3B, IF_REAL, "Cross-term dependence of k3b"),
IOP( "pw0",   BSIM4_MOD_PW0,  IF_REAL, "Cross-term dependence of w0"),
IOP( "pdvtp0",  BSIM4_MOD_PDVTP0, IF_REAL, "Cross-term dependence of dvtp0"),
IOP( "pdvtp1",  BSIM4_MOD_PDVTP1, IF_REAL, "Cross-term dependence of dvtp1"),
IOP( "plpe0",  BSIM4_MOD_PLPE0, IF_REAL, "Cross-term dependence of lpe0"),
IOP( "plpeb",  BSIM4_MOD_PLPEB, IF_REAL, "Cross-term dependence of lpeb"),
IOP( "pdvt0", BSIM4_MOD_PDVT0, IF_REAL, "Cross-term dependence of dvt0"),
IOP( "pdvt1", BSIM4_MOD_PDVT1, IF_REAL, "Cross-term dependence of dvt1"),
IOP( "pdvt2", BSIM4_MOD_PDVT2, IF_REAL, "Cross-term dependence of dvt2"),
IOP( "pdvt0w", BSIM4_MOD_PDVT0W, IF_REAL, "Cross-term dependence of dvt0w"),
IOP( "pdvt1w", BSIM4_MOD_PDVT1W, IF_REAL, "Cross-term dependence of dvt1w"),
IOP( "pdvt2w", BSIM4_MOD_PDVT2W, IF_REAL, "Cross-term dependence of dvt2w"),
IOP( "pdrout", BSIM4_MOD_PDROUT, IF_REAL, "Cross-term dependence of drout"),
IOP( "pdsub", BSIM4_MOD_PDSUB, IF_REAL, "Cross-term dependence of dsub"),
IOP( "pvth0", BSIM4_MOD_PVTH0, IF_REAL,"Cross-term dependence of vto"),
IOP( "pvtho", BSIM4_MOD_PVTH0, IF_REAL,"Cross-term dependence of vto"),
IOP( "pua",  BSIM4_MOD_PUA, IF_REAL, "Cross-term dependence of ua"),
IOP( "pua1", BSIM4_MOD_PUA1, IF_REAL, "Cross-term dependence of ua1"),
IOP( "pub", BSIM4_MOD_PUB, IF_REAL, "Cross-term dependence of ub"),
IOP( "pub1", BSIM4_MOD_PUB1, IF_REAL, "Cross-term dependence of ub1"),
IOP( "puc",  BSIM4_MOD_PUC, IF_REAL, "Cross-term dependence of uc"),
IOP( "puc1", BSIM4_MOD_PUC1, IF_REAL, "Cross-term dependence of uc1"),
IOP( "pu0",  BSIM4_MOD_PU0, IF_REAL, "Cross-term dependence of u0"),
IOP( "pute", BSIM4_MOD_PUTE, IF_REAL, "Cross-term dependence of ute"),
IOP( "pvoff", BSIM4_MOD_PVOFF, IF_REAL, "Cross-term dependence of voff"),
IOP( "pminv", BSIM4_MOD_PMINV, IF_REAL, "Cross-term dependence of minv"),
IOP( "pdelta", BSIM4_MOD_PDELTA, IF_REAL, "Cross-term dependence of delta"),
IOP( "prdsw", BSIM4_MOD_PRDSW,  IF_REAL, "Cross-term dependence of rdsw "),    
IOP( "prsw", BSIM4_MOD_PRSW, IF_REAL, "Cross-term dependence of rsw"),
IOP( "prdw", BSIM4_MOD_PRDW, IF_REAL, "Cross-term dependence of rdw"),

IOP( "pprwg", BSIM4_MOD_PPRWG,  IF_REAL, "Cross-term dependence of prwg "),    
IOP( "pprwb", BSIM4_MOD_PPRWB,  IF_REAL, "Cross-term dependence of prwb "),    

IOP( "pprt", BSIM4_MOD_PPRT, IF_REAL, "Cross-term dependence of prt "),
IOP( "peta0", BSIM4_MOD_PETA0, IF_REAL, "Cross-term dependence of eta0"),
IOP( "petab", BSIM4_MOD_PETAB, IF_REAL, "Cross-term dependence of etab"),
IOP( "ppclm", BSIM4_MOD_PPCLM, IF_REAL, "Cross-term dependence of pclm"),
IOP( "ppdiblc1", BSIM4_MOD_PPDIBL1, IF_REAL, "Cross-term dependence of pdiblc1"),
IOP( "ppdiblc2", BSIM4_MOD_PPDIBL2, IF_REAL, "Cross-term dependence of pdiblc2"),
IOP( "ppdiblcb", BSIM4_MOD_PPDIBLB, IF_REAL, "Cross-term dependence of pdiblcb"),
IOP( "pfprout", BSIM4_MOD_PFPROUT, IF_REAL, "Cross-term dependence of pdiblcb"),
IOP( "ppdits", BSIM4_MOD_PPDITS, IF_REAL, "Cross-term dependence of pdits"),
IOP( "ppditsd", BSIM4_MOD_PPDITSD, IF_REAL, "Cross-term dependence of pditsd"),
IOP( "ppscbe1",  BSIM4_MOD_PPSCBE1, IF_REAL, "Cross-term dependence of pscbe1"),
IOP( "ppscbe2",  BSIM4_MOD_PPSCBE2, IF_REAL, "Cross-term dependence of pscbe2"),
IOP( "ppvag", BSIM4_MOD_PPVAG, IF_REAL, "Cross-term dependence of pvag"),   
IOP( "pwr",  BSIM4_MOD_PWR, IF_REAL, "Cross-term dependence of wr"),
IOP( "pdwg", BSIM4_MOD_PDWG, IF_REAL, "Cross-term dependence of dwg"),
IOP( "pdwb", BSIM4_MOD_PDWB, IF_REAL, "Cross-term dependence of dwb"),
IOP( "pb0",  BSIM4_MOD_PB0, IF_REAL, "Cross-term dependence of b0"),
IOP( "pb1",  BSIM4_MOD_PB1, IF_REAL, "Cross-term dependence of b1"),
IOP( "pcgsl", BSIM4_MOD_PCGSL, IF_REAL, "Cross-term dependence of cgsl"),
IOP( "pcgdl", BSIM4_MOD_PCGDL, IF_REAL, "Cross-term dependence of cgdl"),
IOP( "pckappas", BSIM4_MOD_PCKAPPAS, IF_REAL, "Cross-term dependence of ckappas"),
IOP( "pckappad", BSIM4_MOD_PCKAPPAD, IF_REAL, "Cross-term dependence of ckappad"),
IOP( "pcf",  BSIM4_MOD_PCF,  IF_REAL, "Cross-term dependence of cf"),
IOP( "pclc", BSIM4_MOD_PCLC, IF_REAL, "Cross-term dependence of clc"),
IOP( "pcle", BSIM4_MOD_PCLE, IF_REAL, "Cross-term dependence of cle"),
IOP( "palpha0", BSIM4_MOD_PALPHA0, IF_REAL, "Cross-term dependence of alpha0"),
IOP( "palpha1", BSIM4_MOD_PALPHA1, IF_REAL, "Cross-term dependence of alpha1"),
IOP( "pbeta0", BSIM4_MOD_PBETA0, IF_REAL, "Cross-term dependence of beta0"),
IOP( "pagidl", BSIM4_MOD_PAGIDL, IF_REAL, "Cross-term dependence of agidl"),
IOP( "pbgidl", BSIM4_MOD_PBGIDL, IF_REAL, "Cross-term dependence of bgidl"),
IOP( "pcgidl", BSIM4_MOD_PCGIDL, IF_REAL, "Cross-term dependence of cgidl"),
IOP( "pegidl", BSIM4_MOD_PEGIDL, IF_REAL, "Cross-term dependence of egidl"),
IOP( "paigc", BSIM4_MOD_PAIGC, IF_REAL, "Cross-term dependence of aigc"),
IOP( "pbigc", BSIM4_MOD_PBIGC, IF_REAL, "Cross-term dependence of bigc"),
IOP( "pcigc", BSIM4_MOD_PCIGC, IF_REAL, "Cross-term dependence of cigc"),
IOP( "paigsd", BSIM4_MOD_PAIGSD, IF_REAL, "Cross-term dependence of aigsd"),
IOP( "pbigsd", BSIM4_MOD_PBIGSD, IF_REAL, "Cross-term dependence of bigsd"),
IOP( "pcigsd", BSIM4_MOD_PCIGSD, IF_REAL, "Cross-term dependence of cigsd"),
IOP( "paigbacc", BSIM4_MOD_PAIGBACC, IF_REAL, "Cross-term dependence of aigbacc"),
IOP( "pbigbacc", BSIM4_MOD_PBIGBACC, IF_REAL, "Cross-term dependence of bigbacc"),
IOP( "pcigbacc", BSIM4_MOD_PCIGBACC, IF_REAL, "Cross-term dependence of cigbacc"),
IOP( "paigbinv", BSIM4_MOD_PAIGBINV, IF_REAL, "Cross-term dependence of aigbinv"),
IOP( "pbigbinv", BSIM4_MOD_PBIGBINV, IF_REAL, "Cross-term dependence of bigbinv"),
IOP( "pcigbinv", BSIM4_MOD_PCIGBINV, IF_REAL, "Cross-term dependence of cigbinv"),
IOP( "pnigc", BSIM4_MOD_PNIGC, IF_REAL, "Cross-term dependence of nigc"),
IOP( "pnigbinv", BSIM4_MOD_PNIGBINV, IF_REAL, "Cross-term dependence of nigbinv"),
IOP( "pnigbacc", BSIM4_MOD_PNIGBACC, IF_REAL, "Cross-term dependence of nigbacc"),
IOP( "pntox", BSIM4_MOD_PNTOX, IF_REAL, "Cross-term dependence of ntox"),
IOP( "peigbinv", BSIM4_MOD_PEIGBINV, IF_REAL, "Cross-term dependence for eigbinv"),
IOP( "ppigcd", BSIM4_MOD_PPIGCD, IF_REAL, "Cross-term dependence for pigcd"),
IOP( "ppoxedge", BSIM4_MOD_PPOXEDGE, IF_REAL, "Cross-term dependence for poxedge"),
IOP( "pvfbcv", BSIM4_MOD_PVFBCV, IF_REAL, "Cross-term dependence of vfbcv"),
IOP( "pvfb", BSIM4_MOD_PVFB, IF_REAL, "Cross-term dependence of vfb"),
IOP( "pacde", BSIM4_MOD_PACDE, IF_REAL, "Cross-term dependence of acde"),
IOP( "pmoin", BSIM4_MOD_PMOIN, IF_REAL, "Cross-term dependence of moin"),
IOP( "pnoff", BSIM4_MOD_PNOFF, IF_REAL, "Cross-term dependence of noff"),
IOP( "pvoffcv", BSIM4_MOD_PVOFFCV, IF_REAL, "Cross-term dependence of voffcv"),
IOP( "pxrcrg1",  BSIM4_MOD_PXRCRG1, IF_REAL, "Cross-term dependence of xrcrg1"),
IOP( "pxrcrg2",  BSIM4_MOD_PXRCRG2, IF_REAL, "Cross-term dependence of xrcrg2"),
IOP( "peu",  BSIM4_MOD_PEU, IF_REAL, "Cross-term dependence of eu"),

IOP( "noia", BSIM4_MOD_NOIA, IF_REAL, "Flicker noise parameter"),
IOP( "noib", BSIM4_MOD_NOIB, IF_REAL, "Flicker noise parameter"),
IOP( "noic", BSIM4_MOD_NOIC, IF_REAL, "Flicker noise parameter"),
IOP( "tnoia", BSIM4_MOD_TNOIA, IF_REAL, "Thermal noise parameter"),
IOP( "tnoib", BSIM4_MOD_TNOIB, IF_REAL, "Thermal noise parameter"),
IOP( "ntnoi", BSIM4_MOD_NTNOI, IF_REAL, "Thermal noise parameter"),
IOP( "em", BSIM4_MOD_EM, IF_REAL, "Flicker noise parameter"),
IOP( "ef", BSIM4_MOD_EF, IF_REAL, "Flicker noise frequency exponent"),
IOP( "af", BSIM4_MOD_AF, IF_REAL, "Flicker noise exponent"),
IOP( "kf", BSIM4_MOD_KF, IF_REAL, "Flicker noise coefficient"),

IP( "nmos", BSIM4_MOD_NMOS,  IF_FLAG, "Flag to indicate NMOS"),
IP( "pmos", BSIM4_MOD_PMOS,  IF_FLAG, "Flag to indicate PMOS"),
};

char *BSIM4names[] = {
   "Drain",
   "Gate",
   "Source",
   "Bulk",
   "Charge"
};

int	BSIM4nSize = NUMELEMS(BSIM4names);
int	BSIM4pTSize = NUMELEMS(BSIM4pTable);
int	BSIM4mPTSize = NUMELEMS(BSIM4mPTable);
int	BSIM4iSize = sizeof(BSIM4instance);
int	BSIM4mSize = sizeof(BSIM4model);



