# 1 "CPUTime.hsc"
-----------------------------------------------------------------------------
# 2 "CPUTime.hsc"
-- |
-- Module      :  System.CPUTime
-- Copyright   :  (c) The University of Glasgow 2001
-- License     :  BSD-style (see the file libraries/base/LICENSE)
-- 
-- Maintainer  :  libraries@haskell.org
-- Stability   :  provisional
-- Portability :  portable
--
-- The standard CPUTime library.
--
-----------------------------------------------------------------------------

module System.CPUTime 
	(
         getCPUTime,       -- :: IO Integer
	 cpuTimePrecision  -- :: Integer
        ) where

import Prelude

import Data.Ratio


# 28 "CPUTime.hsc"


# 30 "CPUTime.hsc"
import CPUTime ( getCPUTime, cpuTimePrecision )

# 32 "CPUTime.hsc"


# 39 "CPUTime.hsc"


# 128 "CPUTime.hsc"

-- |The 'cpuTimePrecision' constant is the smallest measurable difference
-- in CPU time that the implementation can record, and is given as an
-- integral number of picoseconds.


# 137 "CPUTime.hsc"


# 148 "CPUTime.hsc"
