/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Field;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.LitTable;

public class Literal {
    Literal next;
    public Field field;
    Object value;
    int index;
    public Type type;
    public int flags;
    static final int WRITING = 1;
    static final int WRITTEN = 2;
    static final int CYCLIC = 4;
    static final int EMITTED = 8;
    Object[] argValues;
    Type[] argTypes;
    public static final Literal nullLiteral = new Literal(null, Type.nullType);

    public final Object getValue() {
        return this.value;
    }

    void assign(Compilation comp) {
        this.assign((String)null, comp);
    }

    void assign(String name, Compilation comp) {
        int flags;
        int n = flags = comp.immediate ? 9 : 24;
        if (name == null) {
            this.index = comp.literalsCount++;
            name = "Lit" + this.index;
        } else {
            flags |= 1;
        }
        this.assign(comp.curClass.addField(name, this.type, flags), comp);
    }

    void assign(Field field, Compilation comp) {
        this.next = comp.topLambda.literalsChain;
        comp.topLambda.literalsChain = this;
        this.field = field;
    }

    public Literal(Object value, Compilation comp) {
        this(value, (String)null, comp);
    }

    public Literal(Object value, String name, Compilation comp) {
        this.value = value;
        comp.literalTable.put(value, this);
        this.type = Type.make(value.getClass());
        this.assign(name, comp);
    }

    public Literal(Object value, Field field, Compilation comp) {
        this.value = value;
        comp.literalTable.put(value, this);
        this.field = field;
        this.type = field.getType();
        this.flags = 10;
    }

    public Literal(Object value, Type type, Compilation comp) {
        this.value = value;
        comp.literalTable.put(value, this);
        this.type = type;
    }

    Literal(Object value, Type type) {
        this.value = value;
        this.type = type;
    }

    public static void emit(Compilation comp) {
        if (!comp.immediate && comp.literalsChain != null && comp.litTable == null) {
            comp.litTable = new LitTable(comp);
            try {
                comp.litTable.emit();
            }
            catch (Throwable ex) {
                comp.error('e', "Literals: Internal error:" + ex);
                ex.printStackTrace(System.err);
            }
        }
    }
}

