/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.code;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.Inlineable;
import gnu.expr.Target;
import gnu.mapping.Procedure1;

public class IsOfClassProc
extends Procedure1
implements Inlineable {
    private Type type;
    private boolean possiblyNull;
    private static final Method getClassMethod = Type.pointer_type.getDeclaredMethod("getClass", 0);
    private static final Method getNameMethod = ClassType.make("java.lang.Class").getDeclaredMethod("getName", 0);
    private static final Method equalsMethod = Type.pointer_type.getDeclaredMethod("equals", 1);

    public IsOfClassProc(Type type, boolean possiblyNull) {
        this.type = type;
        this.possiblyNull = possiblyNull;
    }

    @Override
    public void compile(ApplyExp exp, Compilation comp, Target target) {
        Expression[] args = exp.getArgs();
        CodeAttr code = comp.getCode();
        args[0].compile(comp, Target.pushObject);
        if (this.possiblyNull) {
            code.emitDup();
            code.emitIfNotNull();
        }
        code.emitInvokeVirtual(getClassMethod);
        code.emitInvokeVirtual(getNameMethod);
        code.emitPushString(this.type.getName());
        code.emitInvokeVirtual(equalsMethod);
        if (this.possiblyNull) {
            code.emitElse();
            code.emitPop(1);
            code.emitPushBoolean(false);
            code.emitFi();
        }
        target.compileFromStack(comp, Type.boolean_type);
    }

    @Override
    public Type getReturnType(Expression[] args) {
        return Type.boolean_type;
    }

    @Override
    public Object apply1(Object arg) {
        throw new Error("Not implemented");
    }
}

