/*
 * Decompiled with CFR 0.152.
 */
package bossa.link;

import bossa.link.Alternative;
import bossa.modules.Package;
import bossa.syntax.ClassDefinition;
import bossa.syntax.JavaMethod;
import bossa.syntax.NiceClass;
import bossa.syntax.NiceMethod;
import bossa.util.Located;
import bossa.util.User;
import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.CatchClause;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.InstantiateProc;
import gnu.expr.LambdaExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.SimpleIfExp;
import gnu.expr.TryExp;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;
import mlsub.typing.TypeConstructor;
import nice.lang.inline.Throw;
import nice.tools.code.Gen;

public final class Compilation {
    private static Method newError;

    static void compile(NiceMethod m, Stack sortedAlternatives, Package module) {
        LambdaExp lexp = m.getLambda();
        int arity = m.getArity();
        Expression[] params = new Expression[arity];
        int rank = 0;
        Declaration param = lexp.firstDecl();
        while (rank < arity) {
            params[rank++] = new ReferenceExp(param);
            param = param.nextDecl();
        }
        Expression body = Compilation.dispatch(((AbstractList)sortedAlternatives).iterator(), m.javaReturnType(), m.javaReturnType().isVoid(), params);
        if (m.isMain()) {
            body = Compilation.beautifyUncaughtExceptions(body);
        }
        Gen.setMethodBody(lexp, m.getContract().compile(body));
    }

    private static Expression dispatch(Iterator sortedAlternatives, Type returnType, boolean voidReturn, Expression[] params) {
        if (!sortedAlternatives.hasNext()) {
            QuoteExp message = new QuoteExp("Message not understood");
            ApplyExp exception = new ApplyExp(new InstantiateProc(newError), new Expression[]{message});
            ApplyExp throwExp = new ApplyExp(Throw.instance, new Expression[]{exception});
            return throwExp;
        }
        Alternative alt = (Alternative)sortedAlternatives.next();
        Expression matchCase = new ApplyExp(alt.methodExp(), params);
        matchCase = voidReturn ? new BeginExp(matchCase, Gen.returnVoid()) : Gen.returnValue(matchCase);
        boolean optimize = true;
        if (optimize && !sortedAlternatives.hasNext()) {
            return matchCase;
        }
        return SimpleIfExp.make(alt.matchTest(params, false), matchCase, Compilation.dispatch(sortedAlternatives, returnType, voidReturn, params));
    }

    private static Expression beautifyUncaughtExceptions(Expression body) {
        TryExp res = new TryExp(body, null);
        CatchClause c = new CatchClause("uncaughtException", Type.throwable_type);
        res.setCatchClauses(c);
        Method print = ClassType.make("nice.lang.dispatch").addMethod("printStackTraceWithSourceInfo", 9, new Type[]{Type.throwable_type}, Type.void_type);
        c.setBody(new ApplyExp(new PrimProcedure(print), new Expression[]{new ReferenceExp(c.getDeclaration())}));
        return res;
    }

    static void compile(JavaMethod m, Stack sortedAlternatives, Package module) {
        int arity = m.getArity();
        while (sortedAlternatives.size() > 0) {
            Iterator i = ((AbstractList)sortedAlternatives).iterator();
            Alternative a = (Alternative)i.next();
            NiceClass c = Compilation.declaringClass(m, a);
            i.remove();
            LinkedList<Alternative> l = new LinkedList<Alternative>();
            l.add(a);
            while (i.hasNext()) {
                a = (Alternative)i.next();
                if (Compilation.declaringClass(m, a) != c) continue;
                l.add(a);
                i.remove();
            }
            Expression[] params = new Expression[arity];
            LambdaExp lambda = Gen.createMemberMethod(m.getName().toString(), c.getClassExp().getType(), m.javaArgTypes(), m.javaReturnType(), params);
            c.addJavaMethod(lambda);
            Expression body = Compilation.dispatchJavaMethod(l.iterator(), m.javaReturnType(), m.javaReturnType().isVoid(), params, (ClassType)c.getClassExp().getType(), m);
            Gen.setMethodBody(lambda, body);
        }
    }

    private static NiceClass declaringClass(JavaMethod m, Alternative alt) {
        TypeConstructor firstArgument = alt.getPatterns()[0].tc;
        ClassDefinition def = ClassDefinition.get(firstArgument);
        if (def == null || !(def.getImplementation() instanceof NiceClass)) {
            throw User.error((Located)alt, m + " is a native method.\n" + "It can not be overriden because the first argument" + (firstArgument == null ? "" : " " + firstArgument.toString()) + " is not a class defined in Nice");
        }
        return (NiceClass)def.getImplementation();
    }

    private static Expression dispatchJavaMethod(Iterator sortedAlternatives, Type returnType, boolean voidReturn, Expression[] params, ClassType c, JavaMethod m) {
        if (!sortedAlternatives.hasNext()) {
            ClassType superClass = c.getSuperclass();
            Method superMethod = superClass.getMethod(m.getName().toString(), m.javaArgTypes(), true);
            if (superMethod != null) {
                return new ApplyExp(new QuoteExp(PrimProcedure.specialCall(superMethod)), params);
            }
            QuoteExp message = new QuoteExp("Message not understood");
            ApplyExp exception = new ApplyExp(new InstantiateProc(newError), new Expression[]{message});
            ApplyExp throwExp = new ApplyExp(Throw.instance, new Expression[]{exception});
            return throwExp;
        }
        Alternative alt = (Alternative)sortedAlternatives.next();
        Expression matchCase = new ApplyExp(alt.methodExp(), params);
        matchCase = voidReturn ? new BeginExp(matchCase, Gen.returnVoid()) : Gen.returnValue(matchCase);
        return SimpleIfExp.make(alt.matchTest(params, true), matchCase, Compilation.dispatchJavaMethod(sortedAlternatives, returnType, voidReturn, params, c, m));
    }

    static {
        ClassType error = ClassType.make("java.lang.Error");
        newError = error.getDeclaredMethod("<init>", new Type[]{Type.string_type});
    }
}

