/*
 * Decompiled with CFR 0.152.
 */
package bossa.modules;

import bossa.modules.Content;
import bossa.modules.Package;
import bossa.modules.SourceContent;
import bossa.util.Located;
import bossa.util.User;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import nice.tools.util.System;

class DirectorySourceContent
extends SourceContent {
    private File[] sources;
    private Package pkg;
    private File directory;
    static final String sourceExtension = ".nice";

    static DirectorySourceContent create(Package pkg, File directory) {
        if (!directory.exists()) {
            return null;
        }
        DirectorySourceContent res = new DirectorySourceContent(pkg, directory);
        if (res.isValid()) {
            return res;
        }
        return null;
    }

    DirectorySourceContent(Package pkg, File directory) {
        this.pkg = pkg;
        this.directory = directory;
        this.sources = this.getSources();
        this.lastModification = this.maxLastModification(this.sources);
    }

    private boolean isValid() {
        return this.sources.length > 0;
    }

    Content.Unit[] getDefinitions() {
        if (this.sources.length == 0) {
            User.error((Located)this.pkg.name, "Package " + this.pkg.getName() + " has no source file in " + System.prettyPrint(this.directory));
        }
        this.sourcesRead = true;
        Content.Unit[] res = new Content.Unit[this.sources.length];
        int i = 0;
        while (i < res.length) {
            res[i] = new Content.Unit(this.read(this.sources[i]), this.sources[i]);
            ++i;
        }
        return res;
    }

    private long maxLastModification(File[] files) {
        long res = 0L;
        int i = 0;
        while (i < files.length) {
            long time = files[i].lastModified();
            if (time > res) {
                res = time;
            }
            ++i;
        }
        return res;
    }

    private File[] getSources() {
        File[] res = this.directory.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.getPath().endsWith(DirectorySourceContent.sourceExtension) && f.isFile();
            }
        });
        if (res == null) {
            User.error((Located)this.pkg, "Could not list source files in " + this.getName());
        }
        if (this.pkg.name.toString().equals("nice.lang")) {
            int i = 0;
            while (i < res.length) {
                if (res[i].getName().equals("prelude.nice")) {
                    File tmp = res[i];
                    res[i] = res[0];
                    res[0] = tmp;
                    break;
                }
                ++i;
            }
        }
        return res;
    }

    private BufferedReader read(File f) {
        try {
            return new BufferedReader(new FileReader(f));
        }
        catch (FileNotFoundException e) {
            User.error(System.prettyPrint(f) + " of package " + this.pkg.getName() + " could not be found");
            return null;
        }
    }

    File getOutputDirectory() {
        return this.directory;
    }

    public String getName() {
        return System.prettyPrint(this.directory);
    }

    public String toString() {
        return "Source files in: " + this.getName();
    }
}

