/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.CallExp;
import bossa.syntax.Expression;
import bossa.syntax.IdentExp;
import bossa.syntax.LocatedString;

public class AssignExp
extends Expression {
    Expression to;
    Expression value;

    private AssignExp(Expression to, Expression value) {
        this.to = to;
        this.value = value;
    }

    public static Expression create(Expression to, Expression value) {
        if (to instanceof CallExp && "get".equals(((CallExp)to).function.toString())) {
            CallExp call = (CallExp)to;
            return CallExp.create(new IdentExp(new LocatedString("set", call.function.location())), call.arguments.getExp(0), call.arguments.getExp(1), value);
        }
        return new AssignExp(to, value);
    }

    void computeType() {
        this.type = this.value.getType();
    }

    public gnu.expr.Expression compile() {
        return this.to.compileAssign(this.value.generateCode());
    }

    public String toString() {
        return this.to + " = " + this.value;
    }
}

