/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.JavaClasses;
import bossa.syntax.LocatedString;
import bossa.syntax.MethodContainer;
import bossa.syntax.NiceClass;
import bossa.syntax.PrimitiveType;
import bossa.syntax.TypeConstructors;
import bossa.syntax.TypeIdent;
import bossa.syntax.TypeScope;
import bossa.util.Located;
import bossa.util.User;
import bossa.util.Util;
import gnu.bytecode.Type;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import mlsub.typing.KindingEx;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.MonotypeVar;
import mlsub.typing.NullnessKind;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeSymbol;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import nice.tools.code.Types;

public abstract class ClassDefinition
extends MethodContainer {
    protected List implementations;
    protected List abstractions;
    mlsub.typing.Interface[] impl;
    mlsub.typing.Interface[] abs;
    private static Map tcToClassDef;
    private int status = NOT_RESOLVED;
    private static int NOT_RESOLVED;
    private static int RESOLVING;
    private static int RESOLVED;
    TypeConstructor[] javaInterfaces;
    private Type javaType;
    TypeConstructor tc;
    ClassImplementation implementation;

    public static Interface makeInterface(LocatedString name, MethodContainer.Constraint typeParameters, List typeParametersVariances, List extensions, List implementations, List abstractions) {
        return new Interface(name, typeParameters, typeParametersVariances, extensions, implementations, abstractions);
    }

    public static Class makeClass(LocatedString name, boolean isFinal, boolean isAbstract, MethodContainer.Constraint typeParameters, List typeParametersVariances, TypeIdent superClassIdent, List implementations, List abstractions) {
        return new Class(name, isFinal, isAbstract, typeParameters, typeParametersVariances, superClassIdent, implementations, abstractions);
    }

    public ClassDefinition(LocatedString name, MethodContainer.Constraint typeParameters, List typeParametersVariances, List implementations, List abstractions) {
        super(name, 3, typeParameters, typeParametersVariances);
        this.implementations = implementations;
        this.abstractions = abstractions;
    }

    void createTC() {
        String name = this.name.toString();
        if (name.equals("nice.lang.Array")) {
            this.tc = new TypeConstructor(name, this.variance, this.isConcrete(), true){

                public String toString(Monotype[] parameters) {
                    return parameters[0].toString(false, "[]");
                }

                public String toString(Monotype[] parameters, boolean isNull, String suffix) {
                    if (suffix == null) {
                        suffix = "";
                    }
                    return parameters[0].toString(false, suffix + (isNull ? "[?]" : "[]"));
                }
            };
        } else if (name.equals("nice.lang.Sure")) {
            this.tc = new TypeConstructor(name, NullnessKind.instance, this.isConcrete(), true){

                public String toString(Monotype[] parameters, boolean isNull, String suffix) {
                    if (parameters[0] instanceof MonotypeVar) {
                        return "!" + parameters[0].toString(false, suffix);
                    }
                    return parameters[0].toString(false, suffix);
                }
            };
        } else if (name.equals("nice.lang.Maybe")) {
            this.tc = new TypeConstructor(name, NullnessKind.instance, this.isConcrete(), true){

                public String toString(Monotype[] parameters, boolean isNull, String suffix) {
                    return parameters[0].toString(true, suffix);
                }
            };
        } else if (name.equals("nice.lang.Null")) {
            this.tc = new TypeConstructor("null", NullnessKind.instance, this.isConcrete(), true);
            PrimitiveType.registerPrimType(name, this.tc);
        } else {
            this.tc = new TypeConstructor(name, this.variance, this.isConcrete(), true);
            if (name.equals("nice.lang.Throwable")) {
                PrimitiveType.throwableTC = this.tc;
            } else if (name.equals("nice.lang.Collection")) {
                PrimitiveType.collectionTC = this.tc;
            }
        }
        tcToClassDef.put(this.tc, this);
        Typing.introduce(this.tc);
        this.addTypeSymbol(this.tc);
    }

    TypeScope getLocalScope() {
        TypeScope localScope = this.typeScope;
        if (this.classConstraint != null) {
            try {
                localScope = new TypeScope(localScope);
                TypeSymbol[] binders = this.getBinders();
                int i = 0;
                while (i < binders.length) {
                    localScope.addSymbol(binders[i]);
                    ++i;
                }
            }
            catch (TypeScope.DuplicateName e) {
                User.error((Located)this, e);
            }
        }
        return localScope;
    }

    public static void reset() {
        tcToClassDef = new HashMap();
    }

    public static final ClassDefinition get(TypeConstructor tc) {
        return (ClassDefinition)tcToClassDef.get(tc);
    }

    public abstract TypeSymbol getTypeSymbol();

    public abstract mlsub.typing.Interface getAssociatedInterface();

    protected Monotype lowlevelMonotype() {
        return new MonotypeConstructor(this.tc, this.getTypeParameters());
    }

    public abstract boolean isConcrete();

    abstract int getBytecodeFlags();

    abstract boolean implementsJavaInterface(String var1);

    void resolve() {
        if (this.status == RESOLVED) {
            return;
        }
        if (this.status == RESOLVING) {
            String message = TypeConstructors.isInterface(this.tc) ? "Interface " + this.getName() + " extends itself" : "Class " + this.getName() + " extends itself";
            throw User.error((Located)this, message);
        }
        this.status = RESOLVING;
        try {
            super.resolve();
            this.resolveClass();
            Object var3_2 = null;
            this.status = RESOLVED;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.status = RESOLVED;
            throw throwable;
        }
    }

    void resolveClass() {
        this.impl = this.resolveInterfaces(this.implementations);
        this.abs = TypeIdent.resolveToItf(this.typeScope, this.abstractions);
        this.abstractions = null;
        this.implementations = null;
        if (this.impl != null) {
            int i = 0;
            while (i < this.impl.length) {
                ClassDefinition d = ClassDefinition.get(this.impl[i].associatedTC());
                if (d != null) {
                    d.resolve();
                }
                ++i;
            }
        }
        this.createContext();
        this.implementation.resolveClass();
    }

    mlsub.typing.Interface[] resolveInterfaces(List names) {
        if (names == null) {
            return null;
        }
        mlsub.typing.Interface[] res = new mlsub.typing.Interface[names.size()];
        int n = 0;
        ArrayList<TypeSymbol> javaInterfaces = null;
        Iterator i = names.iterator();
        while (i.hasNext()) {
            TypeIdent name = (TypeIdent)i.next();
            TypeSymbol s = name.resolvePreferablyToItf(this.typeScope);
            if (s instanceof mlsub.typing.Interface) {
                res[n++] = (mlsub.typing.Interface)s;
                continue;
            }
            TypeConstructor tc = (TypeConstructor)s;
            if (!TypeConstructors.isInterface(tc)) {
                throw User.error((Located)name, tc + " is not an interface");
            }
            if (javaInterfaces == null) {
                javaInterfaces = new ArrayList<TypeSymbol>(5);
            }
            javaInterfaces.add(s);
        }
        if (n < res.length) {
            mlsub.typing.Interface[] tmp = new mlsub.typing.Interface[n];
            System.arraycopy(res, 0, tmp, 0, n);
            res = tmp;
            this.javaInterfaces = javaInterfaces.toArray(new TypeConstructor[javaInterfaces.size()]);
        }
        return res;
    }

    void resolveBody() {
        this.implementation.resolveBody();
    }

    void typecheckClass() {
        this.implementation.typecheck();
    }

    void typecheck() {
    }

    void precompile() {
        if (this.implementation instanceof NiceClass) {
            ((NiceClass)this.implementation).precompile();
        }
    }

    void compile() {
        this.implementation.compile();
    }

    void recompile() {
        this.implementation.recompile();
    }

    void createContext() {
        try {
            if (this.impl != null) {
                try {
                    Typing.assertImp(this.tc, this.impl, true);
                }
                catch (KindingEx e) {
                    User.error((Located)this.name, "Class " + this.name + " cannot implement " + e.t2 + ": they do not have the same number or kind of type parameters");
                }
            }
            if (this.abs != null) {
                Typing.assertImp(this.tc, this.abs, true);
                Typing.assertAbs(this.tc, this.abs);
            }
        }
        catch (TypingEx e) {
            User.error((Located)this.name, "Error in " + this.name + " : " + e.getMessage());
        }
    }

    abstract TypeConstructor getSuperClass();

    abstract mlsub.typing.Interface[] getInterfaces();

    protected void setJavaType(Type javaType) {
        this.javaType = javaType;
        Types.set(this.tc, javaType);
    }

    final Type getJavaType() {
        return this.javaType;
    }

    public String toString() {
        return "class " + this.name;
    }

    String printInterfaces(String keyword, mlsub.typing.Interface[] interfaces) {
        StringBuffer res = new StringBuffer();
        if (interfaces != null || this.javaInterfaces != null) {
            res.append(keyword);
            String sNice = Util.map("", ", ", "", interfaces);
            res.append(sNice);
            String sJava = Util.map("", ", ", "", this.javaInterfaces);
            if (sNice != "" && sJava != "") {
                res.append(", ");
            }
            res.append(sJava);
        }
        return res.toString();
    }

    public void setImplementation(ClassImplementation implementation) {
        this.implementation = implementation;
    }

    public ClassImplementation getImplementation() {
        return this.implementation;
    }

    static {
        NOT_RESOLVED = 0;
        RESOLVING = 1;
        RESOLVED = 2;
    }

    static abstract class ClassImplementation {
        ClassImplementation() {
        }

        abstract void resolveClass();

        void resolveBody() {
        }

        void typecheck() {
        }

        void compile() {
        }

        void recompile() {
        }

        abstract void printInterface(PrintWriter var1);
    }

    public static class Class
    extends ClassDefinition {
        TypeIdent superClassIdent;
        TypeConstructor superClass;
        protected boolean isFinal;
        boolean isAbstract;

        Class(LocatedString name, boolean isFinal, boolean isAbstract, MethodContainer.Constraint typeParameters, List typeParametersVariances, TypeIdent superClassIdent, List implementations, List abstractions) {
            super(name, typeParameters, typeParametersVariances, implementations, abstractions);
            this.isFinal = isFinal;
            this.isAbstract = isAbstract;
            this.superClassIdent = superClassIdent;
            this.createTC();
            if (isFinal) {
                this.tc.setMinimal();
            }
        }

        public boolean isConcrete() {
            return !this.isAbstract;
        }

        int getBytecodeFlags() {
            if (this.isFinal) {
                return 16;
            }
            if (this.isAbstract) {
                return 1024;
            }
            return 0;
        }

        boolean implementsJavaInterface(String name) {
            if (this.javaInterfaces != null) {
                int i = 0;
                while (i < this.javaInterfaces.length) {
                    if (this.javaInterfaces[i].toString().equals(name)) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        public TypeSymbol getTypeSymbol() {
            return this.tc;
        }

        public mlsub.typing.Interface getAssociatedInterface() {
            return null;
        }

        TypeConstructor getSuperClass() {
            return this.superClass;
        }

        public Class getSuperClassDefinition() {
            return (Class)ClassDefinition.get(this.superClass);
        }

        mlsub.typing.Interface[] getInterfaces() {
            return this.impl;
        }

        public Interface[] getImplementedInterfaces() {
            if (this.impl == null) {
                return null;
            }
            LinkedList<ClassDefinition> res = new LinkedList<ClassDefinition>();
            int i = 0;
            while (i < this.impl.length) {
                ClassDefinition itf = ClassDefinition.get(this.impl[i].associatedTC());
                if (itf != null) {
                    res.add(itf);
                }
                ++i;
            }
            return res.toArray(new Interface[res.size()]);
        }

        void resolveClass() {
            Class d;
            if (this.superClassIdent != null) {
                this.superClass = this.superClassIdent.resolveToTC(this.typeScope);
                if (this.superClass.isMinimal()) {
                    User.error((Located)this.superClassIdent, this.superClass + " is a final class. It cannot be extended");
                }
                if (TypeConstructors.isInterface(this.superClass)) {
                    User.error((Located)this.superClassIdent, this.superClass + " is an interface, so " + this.name + " may only implement it");
                }
                this.superClassIdent = null;
            }
            if ((d = this.getSuperClassDefinition()) != null) {
                d.resolve();
            }
            super.resolveClass();
        }

        void createContext() {
            block9: {
                try {
                    if (this.superClass != null) {
                        try {
                            Typing.initialLeq(this.tc, this.superClass);
                        }
                        catch (KindingEx e) {
                            User.error((Located)this.name, "Class " + this.name + " cannot extend " + e.t2 + ": they do not have the same number or kind of type parameters");
                        }
                    }
                    if (this.javaInterfaces == null) break block9;
                    int i = 0;
                    while (i < this.javaInterfaces.length) {
                        if (this.tc.arity() == 0 || !JavaClasses.excludedInterface(this.javaInterfaces[i])) {
                            try {
                                Typing.initialLeq(this.tc, this.javaInterfaces[i]);
                            }
                            catch (KindingEx e) {
                                User.error((Located)this.name, "Class " + this.name + " cannot implement " + e.t2 + ": they do not have the same number or kind of type parameters");
                            }
                        }
                        ++i;
                    }
                }
                catch (TypingEx e) {
                    User.error((Located)this.name, "Error in class " + this.name + " : " + e.getMessage());
                }
            }
            super.createContext();
        }

        public void printInterface(PrintWriter s) {
            super.printInterface(s);
            if (this.isFinal) {
                s.print("final ");
            }
            if (this.isAbstract) {
                s.print("abstract ");
            }
            s.print("class ");
            s.print(this.getSimpleName());
            s.print(this.printTypeParameters());
            if (this.superClass != null) {
                s.print(" extends " + this.superClass);
            }
            s.print(this.printInterfaces(" implements ", this.impl));
            s.print(Util.map(" finally implements ", ", ", "", this.abs));
            this.implementation.printInterface(s);
        }
    }

    public static class Interface
    extends ClassDefinition {
        private mlsub.typing.Interface associatedInterface;
        protected List extensions;
        mlsub.typing.Interface[] extendedInterfaces;

        Interface(LocatedString name, MethodContainer.Constraint typeParameters, List typeParametersVariances, List extensions, List implementations, List abstractions) {
            super(name, typeParameters, typeParametersVariances, implementations, abstractions);
            this.extensions = extensions;
            this.createTC();
            this.associatedInterface = new mlsub.typing.Interface(this.variance, this.tc);
        }

        public boolean isConcrete() {
            return false;
        }

        int getBytecodeFlags() {
            return 512;
        }

        boolean implementsJavaInterface(String name) {
            return false;
        }

        public TypeSymbol getTypeSymbol() {
            return this.associatedInterface;
        }

        TypeConstructor getSuperClass() {
            return null;
        }

        mlsub.typing.Interface[] getInterfaces() {
            return this.extendedInterfaces;
        }

        void resolveClass() {
            this.extendedInterfaces = this.resolveInterfaces(this.extensions);
            this.extensions = null;
            if (this.extendedInterfaces != null) {
                int i = 0;
                while (i < this.extendedInterfaces.length) {
                    ClassDefinition d = ClassDefinition.get(this.extendedInterfaces[i].associatedTC());
                    if (d != null) {
                        d.resolve();
                    }
                    ++i;
                }
            }
            this.createAssociatedInterface();
            super.resolveClass();
        }

        void createContext() {
            try {
                if (this.extendedInterfaces != null) {
                    try {
                        Typing.assertImp(this.tc, this.extendedInterfaces, true);
                    }
                    catch (KindingEx e) {
                        User.error((Located)this.name, "Interface " + this.name + " cannot extend " + e.t2 + ": they do not have the same number or kind of type parameters");
                    }
                }
                if (this.javaInterfaces != null) {
                    int i = 0;
                    while (i < this.javaInterfaces.length) {
                        try {
                            Typing.initialLeq(this.tc, this.javaInterfaces[i]);
                        }
                        catch (KindingEx e) {
                            User.error((Located)this.name, "Interface " + this.name + " cannot extend " + e.t2 + ": they do not have the same number or kind of type parameters");
                        }
                        ++i;
                    }
                }
                Typing.assertImp(this.tc, this.associatedInterface, true);
            }
            catch (TypingEx e) {
                User.error((Located)this.name, "Error in interface " + this.name + " : " + e.getMessage());
            }
            super.createContext();
        }

        public void printInterface(PrintWriter s) {
            super.printInterface(s);
            s.print("interface ");
            s.print(this.getSimpleName());
            s.print(this.printTypeParameters());
            s.print(this.printInterfaces(" extends ", this.extendedInterfaces));
            this.implementation.printInterface(s);
        }

        public mlsub.typing.Interface getAssociatedInterface() {
            return this.associatedInterface;
        }

        private void createAssociatedInterface() {
            if (this.extendedInterfaces != null) {
                int i = 0;
                while (i < this.extendedInterfaces.length) {
                    mlsub.typing.Interface ai = this.extendedInterfaces[i];
                    try {
                        Typing.assertLeq(this.associatedInterface, ai);
                    }
                    catch (KindingEx e) {
                        User.error((Located)this, "Cannot extend interface " + ai + " which has a different variance");
                    }
                    ++i;
                }
            }
        }
    }
}

