/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.CallExp;
import bossa.syntax.FieldAccess;
import bossa.util.Debug;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.Printable;
import gnu.bytecode.ClassType;
import gnu.expr.Declaration;
import gnu.expr.SetExp;
import java.util.List;
import mlsub.typing.Monotype;
import mlsub.typing.Polytype;

public abstract class Expression
implements Located,
Printable {
    public static final Expression[] noExpressions = new Expression[0];
    private Location location = Location.nowhere();
    protected Polytype type;

    static final Expression[] toArray(List expressions) {
        if (expressions == null || expressions.size() == 0) {
            return noExpressions;
        }
        return expressions.toArray(new Expression[expressions.size()]);
    }

    public boolean isAssignable() {
        return false;
    }

    final boolean isFieldAccess() {
        return this.getFieldAccessMethod() != null;
    }

    FieldAccess getFieldAccessMethod() {
        return null;
    }

    FieldAccess getField() {
        return null;
    }

    ClassType staticClass() {
        return null;
    }

    boolean isZero() {
        return false;
    }

    boolean isFalse() {
        return false;
    }

    boolean isTrue() {
        return false;
    }

    Expression resolveOverloading(CallExp callExp) {
        return this;
    }

    Expression resolveOverloading(Polytype expectedType) {
        return this.noOverloading();
    }

    Expression noOverloading() {
        return this;
    }

    void adjustToExpectedType(Monotype expectedType) {
    }

    static void adjustToExpectedType(Expression[] expressions, Monotype[] types) {
        if (types == null) {
            return;
        }
        int i = 0;
        while (i < types.length) {
            expressions[i].adjustToExpectedType(types[i]);
            ++i;
        }
    }

    abstract void computeType();

    public Polytype getType() {
        if (this.type == null) {
            this.computeType();
        }
        if (this.type == null) {
            Debug.println(this + "(" + this.getClass() + ") has null type");
        }
        return this.type;
    }

    static Polytype[] getType(Expression[] expressions) {
        Polytype[] res = new Polytype[expressions.length];
        int i = 0;
        while (i < expressions.length) {
            expressions[i] = expressions[i].noOverloading();
            res[i] = expressions[i].getType();
            ++i;
        }
        return res;
    }

    void checkSpecialRequirements(Expression[] arguments) {
    }

    protected abstract gnu.expr.Expression compile();

    final gnu.expr.Expression generateCode() {
        gnu.expr.Expression res = this.compile();
        this.location().write(res);
        return res;
    }

    gnu.expr.Expression generateCodeInCallPosition() {
        return this.generateCode();
    }

    public static gnu.expr.Expression[] compile(Expression[] expressions) {
        gnu.expr.Expression[] res = new gnu.expr.Expression[expressions.length];
        int i = 0;
        while (i < res.length) {
            res[i] = expressions[i].generateCode();
            ++i;
        }
        return res;
    }

    Declaration getDeclaration() {
        return null;
    }

    gnu.expr.Expression compileAssign(gnu.expr.Expression value) {
        Declaration decl = this.getDeclaration();
        if (decl != null) {
            SetExp res = new SetExp(decl, value);
            res.setHasValue(true);
            return res;
        }
        Internal.error(this, this + " doesn't know how to be modified, it is a " + this.getClass());
        return null;
    }

    public void setLocation(Location l) {
        this.location = l;
    }

    public final Location location() {
        return this.location;
    }

    public String toString(int param) {
        return this.toString();
    }
}

