/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Definition;
import bossa.syntax.Expression;
import bossa.syntax.LocatedString;
import bossa.syntax.MonoSymbol;
import bossa.syntax.Monotype;
import bossa.syntax.dispatch;
import bossa.util.Located;
import bossa.util.User;
import gnu.expr.Declaration;
import java.io.PrintWriter;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import nice.tools.code.Types;

public class GlobalVarDeclaration
extends Definition {
    protected Expression value = null;
    MonoSymbol left;
    boolean constant;

    public GlobalVarDeclaration(LocatedString name, Monotype type, Expression value, boolean constant) {
        super(name, 1);
        this.left = new GlobalVarSymbol(name, type, constant);
        this.constant = constant;
        this.addChild(this.left);
        this.value = value;
    }

    void resolve() {
        if (this.value != null) {
            this.value = dispatch.analyse(this.value, this.scope, this.typeScope);
        }
    }

    void typecheck() {
        if (this.value == null) {
            return;
        }
        try {
            this.value = this.value.resolveOverloading(this.left.getType());
            dispatch.typecheck(this.value);
            Typing.leq(this.value.getType(), this.left.getType());
        }
        catch (TypingEx e) {
            User.error((Located)this, "Typing error : " + this.left + " cannot be assigned value " + this.value + " of type " + this.value.getType() + " : \n" + e);
        }
    }

    public void printInterface(PrintWriter s) {
        if (this.constant) {
            s.print("let ");
        } else {
            s.print("var ");
        }
        s.print(this.left + " = " + this.value.toString() + ";\n");
    }

    public void precompile() {
        gnu.expr.Expression value = this.value != null ? this.value.compile() : null;
        Declaration declaration = this.left.getDeclaration();
        if (this.constant) {
            declaration.setFlag(16384);
        }
        declaration.noteValue(value);
    }

    public void compile() {
    }

    public String toString() {
        return this.left + (this.value == null ? "" : " = " + this.value);
    }

    class GlobalVarSymbol
    extends MonoSymbol {
        boolean constant;

        GlobalVarSymbol(LocatedString name, Monotype type, boolean con) {
            super(name, type);
            this.constant = con;
        }

        boolean isAssignable() {
            return !this.constant;
        }

        Declaration getDeclaration() {
            Declaration res = super.getDeclaration();
            if (res == null) {
                res = GlobalVarDeclaration.this.module.addGlobalVar(GlobalVarDeclaration.this.left.name.toString(), Types.javaType(GlobalVarDeclaration.this.left.type), this.constant);
                this.setDeclaration(res);
            }
            return res;
        }

        Expression getValue() {
            return GlobalVarDeclaration.this.value;
        }

        public Definition getDefinition() {
            return GlobalVarDeclaration.this;
        }
    }
}

