/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.ClassDefinition;
import bossa.syntax.Definition;
import bossa.syntax.Function;
import bossa.syntax.LocatedString;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.MonoSymbol;
import bossa.syntax.Monotype;
import bossa.syntax.NiceClass;
import bossa.syntax.Node;
import bossa.syntax.Pattern;
import bossa.syntax.Statement;
import bossa.syntax.SymbolExp;
import bossa.syntax.VarSymbol;
import bossa.syntax.dispatch;
import bossa.util.Debug;
import bossa.util.Located;
import bossa.util.User;
import gnu.bytecode.MiscAttr;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.ReferenceExp;
import mlsub.typing.AtomicKind;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.MonotypeVar;
import mlsub.typing.Polytype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import nice.tools.code.Gen;
import nice.tools.code.Types;

public abstract class MethodImplementation
extends Definition
implements Function {
    ReferenceExp ref;
    LambdaExp compiledMethod;
    protected MethodDeclaration declaration;
    protected MonoSymbol[] parameters;
    protected Pattern[] formals;
    protected Statement body;

    MethodImplementation(LocatedString name, Statement body, Pattern[] formals) {
        super(name, 2);
        this.body = body;
        this.formals = formals;
    }

    public MethodDeclaration getDeclaration() {
        return this.declaration;
    }

    public Pattern[] getPatterns() {
        return this.formals;
    }

    boolean hasThis() {
        return this.declaration.formalParameters().hasThis();
    }

    void buildSymbols() {
        mlsub.typing.Monotype[] types = this.declaration.getArgTypes();
        if (this.formals.length != types.length) {
            switch (types.length) {
                case 0: {
                    User.error((Located)this, "Method " + this.name + " has no parameters");
                }
                case 1: {
                    User.error((Located)this, "Method " + this.name + " has 1 parameter");
                }
            }
            User.error((Located)this, "Method " + this.name + " has " + types.length + " parameters");
        }
        VarSymbol[] res = new MonoSymbol[this.formals.length];
        int tn = 0;
        while (tn < this.formals.length) {
            mlsub.typing.Monotype type;
            Pattern p = this.formals[tn];
            if (p.atAny()) {
                type = types[tn];
            } else if (p.getRuntimeTC() != null) {
                AtomicKind v = p.tc.variance;
                p.getRuntimeTC().setVariance(v);
                type = new MonotypeConstructor(p.getRuntimeTC(), MonotypeVar.news(v.arity()));
                type.setKind(v);
                type = Monotype.sure(type);
            } else {
                type = p.name == null ? new MonotypeVar(types[tn].toString() + "(argument_" + tn + ")") : new MonotypeVar(types[tn].toString() + "(" + p.name + ")");
            }
            res[tn] = new MonoSymbol(p.name, type);
            ++tn;
        }
        this.scope.addSymbols(res);
        this.parameters = res;
    }

    void resolveBody() {
        if (this.hasThis()) {
            Node.thisExp = new SymbolExp(this.parameters[0], this.location());
        }
        try {
            this.body = dispatch.analyse(this.body, this.scope, this.typeScope, !Types.isVoid(this.declaration.getReturnType()));
            Object var2_1 = null;
            Node.thisExp = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            Node.thisExp = null;
            throw throwable;
        }
    }

    public mlsub.typing.Monotype getExpectedType() {
        return this.declaration.getReturnType();
    }

    public void checkReturnedType(Polytype returned) throws Function.WrongReturnType {
        try {
            Typing.leq(returned, this.declaration.getReturnType());
        }
        catch (TypingEx e) {
            throw new Function.WrongReturnType(e, this.declaration.getReturnType());
        }
    }

    protected abstract Type[] javaArgTypes();

    public ReferenceExp getRefExp() {
        if (this.ref == null) {
            this.ref = this.createRef();
            Gen.setMethodBody(this.compiledMethod, this.body.generateCode());
        }
        return this.ref;
    }

    public void compile() {
        if (Debug.codeGeneration) {
            Debug.println("Compiling method body " + this);
        }
        this.getRefExp();
        this.createSerializationMethod();
    }

    private ReferenceExp createRef() {
        this.createMethod(this.name.toString());
        ReferenceExp ref = this.module.addMethod(this.compiledMethod, true);
        return ref;
    }

    private void createMethod(String bytecodeName) {
        this.compiledMethod = Gen.createMethod(bytecodeName, this.javaArgTypes(), this.declaration.javaReturnType(), this.parameters, true, false);
        this.compiledMethod.addBytecodeAttribute(new MiscAttr("definition", this.declaration.getFullName().getBytes()));
        this.compiledMethod.addBytecodeAttribute(new MiscAttr("patterns", Pattern.bytecodeRepresentation(this.formals).getBytes()));
    }

    abstract TypeConstructor firstArgument();

    private void createSerializationMethod() {
        Type[] typeArray;
        boolean isPrivate;
        int arity = this.formals.length;
        String name = this.name.toString();
        if (arity == 2 && (name.equals("writeObject") || name.equals("readObject"))) {
            isPrivate = true;
        } else if (arity == 1 && (name.equals("writeReplace") || name.equals("readResolve"))) {
            isPrivate = false;
        } else {
            return;
        }
        ClassDefinition def = ClassDefinition.get(this.firstArgument());
        if (def == null || !(def.getImplementation() instanceof NiceClass)) {
            return;
        }
        NiceClass c = (NiceClass)def.getImplementation();
        Expression[] params = new Expression[arity];
        String string = name.toString();
        Type type = c.getClassExp().getType();
        if (arity == 2) {
            Type[] typeArray2 = new Type[1];
            typeArray = typeArray2;
            typeArray2[0] = this.declaration.javaArgTypes()[1];
        } else {
            typeArray = null;
        }
        LambdaExp method = Gen.createMemberMethod(string, type, typeArray, this.declaration.javaReturnType(), params);
        Gen.setMethodBody(method, new ApplyExp(this.getRefExp(), params));
        c.getClassExp().addMethod(method, isPrivate);
    }
}

