/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.LocatedString;
import bossa.syntax.PrimitiveType;
import bossa.syntax.TypeIdent;
import bossa.syntax.TypeMap;
import bossa.util.Debug;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.Location;
import bossa.util.User;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.MonotypeVar;
import mlsub.typing.TypeSymbol;
import nice.tools.code.Types;

public abstract class Monotype
implements Located {
    static final Monotype[] array0 = new Monotype[0];
    public byte nullness;
    public static final byte none = 0;
    public static final byte maybe = 1;
    public static final byte sure = 2;
    public static final byte absent = 3;

    static final Monotype[] toArray(List monotypes) {
        if (monotypes == null) {
            return array0;
        }
        return monotypes.toArray(new Monotype[monotypes.size()]);
    }

    static Monotype fresh(LocatedString associatedVariable) {
        return new TypeIdent(associatedVariable);
    }

    static Monotype[] freshs(int arity, LocatedString associatedVariable) {
        Monotype[] res = new Monotype[arity];
        int i = 0;
        while (i < arity) {
            res[i] = Monotype.fresh(new LocatedString(associatedVariable.content + i, associatedVariable.location()));
            ++i;
        }
        return res;
    }

    abstract boolean containsAlike();

    static final boolean containsAlike(List monotypes) {
        Iterator i = monotypes.iterator();
        while (i.hasNext()) {
            if (!((Monotype)i.next()).containsAlike()) continue;
            return true;
        }
        return false;
    }

    static final boolean containsAlike(Monotype[] monotypes) {
        int i = monotypes.length;
        while (--i >= 0) {
            if (!monotypes[i].containsAlike()) continue;
            return true;
        }
        return false;
    }

    public boolean isVoid() {
        return false;
    }

    final String nullnessString() {
        switch (this.nullness) {
            case 1: {
                return "?";
            }
            case 2: {
                return "!";
            }
        }
        return "";
    }

    public final mlsub.typing.Monotype resolve(TypeMap tm) {
        mlsub.typing.Monotype raw = this.rawResolve(tm);
        switch (this.nullness) {
            case 0: {
                return raw;
            }
            case 1: {
                return Monotype.maybe(raw);
            }
            case 2: {
                return Monotype.sure(raw);
            }
            case 3: {
                if (raw instanceof MonotypeVar) {
                    Types.makeMarkedType((MonotypeVar)raw);
                    return raw;
                }
                return Monotype.sure(raw);
            }
        }
        throw Internal.error("Bad nullness tag");
    }

    abstract mlsub.typing.Monotype rawResolve(TypeMap var1);

    static final mlsub.typing.Monotype[] rawResolve(TypeMap s, Collection c) {
        if (c.size() == 0) {
            return null;
        }
        mlsub.typing.Monotype[] res = new mlsub.typing.Monotype[c.size()];
        int n = 0;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Monotype old;
            mlsub.typing.Monotype nou;
            Object o = i.next();
            if (!(o instanceof Monotype)) {
                Debug.println(o + " ::: " + o.getClass());
            }
            if ((nou = (old = (Monotype)o).resolve(s)) == null) {
                User.error((Located)old, old + " : Monotype not defined");
            }
            res[n++] = nou;
        }
        return res;
    }

    static final mlsub.typing.Monotype[] resolve(TypeMap s, Monotype[] c) {
        if (c == null || c.length == 0) {
            return null;
        }
        mlsub.typing.Monotype[] res = new mlsub.typing.Monotype[c.length];
        int n = c.length;
        while (--n >= 0) {
            Monotype old = c[n];
            mlsub.typing.Monotype nou = old.resolve(s);
            if (nou == null) {
                User.error((Located)old, old + " : Monotype not defined");
            }
            res[n] = nou;
        }
        return res;
    }

    abstract Monotype substitute(Map var1);

    static List substitute(Map map2, Collection c) {
        if (c == null) {
            return null;
        }
        ArrayList<Monotype> res = new ArrayList<Monotype>(c.size());
        Iterator i = c.iterator();
        while (i.hasNext()) {
            res.add(((Monotype)i.next()).substitute(map2));
        }
        return res;
    }

    static Monotype[] substitute(Map map2, Monotype[] m) {
        Monotype[] res = new Monotype[m.length];
        int i = m.length;
        while (--i >= 0) {
            res[i] = m[i].substitute(map2);
        }
        return res;
    }

    public String toStringExtern() {
        return this.toString();
    }

    public String toStringBase() {
        return this.toString();
    }

    static Monotype create(mlsub.typing.Monotype m) {
        return new Wrapper(m);
    }

    public static Monotype createVar(MonotypeVar m) {
        return new VarWrapper(m);
    }

    public static mlsub.typing.Monotype maybe(mlsub.typing.Monotype type) {
        return new MonotypeConstructor(PrimitiveType.maybeTC, new mlsub.typing.Monotype[]{type});
    }

    public static mlsub.typing.Monotype sure(mlsub.typing.Monotype type) {
        return new MonotypeConstructor(PrimitiveType.sureTC, new mlsub.typing.Monotype[]{type});
    }

    public abstract Location location();

    private static final class VarWrapper
    extends Wrapper {
        VarWrapper(MonotypeVar m) {
            super(m);
        }

        public mlsub.typing.Monotype rawResolve(TypeMap s) {
            TypeSymbol res = s.lookup(this.type.toString());
            if (res != null) {
                return (mlsub.typing.Monotype)((Object)res);
            }
            return this.type;
        }
    }

    private static class Wrapper
    extends Monotype {
        final mlsub.typing.Monotype type;

        Wrapper(mlsub.typing.Monotype m) {
            this.type = m;
        }

        boolean containsAlike() {
            return false;
        }

        public mlsub.typing.Monotype rawResolve(TypeMap s) {
            return this.type;
        }

        Monotype substitute(Map m) {
            return this;
        }

        public Location location() {
            return Location.nowhere();
        }

        public String toString() {
            return String.valueOf(this.type);
        }
    }
}

