/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.ClassDefinition;
import bossa.syntax.ConstantExp;
import bossa.syntax.Constructor;
import bossa.syntax.Expression;
import bossa.syntax.FormalParameters;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.MonoSymbol;
import bossa.syntax.Monotype;
import bossa.syntax.NiceFieldAccess;
import bossa.syntax.Node;
import bossa.syntax.Statement;
import bossa.syntax.SymbolExp;
import bossa.syntax.TypeConstructors;
import bossa.syntax.TypeScope;
import bossa.syntax.VarScope;
import bossa.syntax.dispatch;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.User;
import bossa.util.Util;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.ClassExp;
import gnu.expr.Declaration;
import gnu.expr.LambdaExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import java.io.PrintWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mlsub.typing.AtomicConstraint;
import mlsub.typing.Constraint;
import mlsub.typing.Interface;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.Polytype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeSymbol;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import nice.tools.code.Gen;
import nice.tools.code.GetFieldProc;
import nice.tools.code.Inline;
import nice.tools.code.SetFieldProc;
import nice.tools.code.SpecialTypes;
import nice.tools.code.Types;

public class NiceClass
extends ClassDefinition.ClassImplementation {
    ClassDefinition definition;
    private static NewField[] noFields = new NewField[0];
    private static OverridenField[] noOverrides = new OverridenField[0];
    private ArrayList constructors = new ArrayList(10);
    private TypeScope localScope;
    private Statement[] initializers = Statement.noStatements;
    private MonoSymbol thisSymbol;
    private gnu.expr.Expression thisExp;
    private boolean entered = false;
    static Method cloneMethod = Type.pointer_type.getDeclaredMethod("clone", 0);
    ClassExp classe;
    private Constructor[] constructorMethod;
    private NewField[] fields;
    private OverridenField[] overrides;
    private Long serialVersionUIDValue;

    public NiceClass(ClassDefinition definition) {
        this.definition = definition;
        this.prepareCodeGeneration();
    }

    public String getName() {
        return this.definition.getName().toString();
    }

    public void setFields(List fields) {
        if (fields == null || fields.size() == 0) {
            this.fields = noFields;
        } else {
            Iterator it = fields.iterator();
            while (it.hasNext()) {
                Field field = (Field)it.next();
                if (!field.isFinal() || !field.sym.getName().toString().equals("serialVersionUID")) continue;
                it.remove();
                if (field.value instanceof ConstantExp && ((ConstantExp)field.value).value instanceof Long) {
                    this.serialVersionUIDValue = (Long)((ConstantExp)field.value).value;
                    continue;
                }
                User.error((Located)field.sym, "the value of an serialVersionUID should a constant of type long");
            }
            this.fields = fields.toArray(new NewField[fields.size()]);
        }
    }

    public void setOverrides(List overrides) {
        this.overrides = overrides == null || overrides.size() == 0 ? noOverrides : overrides.toArray(new OverridenField[overrides.size()]);
    }

    static NiceClass get(TypeConstructor tc) {
        ClassDefinition res = ClassDefinition.get(tc);
        if (res != null && res.implementation instanceof NiceClass) {
            return (NiceClass)res.implementation;
        }
        return null;
    }

    NiceClass getParent() {
        return NiceClass.get(this.definition.getSuperClass());
    }

    void addConstructorCallSymbol(MethodDeclaration.Symbol sym) {
        this.constructors.add(sym);
    }

    List getConstructorCallSymbols() {
        return (List)this.constructors.clone();
    }

    public Field makeField(MonoSymbol sym, Expression value, boolean isFinal, boolean isTransient, boolean isVolatile, String docString) {
        if (this.definition instanceof ClassDefinition.Interface) {
            User.error((Located)sym, "An interface cannot have a field.");
        }
        return new NewField(sym, value, isFinal, isTransient, isVolatile, docString);
    }

    public Field makeOverride(MonoSymbol sym, Expression value) {
        if (this.definition instanceof ClassDefinition.Interface) {
            User.error((Located)sym, "An interface cannot have a field.");
        }
        return new OverridenField(sym, value);
    }

    void resolveClass() {
        this.classe.supers = this.computeSupers();
        this.localScope = this.definition.getLocalScope();
        this.definition.setJavaType(this.classe.getType());
        this.resolveFields();
        this.resolveIntitializers();
        this.createDefaultConstructors();
        this.addPublicCloneMethod();
    }

    private void resolveFields() {
        int i = 0;
        while (i < this.fields.length) {
            this.fields[i].resolve(this.definition.scope, this.localScope);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.overrides.length) {
            this.overrides[i2].resolve(this.definition.scope, this.localScope);
            ++i2;
        }
    }

    private void createFields() {
        int i = 0;
        while (i < this.fields.length) {
            this.fields[i].createField();
            ++i;
        }
    }

    private Declaration getOverridenField(OverridenField field, boolean checkValue) {
        String name = field.sym.getName().toString();
        int i = 0;
        while (i < this.fields.length) {
            if (this.fields[i].sym.getName().toString().equals(name)) {
                if (!this.fields[i].isFinal) {
                    User.error((Located)field.sym, "The original field in class " + this + " is not final, so its type cannot be overriden");
                }
                checkValue = field.checkOverride(this.fields[i], checkValue);
                return this.fields[i].method.fieldDecl;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < this.overrides.length) {
            if (this.overrides[i2].sym.getName().toString().equals(name)) {
                checkValue = field.checkOverride(this.overrides[i2], checkValue);
            }
            ++i2;
        }
        NiceClass parent = this.getParent();
        if (parent != null) {
            return parent.getOverridenField(field, checkValue);
        }
        return null;
    }

    public void setInitializers(List inits) {
        this.initializers = inits.toArray(new Statement[inits.size()]);
    }

    public int nbInitializers() {
        return this.initializers.length;
    }

    private void resolveIntitializers() {
        if (this.initializers.length == 0) {
            return;
        }
        VarScope scope = this.definition.scope;
        mlsub.typing.Monotype thisType = Monotype.sure(new MonotypeConstructor(this.definition.tc, this.definition.getTypeParameters()));
        this.thisSymbol = new MonoSymbol(FormalParameters.thisName, thisType){

            gnu.expr.Expression compile() {
                return NiceClass.this.thisExp;
            }
        };
        Node.thisExp = new SymbolExp(this.thisSymbol, this.definition.location());
        scope.addSymbol(this.thisSymbol);
        int i = 0;
        while (i < this.initializers.length) {
            this.initializers[i] = dispatch.analyse(this.initializers[i], this.definition.scope, this.localScope, false);
            ++i;
        }
        Node.thisExp = null;
        scope.removeSymbol(this.thisSymbol);
    }

    void setThisExp(gnu.expr.Expression thisExp) {
        this.thisExp = thisExp;
    }

    gnu.expr.Expression compileInitializer(int index) {
        return this.initializers[index].generateCode();
    }

    void typecheck() {
        block10: {
            try {
                int i = 0;
                while (i < this.fields.length) {
                    this.fields[i].typecheck();
                    ++i;
                }
                int i2 = 0;
                while (i2 < this.overrides.length) {
                    this.overrides[i2].typecheck();
                    ++i2;
                }
                if (this.initializers.length != 0) {
                    this.enterTypingContext();
                    Node.thisExp = new SymbolExp(this.thisSymbol, this.definition.location());
                    int i3 = 0;
                    while (i3 < this.initializers.length) {
                        dispatch.typecheck(this.initializers[i3]);
                        ++i3;
                    }
                }
                Object var5_4 = null;
                if (!this.entered) break block10;
                this.entered = false;
                Node.thisExp = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this.entered) {
                    this.entered = false;
                    Node.thisExp = null;
                    try {
                        Typing.leave();
                    }
                    catch (TypingEx ex) {
                        User.error((Located)this.definition, "Type error in field declarations");
                    }
                }
                throw throwable;
            }
            try {
                Typing.leave();
            }
            catch (TypingEx ex) {
                User.error((Located)this.definition, "Type error in field declarations");
            }
        }
    }

    private void enterTypingContext() {
        if (this.entered || this.definition.classConstraint == null) {
            return;
        }
        Typing.enter();
        this.entered = true;
        Typing.introduce(this.definition.classConstraint.typeParameters);
        try {
            Typing.implies();
        }
        catch (TypingEx ex) {
            Internal.error(ex);
        }
    }

    public void printInterface(PrintWriter s) {
        s.print(" {\n" + Util.map("", ";\n", ";\n", this.fields) + this.serialUIDFieldString() + Util.map("", ";\n", ";\n", this.overrides) + "}\n\n");
    }

    String serialUIDFieldString() {
        if (this.serialVersionUIDValue == null) {
            return "";
        }
        return "final long serialVersionUID = " + this.serialVersionUIDValue + "L;\n";
    }

    private void prepareCodeGeneration() {
        this.classe = this.definition.module.getClassExp(this);
    }

    private void addPublicCloneMethod() {
        if (!this.definition.implementsJavaInterface("java.lang.Cloneable")) {
            return;
        }
        gnu.expr.Expression[] params = new gnu.expr.Expression[1];
        LambdaExp lambda = this.createJavaMethod("clone", cloneMethod, params);
        Gen.setMethodBody(lambda, new ApplyExp(new QuoteExp(PrimProcedure.specialCall(cloneMethod)), params));
        this.addJavaMethod(lambda);
    }

    public ClassExp createClassExp() {
        ClassExp res = new ClassExp();
        res.setName(this.definition.name.toString());
        this.definition.location().write(res);
        res.setSimple(true);
        res.setAccessFlags(this.definition.getBytecodeFlags());
        this.definition.module.addUserClass(res);
        return res;
    }

    public ClassExp getClassExp() {
        return this.classe;
    }

    private TypeScope translationScope(NiceClass other) {
        TypeSymbol[] binders = other.definition.getBinders();
        TypeSymbol[] ourBinders = this.definition.getBinders();
        TypeScope scope = Node.getGlobalTypeScope();
        if (binders != null) {
            scope = new TypeScope(scope);
            int i = 0;
            while (i < binders.length) {
                try {
                    scope.addMapping(ourBinders[i].toString(), binders[i]);
                }
                catch (TypeScope.DuplicateName e) {
                    // empty catch block
                }
                ++i;
            }
        }
        return scope;
    }

    private static List getNativeConstructorParameters(TypeConstructor tc, List constraints, TypeSymbol[] binders) {
        LinkedList constructors = TypeConstructors.getConstructors(tc);
        if (constructors == null) {
            ArrayList res = new ArrayList(10);
            ArrayList<Object> params = new ArrayList<Object>(10);
            params.add(null);
            res.add(params);
            return res;
        }
        ArrayList res = new ArrayList(constructors.size());
        int n = 0;
        Iterator i = constructors.iterator();
        while (i.hasNext()) {
            MethodDeclaration.Symbol m = (MethodDeclaration.Symbol)i.next();
            ArrayList<Node> params = new ArrayList<Node>(10);
            params.add(m.getMethodDeclaration());
            res.add(params);
            mlsub.typing.Monotype[] args = m.getMethodDeclaration().getArgTypes();
            int j = 0;
            while (j < args.length) {
                params.add(new FormalParameters.Parameter(Monotype.create(args[j])));
                ++j;
            }
            ++n;
        }
        return res;
    }

    private List getParentConstructorParameters(List constraints, TypeSymbol[] binders) {
        AtomicConstraint[] newAtoms;
        TypeScope scope = Node.getGlobalTypeScope();
        HashMap<TypeSymbol, TypeSymbol> map2 = null;
        if (binders != null) {
            scope = new TypeScope(scope);
            map2 = new HashMap<TypeSymbol, TypeSymbol>();
            TypeSymbol[] ourBinders = this.definition.getBinders();
            int i = 0;
            while (i < binders.length) {
                try {
                    scope.addMapping(ourBinders[i].toString(), binders[i]);
                    map2.put(ourBinders[i], binders[i]);
                }
                catch (TypeScope.DuplicateName e) {
                    // empty catch block
                }
                ++i;
            }
        }
        ArrayList res = new ArrayList(this.constructors.size());
        Iterator i = ((AbstractList)this.constructors).iterator();
        while (i.hasNext()) {
            MethodDeclaration decl = ((MethodDeclaration.Symbol)i.next()).getMethodDeclaration();
            ArrayList<MethodDeclaration> params = new ArrayList<MethodDeclaration>(1 + decl.arity);
            params.add(decl);
            if (decl.arity > 0) {
                params.addAll(decl.formalParameters().getParameters(scope));
            }
            res.add(params);
        }
        if (this.definition.classConstraint != null && (newAtoms = AtomicConstraint.substitute(map2, this.definition.resolvedConstraints)) != null) {
            int i2 = 0;
            while (i2 < newAtoms.length) {
                constraints.add(newAtoms[i2]);
                ++i2;
            }
        }
        return res;
    }

    private List getConstructorParameters(List constraints, TypeSymbol[] binders) {
        TypeConstructor supTC = this.definition.getSuperClass();
        NiceClass sup = NiceClass.get(supTC);
        List res = sup == null ? NiceClass.getNativeConstructorParameters(supTC, constraints, binders) : sup.getParentConstructorParameters(constraints, binders);
        if (this.overrides.length > 0) {
            Iterator i = res.iterator();
            while (i.hasNext()) {
                this.updateConstructorParameters((List)i.next());
            }
        }
        if (this.fields.length > 0) {
            int j = 0;
            while (j < res.size()) {
                List params = (List)res.get(j);
                int i = 0;
                while (i < this.fields.length) {
                    params.add(this.fields[i].asParameter());
                    ++i;
                }
                ++j;
            }
        }
        if (this.definition.resolvedConstraints != null) {
            constraints.addAll(Arrays.asList(this.definition.resolvedConstraints));
        }
        return res;
    }

    private void updateConstructorParameters(List inherited) {
        int f = 0;
        while (f < this.overrides.length) {
            this.overrides[f].updateConstructorParameter(inherited);
            ++f;
        }
    }

    private void checkFields(FormalParameters.Parameter[] allFields) {
        int f = 0;
        while (f < this.fields.length) {
            this.fields[f].checkNoDuplicate(allFields, f);
            ++f;
        }
        int i = 0;
        while (i < this.overrides.length) {
            int k = i + 1;
            while (k < this.overrides.length) {
                if (this.overrides[i].sym.hasName(this.overrides[k].sym.getName())) {
                    User.error((Located)this.overrides[k].sym, "A field override of the same field exists in this class");
                }
                ++k;
            }
            ++i;
        }
    }

    private void createDefaultConstructors() {
        if (this.definition.inInterfaceFile()) {
            return;
        }
        if (this.definition instanceof ClassDefinition.Interface) {
            return;
        }
        TypeSymbol[] binders = this.definition.getBinders();
        LinkedList constraints = binders == null ? null : new LinkedList();
        List allConstructorParams = this.getConstructorParameters(constraints, binders);
        Constraint cst = binders != null ? new Constraint(binders, constraints.toArray(new AtomicConstraint[constraints.size()])) : Constraint.True;
        this.constructorMethod = new Constructor[allConstructorParams.size()];
        int i = 0;
        while (i < allConstructorParams.size()) {
            List argList = (List)allConstructorParams.get(i);
            MethodDeclaration parent = (MethodDeclaration)argList.get(0);
            argList = argList.subList(1, argList.size());
            FormalParameters.Parameter[] args = argList.toArray(new FormalParameters.Parameter[argList.size()]);
            if (i == 0) {
                this.checkFields(args);
            }
            FormalParameters values = new FormalParameters(args);
            this.constructorMethod[i] = new Constructor(this, this.fields, parent, this.definition.location(), values, cst, Monotype.resolve(this.definition.getLocalScope(), values.types()), Monotype.sure(new MonotypeConstructor(this.definition.tc, this.definition.getTypeParameters())));
            TypeConstructors.addConstructor(this.definition.tc, this.constructorMethod[i]);
            ++i;
        }
    }

    public void precompile() {
        this.createFields();
    }

    public void compile() {
        this.recompile();
        this.createSerialUIDField();
    }

    public void recompile() {
        if (this.constructorMethod != null) {
            int i = 0;
            while (i < this.constructorMethod.length) {
                this.constructorMethod[i].getCode();
                ++i;
            }
        }
    }

    private gnu.expr.Expression typeExpression(TypeConstructor tc) {
        ClassDefinition c = ClassDefinition.get(tc);
        if (c != null && c.implementation instanceof NiceClass) {
            return ((NiceClass)c.implementation).classe;
        }
        return new QuoteExp(Types.javaType(tc));
    }

    private gnu.expr.Expression[] computeSupers() {
        int len;
        TypeConstructor superClass = this.definition.getSuperClass();
        Interface[] interfaces = this.definition.getInterfaces();
        int n = len = superClass == null ? 0 : 1;
        if (interfaces != null) {
            len += interfaces.length;
        }
        if (this.definition.javaInterfaces != null) {
            len += this.definition.javaInterfaces.length;
        }
        if (len == 0) {
            return null;
        }
        gnu.expr.Expression[] res = new gnu.expr.Expression[len];
        if (interfaces != null) {
            int i = 0;
            while (i < interfaces.length) {
                TypeConstructor assocTC = interfaces[i].associatedTC();
                if (assocTC != null) {
                    res[--len] = this.typeExpression(assocTC);
                }
                ++i;
            }
        }
        if (this.definition.javaInterfaces != null) {
            int i = 0;
            while (i < this.definition.javaInterfaces.length) {
                res[--len] = this.typeExpression(this.definition.javaInterfaces[i]);
                ++i;
            }
        }
        if (superClass != null) {
            res[--len] = this.typeExpression(superClass);
        }
        if (len != 0) {
            gnu.expr.Expression[] tmp = new gnu.expr.Expression[res.length - len];
            System.arraycopy(res, len, tmp, 0, tmp.length);
            res = tmp;
        }
        return res;
    }

    public gnu.expr.Expression addJavaMethod(LambdaExp method) {
        return this.classe.addMethod(method);
    }

    public LambdaExp createJavaMethod(String name, Method likeMethod, gnu.expr.Expression[] params) {
        LambdaExp lambda = Gen.createMemberMethod(name, this.getClassExp().getType(), likeMethod.getParameterTypes(), likeMethod.getReturnType(), params);
        return lambda;
    }

    gnu.expr.Expression callSuperMethod(Method superMethod) {
        gnu.expr.Expression[] params = new gnu.expr.Expression[superMethod.getParameterTypes().length + 1];
        LambdaExp lambda = this.createJavaMethod("$super$" + superMethod.getName(), superMethod, params);
        Gen.setMethodBody(lambda, new ApplyExp(new QuoteExp(PrimProcedure.specialCall(superMethod)), params));
        return this.addJavaMethod(lambda);
    }

    void createSerialUIDField() {
        if (this.serialVersionUIDValue == null) {
            return;
        }
        Declaration fieldDecl = this.classe.addDeclaration("serialVersionUID", SpecialTypes.longType);
        fieldDecl.setSimple(false);
        fieldDecl.setCanRead(true);
        fieldDecl.setFlag(16384);
        fieldDecl.setSpecifiedPrivate(true);
        fieldDecl.setFlag(2048);
        fieldDecl.setFlag(8192);
        fieldDecl.noteValue(new QuoteExp(this.serialVersionUIDValue, SpecialTypes.longType));
    }

    public String toString() {
        return this.definition.toString();
    }

    final class OverridenField
    extends Field {
        private OverridenField(MonoSymbol sym, Expression value) {
            super(sym, value);
        }

        boolean isFinal() {
            return true;
        }

        void updateConstructorParameter(List inherited) {
            String name = this.sym.getName().toString();
            Monotype type = this.sym.syntacticType;
            int i = 1;
            while (i < inherited.size()) {
                FormalParameters.Parameter param = (FormalParameters.Parameter)inherited.get(i);
                if (param.match(name)) {
                    if (this.value != null) {
                        inherited.set(i, new FormalParameters.OptionalParameter(type, this.sym.getName(), true, this.value, param.value() == null || param.isOverriden()));
                    } else {
                        param.resetType(type);
                    }
                }
                ++i;
            }
        }

        void typecheck() {
            Declaration decl = null;
            NiceClass parent = NiceClass.this.getParent();
            if (parent != null) {
                decl = parent.getOverridenField(this, this.value == null);
            }
            if (decl == null) {
                throw User.error((Located)this.sym, "No field with this name exists in a super-class");
            }
            this.method.fieldDecl = decl;
            super.typecheck();
        }

        boolean checkOverride(Field original, boolean checkValue) {
            NiceClass.this.enterTypingContext();
            mlsub.typing.Monotype originalType = original.sym.syntacticType.resolve(original.getDeclaringClass().translationScope(NiceClass.this));
            try {
                Typing.leq(this.sym.type, originalType);
            }
            catch (TypingEx ex) {
                User.error((Located)this.sym, "The new type must be a subtype of the original type declared in " + original.getDeclaringClass() + ".\n" + "Original type: " + originalType);
            }
            if (checkValue && original.value != null) {
                try {
                    Typing.leq(original.value.getType(), this.sym.getType());
                }
                catch (TypingEx ex) {
                    User.error((Located)this.sym, "The default value declared in " + original.getDeclaringClass() + "\nis not compatible with the overriden type");
                }
                return false;
            }
            return checkValue;
        }

        public String toString() {
            return "override " + super.toString();
        }
    }

    final class NewField
    extends Field {
        boolean isFinal;
        boolean isTransient;
        boolean isVolatile;
        public String docString;

        private NewField(MonoSymbol sym, Expression value, boolean isFinal, boolean isTransient, boolean isVolatile, String docString) {
            super(sym, value);
            this.isFinal = isFinal;
            this.isTransient = isTransient;
            this.isVolatile = isVolatile;
            this.docString = docString;
            if (isFinal && isVolatile) {
                throw User.error((Located)sym, "A field cannot be final and volatile");
            }
        }

        boolean isFinal() {
            return this.isFinal;
        }

        void createField() {
            this.method.fieldDecl = NiceClass.this.classe.addField(this.sym.name.toString(), Types.javaType(this.sym.type));
            this.method.fieldDecl.setFlag(this.isTransient, 524288);
            this.method.fieldDecl.setFlag(this.isVolatile, 0x100000);
            if (!NiceClass.this.definition.inInterfaceFile()) {
                String fname = this.sym.getName().toString();
                String suffix = Character.toUpperCase(fname.charAt(0)) + fname.substring(1);
                this.createGetter(suffix);
                if (!this.isFinal) {
                    this.createSetter(suffix);
                }
            }
        }

        void createGetter(String nameSuffix) {
            gnu.expr.Expression[] params = new gnu.expr.Expression[1];
            LambdaExp getter = Gen.createMemberMethod("get" + nameSuffix, NiceClass.this.classe.getType(), null, this.method.fieldDecl.getType(), params);
            Gen.setMethodBody(getter, Inline.inline(new GetFieldProc(this.method.fieldDecl), params[0]));
            NiceClass.this.classe.addMethod(getter);
        }

        void createSetter(String nameSuffix) {
            gnu.expr.Expression[] params = new gnu.expr.Expression[2];
            Type[] argTypes = new Type[]{this.method.fieldDecl.getType()};
            LambdaExp setter = Gen.createMemberMethod("set" + nameSuffix, NiceClass.this.classe.getType(), argTypes, this.method.fieldDecl.getType(), params);
            Gen.setMethodBody(setter, Inline.inline(new SetFieldProc(this.method.fieldDecl), params[0], params[1]));
            NiceClass.this.classe.addMethod(setter);
        }

        void checkNoDuplicate(FormalParameters.Parameter[] fields, int rankInThisClass) {
            int max = fields.length - NiceClass.this.fields.length + rankInThisClass;
            String name = this.sym.getName().toString();
            int i = 0;
            while (i < max) {
                if (fields[i].match(name)) {
                    User.error((Located)this.sym, max - i >= NiceClass.this.fields.length ? "A field with the same name exists in a super-class" : "A field with the same name exists in this class");
                }
                ++i;
            }
        }

        public String toString() {
            return (this.isFinal ? "final " : "") + super.toString();
        }
    }

    abstract class Field {
        MonoSymbol sym;
        Expression value;
        NiceFieldAccess method;

        private Field(MonoSymbol sym, Expression value) {
            this.sym = sym;
            this.value = value;
            sym.propagate = 4;
            this.method = new NiceFieldAccess(NiceClass.this, this);
            NiceClass.this.definition.addChild(this.method);
        }

        NiceClass getDeclaringClass() {
            return NiceClass.this;
        }

        abstract boolean isFinal();

        void resolve(VarScope scope, TypeScope typeScope) {
            this.sym.type = this.sym.syntacticType.resolve(typeScope);
            if (Types.isVoid(this.sym.type)) {
                User.error((Located)this.sym, "A field cannot have void type");
            }
            this.value = dispatch.analyse(this.value, scope, typeScope);
        }

        FormalParameters.Parameter asParameter() {
            Monotype type = this.sym.syntacticType;
            if (this.value == null) {
                return new FormalParameters.NamedParameter(type, this.sym.getName(), true);
            }
            return new FormalParameters.OptionalParameter(type, this.sym.getName(), true, this.value);
        }

        void typecheck() {
            if (this.value != null) {
                NiceClass.this.enterTypingContext();
                Polytype declaredType = this.sym.getType();
                this.value = this.value.resolveOverloading(declaredType);
                dispatch.typecheck(this.value);
                try {
                    Typing.leq(this.value.getType(), declaredType);
                }
                catch (TypingEx ex) {
                    throw dispatch.assignmentError(this.value, this.sym.getName().toString(), this.sym.getType().toString(), this.value);
                }
            }
        }

        public String toString() {
            return this.sym + (this.value == null ? "" : " = " + this.value);
        }
    }
}

