/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.Arguments;
import bossa.syntax.CallExp;
import bossa.syntax.Expression;
import bossa.syntax.GlobalVarDeclaration;
import bossa.syntax.LocatedString;
import bossa.syntax.Node;
import bossa.syntax.SymbolExp;
import bossa.syntax.VarSymbol;
import bossa.util.Debug;
import bossa.util.Internal;
import bossa.util.Located;
import bossa.util.User;
import bossa.util.UserError;
import bossa.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import mlsub.typing.Domain;
import mlsub.typing.Monotype;
import mlsub.typing.Polytype;
import mlsub.typing.TupleType;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;
import nice.tools.code.Types;

public class OverloadedSymbolExp
extends Expression {
    List symbols;
    LocatedString ident;
    private boolean noImplicitThis;

    OverloadedSymbolExp(List symbols, LocatedString ident) {
        if (symbols == null) {
            Internal.error("No symbols");
        }
        this.symbols = symbols;
        this.ident = ident;
        this.setLocation(ident.location());
    }

    private OverloadedSymbolExp(List symbols, LocatedString ident, boolean noImplicitThis) {
        this(symbols, ident);
        this.noImplicitThis = noImplicitThis;
    }

    OverloadedSymbolExp(VarSymbol symbol, LocatedString ident) {
        this.symbols = new LinkedList();
        this.symbols.add(symbol);
        this.ident = ident;
        this.setLocation(ident.location());
    }

    public boolean isAssignable() {
        Internal.error("Overloading resolution should be done before this.");
        return false;
    }

    private Expression uniqueExpression() {
        return new SymbolExp((VarSymbol)this.symbols.get(0), this.location());
    }

    private Expression uniqueExpression(VarSymbol sym, Polytype t) {
        SymbolExp res = new SymbolExp(sym, this.location());
        res.type = t;
        return res;
    }

    Expression resolveOverloading(CallExp callExp) {
        Located res;
        Arguments arguments = callExp.arguments;
        arguments.computeTypes();
        if (Debug.overloading) {
            Debug.println("Overloading resolution for " + this + "\nwith parameters " + arguments);
        }
        LinkedList<VarSymbol> removed = new LinkedList<VarSymbol>();
        List fieldAccesses = this.filterFieldAccesses();
        Iterator i = this.symbols.iterator();
        while (i.hasNext()) {
            VarSymbol s = (VarSymbol)i.next();
            if (s.isIgnored()) {
                removed.add(s);
                i.remove();
                continue;
            }
            switch (s.match(arguments)) {
                case 0: {
                    removed.add(s);
                    i.remove();
                    break;
                }
                case 1: {
                    i.remove();
                    break;
                }
                case 2: {
                    break;
                }
                default: {
                    Internal.warning("Unknown O.R. case: " + s.getClass());
                    i.remove();
                }
            }
        }
        if (this.symbols.size() == 0) {
            Expression res2;
            if (!this.noImplicitThis && (res2 = this.givePriorityToFields(fieldAccesses)) != null) {
                return res2;
            }
            User.error((Located)this, this.noMatchError(removed, arguments));
        }
        removed.clear();
        Iterator i2 = this.symbols.iterator();
        while (i2.hasNext()) {
            VarSymbol s = (VarSymbol)i2.next();
            if (Debug.overloading) {
                Debug.println("Overloading: Trying with " + s);
            }
            Polytype[] argsType = Expression.getType(arguments.getExpressions(s));
            s.makeClonedType(argsType, arguments.getUsedArguments(s));
            Polytype t = CallExp.wellTyped(s.getClonedType(), argsType);
            if (t == null) {
                removed.add(s);
                i2.remove();
                s.releaseClonedType();
                continue;
            }
            arguments.types.put(s, t);
        }
        if (this.symbols.size() == 0) {
            if (!this.noImplicitThis && (res = this.givePriorityToFields(fieldAccesses)) != null) {
                return res;
            }
            if (removed.size() == 1) {
                User.error((Located)this, "Arguments " + arguments.printTypes() + " do not fit: \n" + removed.get(0));
            } else {
                User.error((Located)this, "No possible call for " + this.ident + ".\nArguments: " + arguments.printTypes() + "\nPossibilities:\n" + Util.map("", "\n", "", removed));
            }
        }
        OverloadedSymbolExp.removeNonMinimal(this.symbols, arguments);
        if (this.symbols.size() == 1) {
            res = (VarSymbol)this.symbols.get(0);
            callExp.argTypes = Types.domain(((VarSymbol)res).getClonedType());
            ((VarSymbol)res).releaseClonedType();
            callExp.type = (Polytype)arguments.types.get(res);
            callExp.arguments.computedExpressions = arguments.getExpressions((VarSymbol)res);
            return this.uniqueExpression();
        }
        this.releaseAllClonedTypes();
        throw new AmbiguityError();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Expression resolveOverloading(Polytype expectedType) {
        Expression expression;
        if (Debug.overloading) {
            Debug.println("Overloading resolution (expected type " + expectedType + ") for " + this);
        }
        LinkedList<VarSymbol> removed = new LinkedList<VarSymbol>();
        List fieldAccesses = this.filterFieldAccesses();
        Iterator i = this.symbols.iterator();
        while (true) {
            VarSymbol s;
            if (!i.hasNext()) {
                if (this.symbols.size() != 1) break;
                s = (VarSymbol)this.symbols.get(0);
                Polytype symType = s.getClonedType();
                s.releaseClonedType();
                return this.uniqueExpression(s, symType);
            }
            s = (VarSymbol)i.next();
            s.makeClonedType(null, null);
            try {
                Typing.leq(s.getClonedType(), expectedType);
                if (!Debug.overloading) continue;
                Debug.println(s + "(" + s.location() + ") of type " + s.getClonedType() + " matches");
            }
            catch (TypingEx e) {
                removed.add(s);
                i.remove();
                s.releaseClonedType();
                if (!Debug.overloading) continue;
                Debug.println("Not " + s + " of type\n" + s.getClonedType() + "\nbecause " + e);
            }
        }
        try {
            List nonMin;
            block12: {
                block11: {
                    Expression res = this.givePriorityToFields(fieldAccesses);
                    if (res != null) {
                        Expression expression2 = res;
                        Object var12_9 = null;
                        this.releaseAllClonedTypes();
                        return expression2;
                    }
                    if (Types.domain(expectedType) == null) break block11;
                    nonMin = OverloadedSymbolExp.removeNonMinimal(this.symbols);
                    if (this.symbols.size() == 1) break block12;
                    this.symbols.addAll(nonMin);
                }
                if (this.symbols.size() == 0) throw User.error((Located)this, this.noMatchError(removed, expectedType));
                throw new AmbiguityError();
            }
            VarSymbol s = (VarSymbol)this.symbols.get(0);
            Polytype symType = s.getClonedType();
            s.releaseClonedType();
            this.symbols = nonMin;
            expression = this.uniqueExpression(s, symType);
        }
        catch (Throwable throwable) {
            Object var12_11 = null;
            this.releaseAllClonedTypes();
            throw throwable;
        }
        Object var12_10 = null;
        this.releaseAllClonedTypes();
        return expression;
    }

    private void releaseAllClonedTypes() {
        Iterator i = this.symbols.iterator();
        while (i.hasNext()) {
            VarSymbol s = (VarSymbol)i.next();
            s.releaseClonedType();
        }
    }

    Expression noOverloading() {
        if (Debug.overloading) {
            Debug.println("(no)Overloading resolution for " + this);
        }
        if (this.symbols.size() == 1) {
            return this.uniqueExpression();
        }
        Expression res = this.givePriorityToFields(this.filterFieldAccesses());
        if (res != null) {
            return res;
        }
        LinkedList<VarSymbol> globalvars = new LinkedList<VarSymbol>();
        Iterator i = this.symbols.iterator();
        while (i.hasNext()) {
            VarSymbol sym = (VarSymbol)i.next();
            if (!(sym instanceof GlobalVarDeclaration.GlobalVarSymbol)) continue;
            globalvars.add(sym);
        }
        if (globalvars.size() > 0 && globalvars.size() < this.symbols.size()) {
            return new OverloadedSymbolExp(globalvars, this.ident).noOverloading();
        }
        if (this.symbols.size() != 0) {
            throw new AmbiguityError();
        }
        throw User.error((Located)this, "No variable or field in this class has name " + this.ident);
    }

    private Expression givePriorityToFields(List fieldAccesses) {
        if (fieldAccesses.size() != 0) {
            if (Node.thisExp != null) {
                try {
                    CallExp res = new CallExp(new OverloadedSymbolExp(fieldAccesses, this.ident, true), new Arguments(new Arguments.Argument[]{new Arguments.Argument(Node.thisExp)}));
                    res.resolveOverloading();
                    return res;
                }
                catch (UserError userError) {
                    // empty catch block
                }
            }
            this.symbols.removeAll(this.filterFieldAccesses());
            if (this.symbols.size() == 1) {
                return this.uniqueExpression();
            }
        }
        return null;
    }

    private List filterFieldAccesses() {
        LinkedList<VarSymbol> res = new LinkedList<VarSymbol>();
        Iterator i = this.symbols.iterator();
        while (i.hasNext()) {
            VarSymbol sym = (VarSymbol)i.next();
            if (!sym.isFieldAccess()) continue;
            res.add(sym);
        }
        return res;
    }

    static List removeNonMinimal(List symbols) {
        ArrayList<VarSymbol> removed = new ArrayList<VarSymbol>();
        if (symbols.size() < 2) {
            return removed;
        }
        int len = symbols.size();
        VarSymbol[] syms = symbols.toArray(new VarSymbol[len]);
        boolean[] remove = new boolean[len];
        int s1 = 0;
        while (s1 < len) {
            Domain d1 = OverloadedSymbolExp.domain(syms[s1].getType());
            int s2 = 0;
            while (s2 < len) {
                if (s1 != s2 && !remove[s2]) {
                    Domain d2 = OverloadedSymbolExp.domain(syms[s2].getType());
                    try {
                        Typing.leq(d2, d1);
                        try {
                            Typing.leq(d1, d2);
                        }
                        catch (TypingEx e) {
                            remove[s1] = true;
                            break;
                        }
                    }
                    catch (TypingEx e) {
                        // empty catch block
                    }
                }
                ++s2;
            }
            ++s1;
        }
        int i = 0;
        while (i < len) {
            if (remove[i]) {
                if (Debug.overloading) {
                    Debug.println("Removing " + syms[i] + " since it is not minimal");
                }
                removed.add(syms[i]);
                symbols.remove(syms[i]);
            }
            ++i;
        }
        return removed;
    }

    private static void removeNonMinimal(List symbols, Arguments arguments) {
        if (symbols.size() < 2) {
            return;
        }
        int len = symbols.size();
        VarSymbol[] syms = symbols.toArray(new VarSymbol[len]);
        boolean[] remove = new boolean[len];
        int s1 = 0;
        while (s1 < len) {
            Domain d1 = OverloadedSymbolExp.domain(syms[s1].getClonedType(), arguments.getUsedArguments(syms[s1]));
            int s2 = 0;
            while (s2 < len) {
                if (s1 != s2 && !remove[s2]) {
                    Domain d2 = OverloadedSymbolExp.domain(syms[s2].getClonedType(), arguments.getUsedArguments(syms[s2]));
                    try {
                        Typing.leq(d2, d1);
                        try {
                            Typing.leq(d1, d2);
                        }
                        catch (TypingEx e) {
                            remove[s1] = true;
                            break;
                        }
                    }
                    catch (TypingEx e) {
                        // empty catch block
                    }
                }
                ++s2;
            }
            ++s1;
        }
        int i = 0;
        while (i < len) {
            if (remove[i]) {
                if (Debug.overloading) {
                    Debug.println("Removing " + syms[i] + " since it is not minimal");
                }
                syms[i].releaseClonedType();
                symbols.remove(syms[i]);
            }
            ++i;
        }
    }

    private static Domain domain(Polytype t, int[] usedArguments) {
        Monotype[] dom;
        Monotype[] m = Types.domain(t.getMonotype());
        if (usedArguments == null) {
            dom = m;
        } else {
            int n = 0;
            int i = 0;
            while (i < usedArguments.length) {
                if (usedArguments[i] != 0) {
                    ++n;
                }
                ++i;
            }
            dom = new Monotype[n];
            int i2 = 0;
            while (i2 < usedArguments.length) {
                if (usedArguments[i2] != 0) {
                    dom[usedArguments[i2] - 1] = m[i2];
                }
                ++i2;
            }
        }
        return new Domain(t.getConstraint(), new TupleType(dom));
    }

    private static Domain domain(Polytype t) {
        Monotype[] m = Types.domain(t.getMonotype());
        return new Domain(t.getConstraint(), new TupleType(m));
    }

    void computeType() {
        Internal.error(this, this.ident + " has not been resolved yet.\n" + "Possibilities are :" + this);
    }

    public gnu.expr.Expression compile() {
        Internal.error("compile in " + this.getClass() + " " + this);
        return null;
    }

    public String toString() {
        if (this.symbols.size() <= 1) {
            return "[" + Util.map("", "\n|", "", this.symbols) + "]";
        }
        return "\n[" + Util.map("", "\n|", "", this.symbols) + "]";
    }

    private String noMatchError(List removed, Arguments arguments) {
        switch (removed.size()) {
            case 0: {
                return "No method has name " + this.ident;
            }
            case 1: {
                VarSymbol sym = (VarSymbol)removed.get(0);
                if (sym.isIgnored()) {
                    return sym.getName() + " cannot be used because it has been ignored.\n" + "See above for the reason why it has been ignored";
                }
                return sym.explainWhyMatchFails(arguments);
            }
        }
        return "No method with name " + this.ident + arguments.explainNoMatch(removed);
    }

    private String noMatchError(List removed, Polytype expectedType) {
        switch (removed.size()) {
            case 0: {
                return "No symbol has name " + this.ident;
            }
            case 1: {
                VarSymbol sym = (VarSymbol)removed.get(0);
                return this.ident + " has type " + sym.getType();
            }
        }
        return "No symbol with name " + this.ident + " has type " + expectedType + ":\n" + Util.map("", "\n", "", removed);
    }

    class AmbiguityError
    extends UserError {
        AmbiguityError() {
            super(OverloadedSymbolExp.this, "Ambiguity for symbol " + OverloadedSymbolExp.this.ident + ". Possibilities are :\n" + Util.map("", "\n", "", OverloadedSymbolExp.this.symbols));
        }
    }
}

