/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.syntax.ClassDefinition;
import bossa.syntax.Monotype;
import bossa.util.Located;
import bossa.util.User;
import gnu.bytecode.Type;
import java.io.PrintWriter;
import mlsub.typing.Constraint;
import mlsub.typing.MonotypeConstructor;
import mlsub.typing.NullnessKind;
import mlsub.typing.Polytype;
import mlsub.typing.TopMonotype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.lowlevel.Engine;
import nice.tools.code.SpecialArray;
import nice.tools.code.SpecialTypes;

public class PrimitiveType
extends ClassDefinition.ClassImplementation {
    public static TypeConstructor byteTC;
    public static TypeConstructor charTC;
    public static TypeConstructor intTC;
    public static TypeConstructor longTC;
    public static TypeConstructor boolTC;
    public static TypeConstructor shortTC;
    public static TypeConstructor doubleTC;
    public static TypeConstructor floatTC;
    public static TypeConstructor arrayTC;
    public static TypeConstructor voidTC;
    public static TypeConstructor trueBoolTC;
    public static TypeConstructor falseBoolTC;
    public static mlsub.typing.Monotype byteType;
    public static mlsub.typing.Monotype charType;
    public static mlsub.typing.Monotype intType;
    public static mlsub.typing.Monotype longType;
    public static mlsub.typing.Monotype boolType;
    public static mlsub.typing.Monotype shortType;
    public static mlsub.typing.Monotype doubleType;
    public static mlsub.typing.Monotype floatType;
    public static mlsub.typing.Monotype voidType;
    static Polytype voidPolytype;
    static Polytype boolPolytype;
    static Polytype bytePolytype;
    static Polytype shortPolytype;
    static Polytype intPolytype;
    static Polytype longPolytype;
    private static Polytype objectPolytype;
    public static TypeConstructor maybeTC;
    public static TypeConstructor sureTC;
    public static TypeConstructor nullTC;
    public static Monotype synVoidType;
    static TypeConstructor typeTC;
    static TypeConstructor collectionTC;
    static TypeConstructor throwableTC;
    private static Polytype throwableType;

    public PrimitiveType(ClassDefinition definition) {
        Type t = PrimitiveType.registerPrimType(definition.name.toString(), definition.tc);
        if (t == null) {
            User.error((Located)definition, definition.name + " is not a known primitive type");
        }
        definition.setJavaType(t);
    }

    void resolveClass() {
    }

    public void printInterface(PrintWriter s) {
        s.print(" = native ;\n");
    }

    static Type registerPrimType(String name, TypeConstructor tc) {
        if (name.equals("nice.lang.char")) {
            charTC = tc;
            charType = Monotype.sure(new MonotypeConstructor(tc, null));
            return SpecialTypes.charType;
        }
        if (name.equals("nice.lang.byte")) {
            byteTC = tc;
            byteType = Monotype.sure(new MonotypeConstructor(tc, null));
            bytePolytype = new Polytype(byteType);
            return SpecialTypes.byteType;
        }
        if (name.equals("nice.lang.short")) {
            shortTC = tc;
            shortType = Monotype.sure(new MonotypeConstructor(tc, null));
            shortPolytype = new Polytype(shortType);
            return SpecialTypes.shortType;
        }
        if (name.equals("nice.lang.int")) {
            intTC = tc;
            intType = Monotype.sure(new MonotypeConstructor(tc, null));
            intPolytype = new Polytype(intType);
            return SpecialTypes.intType;
        }
        if (name.equals("nice.lang.long")) {
            longTC = tc;
            longType = Monotype.sure(new MonotypeConstructor(tc, null));
            longPolytype = new Polytype(longType);
            return SpecialTypes.longType;
        }
        if (name.equals("nice.lang.boolean")) {
            boolTC = tc;
            trueBoolTC = new TypeConstructor("true");
            falseBoolTC = new TypeConstructor("false");
            boolType = Monotype.sure(new MonotypeConstructor(tc, null));
            boolPolytype = new Polytype(boolType);
            return SpecialTypes.booleanType;
        }
        if (name.equals("nice.lang.double")) {
            doubleTC = tc;
            doubleType = Monotype.sure(new MonotypeConstructor(tc, null));
            return SpecialTypes.doubleType;
        }
        if (name.equals("nice.lang.float")) {
            floatTC = tc;
            floatType = Monotype.sure(new MonotypeConstructor(tc, null));
            return SpecialTypes.floatType;
        }
        if (name.equals("nice.lang.void")) {
            voidTC = tc;
            Engine.setTop(tc);
            voidType = Monotype.sure(new MonotypeConstructor(tc, null));
            voidPolytype = new Polytype(Constraint.True, voidType);
            synVoidType = Monotype.create(voidType);
            return SpecialTypes.voidType;
        }
        if (name.equals("nice.lang.Array")) {
            arrayTC = tc;
            return SpecialArray.wrappedType();
        }
        if (name.equals("nice.lang.Maybe")) {
            maybeTC = tc;
            NullnessKind.setMaybe(tc);
            return Type.pointer_type;
        }
        if (name.equals("nice.lang.Sure")) {
            sureTC = tc;
            NullnessKind.setSure(tc);
            return Type.pointer_type;
        }
        if (name.equals("nice.lang.Null")) {
            nullTC = tc;
            return Type.pointer_type;
        }
        if (name.equals("nice.lang.Type")) {
            typeTC = tc;
            return Type.pointer_type;
        }
        return null;
    }

    static Polytype objectPolytype() {
        if (objectPolytype == null) {
            objectPolytype = new Polytype(Constraint.True, Monotype.sure(TopMonotype.instance));
        }
        return objectPolytype;
    }

    static TypeConstructor throwableTC() {
        return throwableTC;
    }

    static Polytype throwableType() {
        if (throwableType == null) {
            throwableType = new Polytype(Constraint.True, Monotype.sure(new MonotypeConstructor(PrimitiveType.throwableTC(), null)));
        }
        return throwableType;
    }
}

