/*
 * Decompiled with CFR 0.152.
 */
package bossa.syntax;

import bossa.link.Alternative;
import bossa.syntax.ClassDefinition;
import bossa.syntax.Expression;
import bossa.syntax.JavaMethod;
import bossa.syntax.MethodBodyDefinition;
import bossa.syntax.MethodDeclaration;
import bossa.syntax.Monotype;
import bossa.syntax.NiceClass;
import bossa.syntax.Pattern;
import bossa.syntax.TypeIdent;
import bossa.syntax.TypeScope;
import bossa.util.Located;
import bossa.util.User;
import bossa.util.Util;
import gnu.bytecode.ClassType;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import mlsub.typing.AtomicConstraint;
import mlsub.typing.Constraint;
import mlsub.typing.FunType;
import mlsub.typing.MonotypeLeqCst;
import mlsub.typing.Polytype;
import mlsub.typing.TopMonotype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeConstructorLeqMonotypeCst;
import nice.tools.code.Types;

public class SuperExp
extends Expression {
    MethodBodyDefinition currentMethod;
    Alternative superAlternative = null;
    Method superMethod = null;
    List types;
    List tc = null;

    public SuperExp(List types) {
        this.types = types;
    }

    void setCurrentMethod(MethodBodyDefinition m) {
        this.currentMethod = m;
        MethodDeclaration decl = this.currentMethod.getDeclaration();
        if (this.tc != null && this.tc.size() != decl.getArity()) {
            User.error((Located)this, "Number of types doesn't match the number of arguments");
        }
        this.superAlternative = this.getSuper(decl);
    }

    private Pattern[] minimumPatterns() {
        if (this.tc == null) {
            return null;
        }
        Pattern[] res = new Pattern[this.tc.size()];
        int i = 0;
        while (i < this.tc.size()) {
            res[i] = new Pattern((TypeConstructor)this.tc.get(i), false);
            ++i;
        }
        return res;
    }

    private Alternative getSuper(MethodDeclaration decl) {
        Alternative superAlt = null;
        Alternative current = this.currentMethod.getAlternative();
        Iterator alternatives = ((AbstractList)Alternative.sortedAlternatives(decl)).iterator();
        Pattern[] mPatterns = this.minimumPatterns();
        while (alternatives.hasNext()) {
            Alternative a = (Alternative)alternatives.next();
            if (a == current) continue;
            if (mPatterns != null) {
                boolean match = true;
                Pattern[] aPatterns = a.getPatterns();
                int i = 0;
                while (i < mPatterns.length) {
                    if (!aPatterns[i].leq(mPatterns[i])) {
                        match = false;
                        break;
                    }
                    ++i;
                }
                if (!match) continue;
            }
            if (!Alternative.leq(current, a)) continue;
            if (superAlt == null || Alternative.leq(a, superAlt)) {
                superAlt = a;
                continue;
            }
            if (Alternative.leq(superAlt, a)) continue;
            String message = "This call to super is ambiguous. Possible parents are:\n" + superAlt + "\nand\n" + a;
            throw User.error((Located)this, message);
        }
        if (superAlt != null) {
            return superAlt;
        }
        if (decl instanceof JavaMethod) {
            this.getSuper((JavaMethod)decl);
            return null;
        }
        throw User.error((Located)this, "There is no super implementation to call");
    }

    private void getSuper(JavaMethod decl) {
        Type firstArg = Types.get(this.currentMethod.firstArgument());
        if (!(firstArg instanceof ClassType)) {
            throw User.error((Located)this, "The first argument of this method is not a class");
        }
        this.superMethod = SuperExp.getImplementationAbove(decl, (ClassType)firstArg);
        if (this.superMethod != null) {
            return;
        }
        throw User.error((Located)this, "There is no super implementation to call");
    }

    public static Method getImplementationAbove(JavaMethod decl, ClassType firstArg) {
        Method thisMethod = decl.reflectMethod;
        ClassType superClass = firstArg.getSuperclass();
        if (superClass == null) {
            return null;
        }
        return superClass.getMethod(thisMethod.getName(), thisMethod.getParameterTypes(), true);
    }

    public void resolveTC(TypeScope scope) {
        if (this.types != null) {
            this.tc = new ArrayList();
            Iterator it = this.types.iterator();
            while (it.hasNext()) {
                this.tc.add(((TypeIdent)it.next()).resolveToTC(scope));
            }
        }
    }

    void computeType() {
        Constraint constraint;
        FunType monotype;
        Polytype type = this.currentMethod.getDeclaration().getType();
        if (!type.isMonomorphic()) {
            type = type.cloneType();
            monotype = (FunType)type.getMonotype();
            if (this.superAlternative != null) {
                constraint = SuperExp.addLeq(type.getConstraint(), this.superAlternative.getPatterns(), monotype.domain());
            } else {
                TypeConstructor superTC = null;
                try {
                    superTC = Types.typeConstructor(this.superMethod.getDeclaringClass());
                }
                catch (Types.NotIntroducedClassException ex) {
                    // empty catch block
                }
                constraint = superTC != null ? SuperExp.addLeq(type.getConstraint(), new Pattern[]{new Pattern(superTC, false)}, monotype.domain()) : SuperExp.addLeqFirstArg(type.getConstraint(), Monotype.sure(TopMonotype.instance), monotype.domain());
            }
        } else {
            monotype = (FunType)type.getMonotype();
            constraint = Constraint.True;
        }
        this.type = new Polytype(constraint, monotype.codomain());
    }

    private static Constraint addLeq(Constraint c, Pattern[] p, mlsub.typing.Monotype[] m) {
        ArrayList<AtomicConstraint> newAtoms;
        AtomicConstraint[] oldAtoms = c.atoms();
        if (oldAtoms == null) {
            newAtoms = new ArrayList<AtomicConstraint>(p.length);
        } else {
            newAtoms = new ArrayList(oldAtoms.length + p.length);
            newAtoms.addAll(Arrays.asList(oldAtoms));
        }
        int i = 0;
        while (i < p.length) {
            if (p[i].tc != null) {
                newAtoms.add(new TypeConstructorLeqMonotypeCst(p[i].tc, m[i]));
            }
            ++i;
        }
        AtomicConstraint[] atoms = newAtoms.toArray(new AtomicConstraint[newAtoms.size()]);
        return new Constraint(c.binders(), atoms);
    }

    private static Constraint addLeqFirstArg(Constraint c, mlsub.typing.Monotype first, mlsub.typing.Monotype[] m) {
        AtomicConstraint[] atoms;
        AtomicConstraint[] oldAtoms = c.atoms();
        if (oldAtoms == null) {
            atoms = new AtomicConstraint[1];
        } else {
            atoms = new AtomicConstraint[oldAtoms.length + 1];
            System.arraycopy(oldAtoms, 0, atoms, 1, oldAtoms.length);
        }
        atoms[0] = new MonotypeLeqCst(first, m[0]);
        return new Constraint(c.binders(), atoms);
    }

    protected gnu.expr.Expression compile() {
        gnu.expr.Expression code = this.superAlternative != null ? this.superAlternative.methodExp() : ((NiceClass)ClassDefinition.get((TypeConstructor)this.currentMethod.firstArgument()).implementation).callSuperMethod(this.superMethod);
        return new ApplyExp(code, this.currentMethod.compiledArguments());
    }

    public String toString() {
        return "super" + (this.types != null ? "" : Util.map("(", ", ", ")", this.types));
    }
}

