/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;

public class CodeFragment
extends Label {
    CodeFragment next;
    byte[] insns;
    int length;
    int handlerIndex = -1;
    boolean unreachable_save;
    short[] linenumbers;

    public CodeFragment(CodeAttr cattr) {
        super(cattr);
    }

    public void emit(CodeAttr cattr) {
        cattr.reserve(this.length);
        System.arraycopy(this.insns, 0, cattr.code, cattr.PC, this.length);
        this.define(cattr);
        if (this.handlerIndex >= 0) {
            cattr.exception_table[4 * this.handlerIndex + 2] = (short)cattr.PC;
        }
        if (this.linenumbers != null) {
            int i = 0;
            while (i < this.linenumbers.length) {
                cattr.lines.put(this.linenumbers[i + 1], this.linenumbers[i] + cattr.PC);
                i += 2;
            }
        }
        cattr.PC += this.length;
    }
}

