/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import nice.tools.code.TypeImport;

public class ObjectType
extends Type {
    static final int ADD_FIELDS_DONE = 1;
    static final int ADD_METHODS_DONE = 2;
    static final int EXISTING_CLASS = 4;
    int flags;

    protected ObjectType() {
        this.size = 4;
    }

    ObjectType(String name) {
        this.this_name = name;
        this.size = 4;
    }

    public final void setExisting(boolean existing) {
        this.flags = existing ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public String getInternalName() {
        return this.getName().replace('.', '/');
    }

    public Class getReflectClass() {
        if (this.reflectClass == null && (this.flags & 4) != 0) {
            this.reflectClass = TypeImport.lookupQualifiedJavaClass(this.getInternalName().replace('/', '.'));
        }
        if (this.reflectClass == null && (this.flags & 4) != 0) {
            throw new RuntimeException("no such class: " + this.getName());
        }
        return this.reflectClass;
    }

    public Type getImplementationType() {
        return this == Type.nullType ? Type.pointer_type : (this == Type.tostring_type ? Type.string_type : this);
    }

    public Type promote() {
        return this == Type.nullType ? Type.pointer_type : this;
    }

    public int compare(Type other) {
        return other == Type.nullType ? 0 : -1;
    }

    public boolean isAssignableTo(Type other) {
        return other instanceof ObjectType;
    }

    public Object coerceFromObject(Object obj) {
        if (obj != null) {
            Class<?> objClass;
            if (this == Type.tostring_type) {
                return obj.toString();
            }
            Class clas = this.getReflectClass();
            if (!clas.isAssignableFrom(objClass = obj.getClass())) {
                throw new ClassCastException("don't know how to coerce " + objClass.getName() + " to " + this.getName());
            }
        }
        return obj;
    }

    public void emitCoerceFromObject(CodeAttr code) {
        if (this == Type.tostring_type) {
            code.emitDup();
            code.emitIfNull();
            code.emitPop(1);
            code.emitPushNull();
            code.emitElse();
            code.emitInvokeVirtual(Type.toString_method);
            code.emitFi();
        } else if (this != Type.pointer_type) {
            code.emitCheckcast(this);
        }
    }
}

