/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import java.util.Stack;

public class TypeVariable
extends ObjectType {
    public Type bound;
    static TypeVariable[] none = new TypeVariable[0];
    static TypeVariable[] scope1;
    static TypeVariable[] scope2;

    TypeVariable(String name, Type bound) {
        super(name);
        this.bound = bound;
    }

    public String toString() {
        return "Type variable " + this.getName();
    }

    static TypeVariable[] parse(String signature, int[] pos) {
        pos[0] = pos[0] + 1;
        Stack<TypeVariable> vars = new Stack<TypeVariable>();
        do {
            int colon = signature.indexOf(58, pos[0]);
            String name = signature.substring(pos[0], colon);
            pos[0] = colon + 1;
            Type bound = Type.fullSignatureToType(signature, pos);
            vars.push(new TypeVariable(name, bound));
        } while (signature.charAt(pos[0]) != '>');
        pos[0] = pos[0] + 1;
        TypeVariable[] res = new TypeVariable[vars.size()];
        int i = vars.size();
        while (--i >= 0) {
            res[i] = (TypeVariable)vars.pop();
        }
        return res;
    }

    static TypeVariable lookup(String name) {
        TypeVariable res = TypeVariable.lookup(name, scope1);
        if (res != null) {
            return res;
        }
        return TypeVariable.lookup(name, scope2);
    }

    static TypeVariable lookup(String name, TypeVariable[] scope) {
        if (scope != null) {
            int i = 0;
            while (i < scope.length) {
                if (scope[i].this_name.equals(name)) {
                    return scope[i];
                }
                ++i;
            }
        }
        return null;
    }
}

