/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.Target;

public class ConstructorExp
extends LambdaExp {
    private Declaration thisDecl;
    private ClassType classType;
    private Expression superCall;
    private boolean primary;
    int dummyArgs = 0;

    public ConstructorExp(Declaration thisDecl) {
        this.thisDecl = thisDecl;
        this.classType = (ClassType)thisDecl.getType();
        thisDecl.context = this;
        this.primary = true;
    }

    public ConstructorExp(ClassType classType) {
        this.classType = classType;
        this.primary = false;
    }

    public void setSuperCall(Expression superCall) {
        this.superCall = superCall;
    }

    ClassType getClassType() {
        return this.classType;
    }

    public Method getMainMethod() {
        if (this.primMethods == null) {
            this.addMethodFor(this.classType, null, null);
        }
        return this.primMethods[0];
    }

    void addMethodFor(ClassType ctype, Compilation comp, ObjectType closureEnvType) {
        if (this.primMethods != null) {
            return;
        }
        this.closureEnv = this.declareThis(ctype);
        Type[] args = new Type[this.min_args];
        Declaration var = this.firstDecl();
        int itype = 0;
        while (var != null) {
            args[itype++] = var.getType().getImplementationType();
            var = var.nextDecl();
        }
        while (ctype.getDeclaredMethod("<init>", args) != null) {
            Type[] newArgs = new Type[args.length + 1];
            System.arraycopy(args, 0, newArgs, 0, args.length);
            newArgs[args.length] = Type.int_type;
            args = newArgs;
            ++this.dummyArgs;
            this.addDeclaration("dummy");
        }
        Method method = ctype.addMethod("<init>", args, Type.void_type, 1);
        this.primMethods = new Method[]{method};
        this.addAttributes(method);
    }

    void enterFunction(Compilation comp) {
        if (this.primary) {
            this.superCall.compile(comp, Target.Ignore);
            super.enterFunction(comp);
            if (this.thisDecl.field != null) {
                CodeAttr code = comp.getCode();
                this.thisDecl.loadOwningObject(comp);
                code.emitPushThis();
                code.emitPutField(this.thisDecl.field);
            }
        } else {
            super.enterFunction(comp);
        }
    }
}

