/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.BindingInitializer;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.Literal;
import gnu.expr.ModuleExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.mapping.Named;

public class Declaration {
    static int counter;
    protected int id = ++counter;
    String name;
    public ScopeExp context;
    protected Type type;
    Declaration next;
    Variable var;
    Declaration nextCapturedVar;
    public Declaration base;
    public Field field;
    protected Expression value = QuoteExp.undefined_exp;
    static final int INDIRECT_BINDING = 1;
    static final int CAN_READ = 2;
    static final int CAN_CALL = 4;
    static final int CAN_WRITE = 8;
    static final int IS_FLUID = 16;
    static final int PRIVATE = 32;
    static final int IS_SIMPLE = 64;
    static final int PROCEDURE = 128;
    static final int IS_ALIAS = 256;
    public static final int NOT_DEFINING = 512;
    public static final int EXPORT_SPECIFIED = 1024;
    public static final int STATIC_SPECIFIED = 2048;
    public static final int NONSTATIC_SPECIFIED = 4096;
    public static final int TYPE_SPECIFIED = 8192;
    public static final int IS_CONSTANT = 16384;
    public static final int IS_SYNTAX = 32768;
    public static final int IS_UNKNOWN = 65536;
    public static final int PRIVATE_SPECIFIED = 131072;
    public static final int IS_SINGLE_VALUE = 262144;
    public static final int TRANSIENT = 524288;
    public static final int VOLATILE = 0x100000;
    public static final int NOT_INITIALIZED = 0x200000;
    protected int flags = 64;
    public ApplyExp firstCall;
    Method makeBindingMethod = null;
    String filename;
    int position;

    public final Type getType() {
        return this.type;
    }

    public final void setType(Type type) {
        this.type = type;
        if (this.var != null) {
            this.var.setType(type);
        }
    }

    public final String getName() {
        return this.name;
    }

    public final Declaration nextDecl() {
        return this.next;
    }

    public Variable getVariable() {
        return this.var;
    }

    public final boolean isSimple() {
        return (this.flags & 0x40) != 0;
    }

    public final void setSimple(boolean b) {
        this.setFlag(b, 64);
        if (this.var != null) {
            this.var.setSimple(b);
        }
    }

    public final ScopeExp getContext() {
        return this.context;
    }

    public void loadOwningObject(Compilation comp) {
        if (this.base != null) {
            this.base.load(comp);
        } else {
            this.getContext().currentLambda().loadHeapFrame(comp);
        }
    }

    public void load(Compilation comp) {
        CodeAttr code = comp.getCode();
        if (this.field == null && this.getFlag(2048) && this.value instanceof LambdaExp) {
            LambdaExp lambda = (LambdaExp)this.value;
            lambda.flags |= 0x100;
            lambda.compileAsMethod(comp);
            comp.topLambda.addApplyMethod(lambda);
            this.makeField(comp, this.value);
        }
        if (this.field != null) {
            if (!this.field.getStaticFlag()) {
                this.loadOwningObject(comp);
                code.emitGetField(this.field);
            } else {
                code.emitGetStatic(this.field);
            }
        } else {
            ClassExp cl;
            Variable var = this.getVariable();
            if (this.context instanceof ClassExp && var == null && !this.getFlag(128) && (cl = (ClassExp)this.context).isMakingClassPair()) {
                String getName = ClassExp.slotToMethodName("get", this.getName());
                Method getter = cl.type.getDeclaredMethod(getName, 0);
                cl.loadHeapFrame(comp);
                code.emitInvoke(getter);
                return;
            }
            if (var == null) {
                var = this.allocateVariable(code);
            }
            code.emitLoad(var);
        }
    }

    public void compileStore(Compilation comp) {
        CodeAttr code = comp.getCode();
        if (this.isSimple()) {
            code.emitStore(this.getVariable());
        } else if (!this.field.getStaticFlag()) {
            this.loadOwningObject(comp);
            code.emitSwap();
            code.emitPutField(this.field);
        } else {
            code.emitPutStatic(this.field);
        }
    }

    public final Expression getValue() {
        return this.value;
    }

    public final Object getConstantValue() {
        if (!(this.value instanceof QuoteExp)) {
            return null;
        }
        return ((QuoteExp)this.value).getValue();
    }

    public final boolean getFlag(int flag) {
        return (this.flags & flag) != 0;
    }

    public final void setFlag(boolean setting, int flag) {
        this.flags = setting ? (this.flags |= flag) : (this.flags &= ~flag);
    }

    public final void setFlag(int flag) {
        this.flags |= flag;
    }

    public final boolean isPublic() {
        return this.context instanceof ModuleExp && (this.flags & 0x20) == 0;
    }

    public final boolean isPrivate() {
        return (this.flags & 0x20) != 0;
    }

    public final void setPrivate(boolean isPrivate) {
        this.setFlag(isPrivate, 32);
    }

    public final boolean isSpecifiedPrivate() {
        return (this.flags & 0x20000) != 0;
    }

    public final void setSpecifiedPrivate(boolean isPrivate) {
        this.setFlag(isPrivate, 131072);
    }

    public final boolean isAlias() {
        return (this.flags & 0x100) != 0;
    }

    public final void setAlias(boolean flag) {
        this.setFlag(flag, 256);
    }

    public final boolean isFluid() {
        return (this.flags & 0x10) != 0;
    }

    public final void setFluid(boolean fluid) {
        this.setFlag(fluid, 16);
    }

    public final boolean isProcedureDecl() {
        return (this.flags & 0x80) != 0;
    }

    public final void setProcedureDecl(boolean val) {
        this.setFlag(val, 128);
    }

    public final boolean isIndirectBinding() {
        return (this.flags & 1) != 0;
    }

    public final void setIndirectBinding(boolean indirectBinding) {
        this.setFlag(indirectBinding, 1);
    }

    public final boolean getCanRead() {
        return (this.flags & 2) != 0;
    }

    public final void setCanRead(boolean read) {
        this.setFlag(read, 2);
    }

    public final void setCanRead() {
        this.setFlag(true, 2);
        if (this.base != null) {
            this.base.setCanRead();
        }
    }

    public final boolean getCanCall() {
        return (this.flags & 4) != 0;
    }

    public final void setCanCall(boolean called) {
        this.setFlag(called, 4);
    }

    public final void setCanCall() {
        this.setFlag(true, 4);
        if (this.base != null) {
            this.base.setCanRead();
        }
    }

    public final boolean getCanWrite() {
        return (this.flags & 8) != 0;
    }

    public final void setCanWrite(boolean written) {
        this.flags = written ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public final void setCanWrite() {
        this.flags |= 8;
        if (this.base != null) {
            this.base.setCanRead();
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean ignorable() {
        if (this.getCanRead() || this.isPublic()) {
            return false;
        }
        if (this.getCanWrite() && this.getFlag(65536)) {
            return false;
        }
        if (!this.getCanCall()) {
            return true;
        }
        Expression value = this.getValue();
        if (value == null || !(value instanceof LambdaExp)) {
            return false;
        }
        LambdaExp lexp = (LambdaExp)value;
        return !lexp.isHandlingTailCalls() || lexp.getInlineOnly();
    }

    public boolean needsInit() {
        return !this.getFlag(0x200000) && !this.ignorable() && (this.value != QuoteExp.nullExp || this.base == null);
    }

    public boolean isStatic() {
        return this.getFlag(2048) || this.context instanceof ModuleExp && ((ModuleExp)this.context).isStatic();
    }

    public final boolean isLexical() {
        return !this.isFluid() && !this.isStatic();
    }

    public void noteValue(Expression value) {
        if (this.value == QuoteExp.undefined_exp) {
            if (value instanceof LambdaExp) {
                ((LambdaExp)value).nameDecl = this;
            }
            this.value = value;
        } else if (this.value != value) {
            if (this.value instanceof LambdaExp) {
                ((LambdaExp)this.value).nameDecl = null;
            }
            this.value = null;
        }
    }

    protected Declaration() {
    }

    public Declaration(String name) {
        this(name, Type.pointer_type);
    }

    public Declaration(String s, Type type) {
        this.name = s;
        this.setType(type);
    }

    public Declaration(String name, Field field) {
        this.name = name;
        this.setType(field.getType());
        this.field = field;
        this.setSimple(false);
    }

    public void pushIndirectBinding(Compilation comp) {
        CodeAttr code = comp.getCode();
        code.emitPushString(this.getName());
        if (this.makeBindingMethod == null) {
            Type[] args = new Type[]{Type.pointer_type, Type.string_type};
            this.makeBindingMethod = Compilation.typeBinding.addMethod("make", args, Compilation.typeBinding, 9);
        }
        code.emitInvokeStatic(this.makeBindingMethod);
    }

    public final Variable allocateVariable(CodeAttr code) {
        if (!this.isSimple()) {
            return null;
        }
        if (this.var == null) {
            String vname = null;
            if (this.name != null) {
                vname = Compilation.mangleName(this.getName());
            }
            if (this.isAlias() && this.getValue() instanceof ReferenceExp) {
                Declaration base = Declaration.followAliases(this);
                this.var = base == null ? null : base.var;
            } else {
                Type type = this.isIndirectBinding() ? Compilation.typeLocation : this.getType();
                this.var = this.context.scope.addVariable(code, type, vname);
            }
        }
        return this.var;
    }

    public void initBinding(Compilation comp) {
        if (this.isIndirectBinding()) {
            this.pushIndirectBinding(comp);
            CodeAttr code = comp.getCode();
            code.emitStore(this.getVariable());
        } else {
            this.compileStore(comp);
        }
    }

    public final void setFile(String filename) {
        this.filename = filename;
    }

    public final void setLine(int lineno, int colno) {
        this.position = (lineno << 12) + colno;
    }

    public final void setLine(int lineno) {
        this.setLine(lineno, 0);
    }

    public final String getFile() {
        return this.filename;
    }

    public final int getLine() {
        return this.position >> 12;
    }

    public final int getColumn() {
        return this.position & 0xFFF;
    }

    public String toString() {
        return "Declaration[" + this.getName() + '/' + this.id + ']';
    }

    public static Declaration followAliases(Declaration decl) {
        while (decl != null && decl.isAlias()) {
            Expression declValue = decl.getValue();
            if (!(declValue instanceof ReferenceExp)) break;
            ReferenceExp rexp = (ReferenceExp)declValue;
            if (rexp.binding == null) break;
            decl = rexp.binding;
        }
        return decl;
    }

    public void makeField(Compilation comp, Expression value) {
        this.setSimple(false);
        String fname = this.getName();
        if (this.getFlag(65536)) {
            fname = "id$" + fname;
        }
        fname = Compilation.mangleNameIfNeeded(fname);
        int fflags = 0;
        boolean isConstant = this.getFlag(16384);
        boolean typeSpecified = this.getFlag(8192);
        if (this.isPublic() && !isConstant && !typeSpecified) {
            this.setIndirectBinding(true);
        }
        if (this.isIndirectBinding() || isConstant) {
            fflags |= 0x10;
        }
        if (!this.isPrivate()) {
            fflags |= 1;
        }
        if (this.getFlag(2048) || isConstant && value instanceof QuoteExp) {
            fflags |= 8;
        }
        if (this.getFlag(65536)) {
            fflags |= 8;
            if (!(this.context instanceof ModuleExp) || !((ModuleExp)this.context).isStatic()) {
                fflags &= 0xFFFFFFEF;
            }
        }
        ClassType ftype = this.isIndirectBinding() ? Compilation.typeBinding : (value == null || typeSpecified ? this.getType() : value.getType());
        this.field = comp.topClass.addField(fname, ftype, fflags);
        this.setFieldValue(comp);
    }

    void setFieldValue(Compilation comp) {
        Object val;
        Type ftype = this.field.getType();
        if (this.value instanceof QuoteExp && (val = ((QuoteExp)this.value).getValue()) != null && val.getClass().getName().equals(ftype.getName())) {
            Literal literal = comp.findLiteral(val);
            if (literal.field == null) {
                literal.assign(this.field, comp);
            }
        }
        if (this.value instanceof QuoteExp && (ftype instanceof PrimType || "java.lang.String".equals(ftype.getName()))) {
            val = ((QuoteExp)this.value).getValue();
            if (val != null) {
                this.field.setConstantValue(val, this.field.getDeclaringClass());
            }
        } else if ((this.isIndirectBinding() || this.value != null) && !this.getFlag(65536)) {
            BindingInitializer init = new BindingInitializer(this, this.field, this.value);
            if (this.field.getStaticFlag()) {
                init.next = comp.topLambda.clinitChain;
                comp.topLambda.clinitChain = init;
            } else {
                init.next = comp.mainLambda.initChain;
                comp.mainLambda.initChain = init;
            }
        }
    }

    public static Declaration getDeclaration(Named proc) {
        return Declaration.getDeclaration(proc, proc.getName());
    }

    public static Declaration getDeclaration(Object proc, String name) {
        int fflags;
        String fname;
        ClassType procType;
        Field procField;
        Class procClass;
        if (name != null && (procClass = PrimProcedure.getProcedureClass(proc)) != null && (procField = (procType = (ClassType)Type.make(procClass)).getDeclaredField(fname = Compilation.mangleName(name))) != null && ((fflags = procField.getModifiers()) & 8) != 0) {
            Declaration decl = new Declaration(name, procField);
            decl.noteValue(new QuoteExp(proc));
            if ((fflags & 0x10) != 0) {
                decl.setFlag(16384);
            }
            return decl;
        }
        return null;
    }
}

