/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.expr.ClassExp;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.LambdaExp;
import gnu.expr.ModuleExp;
import gnu.expr.Parser;

public abstract class ScopeExp
extends Expression {
    Declaration decls;
    Declaration last;
    Scope scope = new Scope();
    public ScopeExp outer;

    public final Declaration firstDecl() {
        return this.decls;
    }

    public void add(Declaration decl) {
        if (this.last == null) {
            this.decls = decl;
        } else {
            this.last.next = decl;
        }
        this.last = decl;
        decl.context = this;
    }

    public void add(Declaration prev, Declaration decl) {
        if (prev == null) {
            decl.next = this.decls;
            this.decls = decl;
        } else {
            decl.next = prev.next;
            prev.next = decl;
        }
        if (this.last == prev) {
            this.last = decl;
        }
        decl.context = this;
    }

    public void remove(Declaration decl) {
        Declaration prev = null;
        Declaration cur = this.firstDecl();
        while (cur != null) {
            if (cur == decl) {
                this.remove(prev, decl);
                return;
            }
            prev = decl;
            cur = cur.nextDecl();
        }
    }

    public void remove(Declaration prev, Declaration decl) {
        if (prev == null) {
            this.decls = decl.next;
        } else {
            prev.next = decl.next;
        }
        if (this.last == decl) {
            this.last = prev;
        }
    }

    public LambdaExp currentLambda() {
        ScopeExp exp = this;
        while (exp != null) {
            if (exp instanceof LambdaExp) {
                return (LambdaExp)exp;
            }
            exp = exp.outer;
        }
        return null;
    }

    public ClassExp currentClass() {
        ScopeExp exp = this;
        while (exp != null) {
            if (exp instanceof ClassExp) {
                return (ClassExp)exp;
            }
            exp = exp.outer;
        }
        return null;
    }

    public ModuleExp currentModule() {
        ScopeExp exp = this;
        while (exp != null) {
            if (exp instanceof ModuleExp) {
                return (ModuleExp)exp;
            }
            exp = exp.outer;
        }
        return null;
    }

    public Declaration lookup(String sym) {
        Declaration decl = this.firstDecl();
        while (decl != null) {
            if (decl.name == sym) {
                return decl;
            }
            decl = decl.nextDecl();
        }
        return null;
    }

    public Declaration lookup(String sym, Interpreter interp, int namespace) {
        Declaration decl = this.firstDecl();
        while (decl != null) {
            if (decl.name == sym && (interp.getNamespaceOf(decl) & namespace) != 0) {
                return decl;
            }
            decl = decl.nextDecl();
        }
        return null;
    }

    public Declaration getNoDefine(String name) {
        Declaration decl = this.lookup(name);
        if (decl == null) {
            decl = this.addDeclaration(name);
            decl.setFlag(512);
        }
        return decl;
    }

    public Declaration getDefine(String name, char severity, Parser parser) {
        Declaration decl = this.lookup(name);
        if (decl == null) {
            decl = this.addDeclaration(name);
        } else if (decl.getFlag(512)) {
            decl.setFlag(false, 512);
        } else if (decl.getFlag(65536)) {
            decl.setFlag(false, 65536);
        } else {
            StringBuffer sbuf = new StringBuffer(200);
            sbuf.append("duplicate definition for '");
            sbuf.append(name);
            int oldLine = decl.getLine();
            if (oldLine <= 0) {
                sbuf.append('\'');
            } else {
                sbuf.append("' (overrides ");
                String oldFile = decl.getFile();
                if (oldFile == null || oldFile.equals(parser.getFile())) {
                    sbuf.append("line ");
                } else {
                    sbuf.append(oldFile);
                    sbuf.append(':');
                }
                sbuf.append(oldLine);
                int oldColumn = decl.getColumn();
                if (oldColumn > 0) {
                    sbuf.append(':');
                    sbuf.append(oldColumn);
                }
                sbuf.append(')');
            }
            parser.error(severity, sbuf.toString());
            decl = this.addDeclaration(name);
        }
        return decl;
    }

    public final Declaration addDeclaration(String name) {
        Declaration decl = new Declaration(name);
        this.addDeclaration(decl);
        return decl;
    }

    public final Declaration addDeclaration(String name, Type type) {
        Declaration decl = new Declaration(name);
        this.addDeclaration(decl);
        decl.setType(type);
        return decl;
    }

    public final void addDeclaration(Declaration decl) {
        this.add(decl);
    }

    public int countDecls() {
        int n = 0;
        Declaration decl = this.firstDecl();
        while (decl != null) {
            ++n;
            decl = decl.nextDecl();
        }
        return n;
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkScopeExp(this);
    }
}

