/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Type;
import gnu.expr.CatchClause;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;

public class TryExp
extends Expression {
    Expression try_clause;
    CatchClause catch_clauses;
    Expression finally_clause;

    public final CatchClause getCatchClauses() {
        return this.catch_clauses;
    }

    public final void setCatchClauses(CatchClause catch_clauses) {
        this.catch_clauses = catch_clauses;
    }

    public TryExp(Expression try_clause, Expression finally_clause) {
        this.try_clause = try_clause;
        this.finally_clause = finally_clause;
    }

    public Object eval(Environment env) throws Throwable {
        Object object;
        if (this.catch_clauses != null) {
            throw new RuntimeException("internal error - TryExp.eval called");
        }
        try {
            object = this.try_clause.eval(env);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.finally_clause.eval(env);
            throw throwable;
        }
        this.finally_clause.eval(env);
        return object;
    }

    public void compile(Compilation comp, Target target) {
        Type result_type;
        CodeAttr code = comp.getCode();
        boolean has_finally = this.finally_clause != null;
        Type type = result_type = target instanceof IgnoreTarget ? null : this.getType();
        Target ttarg = result_type == null ? Target.Ignore : (result_type == Type.pointer_type ? Target.pushObject : new StackTarget(result_type));
        code.emitTryStart(has_finally, result_type);
        this.try_clause.compileWithPosition(comp, ttarg);
        code.emitTryEnd();
        CatchClause catch_clause = this.catch_clauses;
        while (catch_clause != null) {
            catch_clause.compile(comp, ttarg);
            catch_clause = catch_clause.getNext();
        }
        if (this.finally_clause != null) {
            code.emitFinallyStart();
            this.finally_clause.compileWithPosition(comp, Target.Ignore);
            code.emitFinallyEnd();
        }
        code.emitTryCatchEnd();
        if (result_type != null) {
            target.compileFromStack(comp, result_type);
        }
    }

    protected Expression walk(ExpWalker walker) {
        return walker.walkTryExp(this);
    }

    protected void walkChildren(ExpWalker walker) {
        this.try_clause = this.try_clause.walk(walker);
        CatchClause catch_clause = this.catch_clauses;
        while (walker.exitValue == null && catch_clause != null) {
            catch_clause.walk(walker);
            catch_clause = catch_clause.getNext();
        }
        if (walker.exitValue == null && this.finally_clause != null) {
            this.finally_clause = this.finally_clause.walk(walker);
        }
    }

    public void print(OutPort ps) {
        ps.print("(Try ");
        this.try_clause.print(ps);
        CatchClause catch_clause = this.catch_clauses;
        while (catch_clause != null) {
            catch_clause.print(ps);
            catch_clause = catch_clause.getNext();
        }
        if (this.finally_clause != null) {
            ps.print(" finally: ");
            this.finally_clause.print(ps);
        }
        ps.print(")");
    }

    public final Type getType() {
        return Type.void_type;
    }
}

