/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.Consumer;
import gnu.lists.Pair;
import gnu.lists.PositionContainer;
import gnu.lists.Sequence;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.Enumeration;

public class LList
extends AbstractSequence
implements Sequence,
Externalizable {
    public static final LList Empty = new LList();

    public static int listLength(Object obj, boolean allowOtherSequence) {
        int n = 0;
        Object slow = obj;
        Object fast = obj;
        while (fast != Empty) {
            if (!(fast instanceof Pair)) {
                if (fast instanceof Sequence && allowOtherSequence) {
                    int j = ((Sequence)fast).size();
                    return j >= 0 ? n + j : j;
                }
                return -2;
            }
            Pair fast_pair = (Pair)fast;
            if (fast_pair.cdr == Empty) {
                return n + 1;
            }
            if (fast == slow && n > 0) {
                return -1;
            }
            if (!(fast_pair.cdr instanceof Pair)) {
                ++n;
                fast = fast_pair.cdr;
                continue;
            }
            if (!(slow instanceof Pair)) {
                return -2;
            }
            slow = ((Pair)slow).cdr;
            fast = ((Pair)fast_pair.cdr).cdr;
            n += 2;
        }
        return n;
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void makePosition(int index, boolean isAfter, PositionContainer poses, int positionNumber) {
        block1: {
            ipos = index << 1 | (isAfter != false ? 1 : 0);
            p = this;
            skip = index;
            skip = isAfter ? (skip -= 2) : --skip;
            if (skip >= 0) ** GOTO lbl9
            p = null;
            break block1;
lbl-1000:
            // 1 sources

            {
                p = ((Pair)p).cdr;
lbl9:
                // 2 sources

                ** while (--skip >= 0)
            }
        }
        poses.setPosition(positionNumber, ipos, p);
        poses.setSequence(positionNumber, this);
    }

    protected int nextIndex(int ipos, Object xpos) {
        return ipos >>> 1;
    }

    protected boolean hasNext(int ipos, Object xpos) {
        if (xpos == null) {
            if (ipos >> 1 == 0) {
                return this != Empty;
            }
            return ((Pair)this).cdr != Empty;
        }
        Object next = ((Pair)xpos).cdr;
        if ((ipos & 1) > 0) {
            next = ((Pair)next).cdr;
        }
        return next != Empty;
    }

    public Object getNext(int ipos, Object xpos) {
        Object next;
        int isAfter = ipos & 1;
        if (isAfter > 0) {
            if (xpos == null) {
                next = this;
                if (ipos >> 1 != 0) {
                    next = ((Pair)next).cdr;
                }
            } else {
                next = ((Pair)((Pair)xpos).cdr).cdr;
            }
        } else {
            next = xpos == null ? this : xpos;
        }
        if (next == Empty) {
            return Sequence.eofValue;
        }
        return ((Pair)next).car;
    }

    public Object get(int index) {
        throw new ArrayIndexOutOfBoundsException(index);
    }

    public static final int length(Object arg) {
        int count = 0;
        while (arg instanceof Pair) {
            ++count;
            arg = ((Pair)arg).cdr;
        }
        return count;
    }

    protected boolean isAfter(int ipos, Object xpos) {
        return (ipos & 1) != 0;
    }

    public boolean gotoNext(PositionContainer posSet, int posNumber) {
        boolean isAfter;
        int ipos = posSet.getPositionInt(posNumber);
        Object xpos = posSet.getPositionPtr(posNumber);
        boolean bl = isAfter = (ipos & 1) != 0;
        if (xpos != null) {
            if (isAfter) {
                xpos = ((Pair)xpos).cdr;
            }
            if (((Pair)xpos).cdr == Empty) {
                return false;
            }
            ipos = (ipos | 1) + 2;
        } else if (ipos >> 1 == 0) {
            if (this == Empty) {
                return false;
            }
            ipos = 3;
        } else {
            xpos = this;
            if (((Pair)xpos).cdr == Empty) {
                return false;
            }
            ipos = 5;
        }
        posSet.setPosition(posNumber, ipos, xpos);
        return true;
    }

    public static LList makeList(Sequence vals) {
        Enumeration e = ((AbstractSequence)((Object)vals)).elements();
        LList result = Empty;
        Pair last = null;
        int i = 0;
        while (e.hasMoreElements()) {
            Pair pair = new Pair(e.nextElement(), Empty);
            if (last == null) {
                result = pair;
            } else {
                last.cdr = pair;
            }
            last = pair;
            ++i;
        }
        return result;
    }

    public static LList makeList(Object[] vals, int offset, int length) {
        LList result = Empty;
        int i = length;
        while (--i >= 0) {
            result = new Pair(vals[offset + i], result);
        }
        return result;
    }

    public static LList makeList(Object[] vals, int offset) {
        LList result = Empty;
        int i = vals.length - offset;
        while (--i >= 0) {
            result = new Pair(vals[offset + i], result);
        }
        return result;
    }

    public void consume(Consumer out) {
        String typeName;
        Object list = this;
        String type = typeName = "list";
        out.beginGroup(typeName, type);
        while (list instanceof Pair) {
            if (list != this) {
                out.writeChar(32);
            }
            Pair pair = (Pair)list;
            out.writeObject(pair.car);
            list = pair.cdr;
        }
        if (list != Empty) {
            out.writeChar(32);
            out.writeChars(". ");
            out.writeObject(list);
        }
        out.endGroup(typeName);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
    }

    public Object readResolve() throws ObjectStreamException {
        return Empty;
    }

    public static Pair list1(Object arg1) {
        return new Pair(arg1, Empty);
    }

    public static Pair list2(Object arg1, Object arg2) {
        return new Pair(arg1, new Pair(arg2, Empty));
    }

    public static Pair list3(Object arg1, Object arg2, Object arg3) {
        return new Pair(arg1, new Pair(arg2, new Pair(arg3, Empty)));
    }

    public static Pair list4(Object arg1, Object arg2, Object arg3, Object arg4) {
        return new Pair(arg1, new Pair(arg2, new Pair(arg3, new Pair(arg4, Empty))));
    }

    public static Pair chain1(Pair old, Object arg1) {
        Pair p1 = new Pair(arg1, Empty);
        old.cdr = p1;
        return p1;
    }

    public static Pair chain4(Pair old, Object arg1, Object arg2, Object arg3, Object arg4) {
        Pair p4 = new Pair(arg4, Empty);
        old.cdr = new Pair(arg1, new Pair(arg2, new Pair(arg3, p4)));
        return p4;
    }

    public static LList reverseInPlace(Object list) {
        LList prev = Empty;
        while (list != Empty) {
            Pair pair = (Pair)list;
            list = pair.cdr;
            pair.cdr = prev;
            prev = pair;
        }
        return prev;
    }

    public static Object listTail(Object list, int count) {
        while (--count >= 0) {
            if (!(list instanceof Pair)) {
                throw new IndexOutOfBoundsException("List is too short.");
            }
            Pair pair = (Pair)list;
            list = pair.cdr;
        }
        return list;
    }
}

