/*
 * Decompiled with CFR 0.152.
 */
package gnu.lists;

import gnu.lists.AbstractSequence;
import gnu.lists.SeqPosition;

public class TreePosition
extends SeqPosition
implements Cloneable {
    AbstractSequence[] sstack;
    int[] istack;
    Object[] xstack;
    int depth;

    public TreePosition() {
        this.depth = -1;
    }

    public TreePosition(Object root) {
        this.xpos = root;
        this.depth = -1;
    }

    public TreePosition(AbstractSequence seq, int index) {
        seq.makePosition(index, false, this, 0);
    }

    public TreePosition(TreePosition pos) {
        this.set(pos);
    }

    public Object clone() {
        return new TreePosition(this);
    }

    public void set(TreePosition position) {
        AbstractSequence seq;
        int d;
        this.clear();
        this.depth = d = position.depth;
        if (d < 0) {
            this.xpos = position.xpos;
            return;
        }
        if (this.sstack == null || this.sstack.length <= d) {
            this.sstack = new AbstractSequence[d + 10];
        }
        if (this.istack == null || this.istack.length <= d) {
            this.istack = new int[d + 10];
        }
        if (this.xstack == null || this.xstack.length <= d) {
            this.xstack = new Object[d + 10];
        }
        int i = 0;
        while (i < this.depth) {
            seq = position.sstack[i];
            seq.copyPosition(position.istack[i], position.xstack[i], this, this.depth - i);
            ++i;
        }
        seq = position.sequence;
        seq.copyPosition(position.ipos, position.xpos, this, 0);
    }

    public int getDepth() {
        return this.depth + 1;
    }

    public AbstractSequence getRoot() {
        return this.depth == 0 ? this.sequence : this.sstack[0];
    }

    public Object getNext() {
        return this.sequence == null ? this.xpos : this.sequence.getNext(this.ipos, this.xpos);
    }

    public void push(AbstractSequence child, int iposChild, Object xposChild) {
        if (this.depth >= 0) {
            if (this.depth == 0) {
                this.istack = new int[8];
                this.xstack = new Object[8];
                this.sstack = new AbstractSequence[8];
            } else if (this.depth >= this.istack.length) {
                int ndepth = 2 * this.depth;
                int[] itemp = new int[ndepth];
                Object[] xtemp = new Object[ndepth];
                AbstractSequence[] stemp = new AbstractSequence[ndepth];
                System.arraycopy(this.istack, 0, itemp, 0, this.depth);
                System.arraycopy(this.xstack, 0, xtemp, 0, this.depth);
                System.arraycopy(this.sstack, 0, stemp, 0, this.depth);
                this.istack = itemp;
                this.xstack = xtemp;
                this.sstack = stemp;
            }
            this.sstack[this.depth] = this.sequence;
            this.istack[this.depth] = this.ipos;
            this.xstack[this.depth] = this.xpos;
        }
        ++this.depth;
        this.sequence = child;
        this.ipos = iposChild;
        this.xpos = xposChild;
    }

    public void pop() {
        this.sequence.releasePosition(this.ipos, this.xpos);
        this.popNoRelease();
    }

    public void popNoRelease() {
        if (--this.depth < 0) {
            this.xpos = this.sequence;
            this.sequence = null;
        } else {
            this.sequence = this.sstack[this.depth];
            this.ipos = this.istack[this.depth];
            this.xpos = this.xstack[this.depth];
        }
    }

    public final boolean gotoParent() {
        return this.sequence == null ? false : this.sequence.gotoParent(this);
    }

    public boolean gotoChildrenStart() {
        if (this.sequence == null) {
            if (!(this.xpos instanceof AbstractSequence)) {
                return false;
            }
            this.depth = 0;
            this.sequence = (AbstractSequence)this.xpos;
            this.sequence.makeStartPosition(this, 0);
        } else if (!this.sequence.gotoChildrenStart(this)) {
            return false;
        }
        return true;
    }

    public boolean gotoAttributesStart() {
        if (this.sequence == null) {
            if (this.xpos instanceof AbstractSequence) {
                // empty if block
            }
            return false;
        }
        return this.sequence.gotoAttributesStart(this);
    }

    public Object getAncestor(int up) {
        if (up == 0) {
            return this.sequence.getNext(this.ipos, this.xpos);
        }
        int i = this.depth - up;
        if (i <= 0) {
            return this.getRoot();
        }
        return this.sstack[i].getNext(this.istack[i], this.xstack[i]);
    }

    public void finalize() {
        this.clear();
    }

    public void clear() {
        while (this.sequence != null) {
            this.sequence.releasePosition(this.ipos, this.xpos);
            this.pop();
        }
        this.xpos = null;
    }

    public int getPositionInt(int positionNumber) {
        return positionNumber == 0 ? this.ipos : this.istack[this.depth - positionNumber];
    }

    public Object getPositionPtr(int positionNumber) {
        return positionNumber == 0 ? this.xpos : this.xstack[this.depth - positionNumber];
    }

    public void setPosition(int positionNumber, int ipos, Object xpos) {
        if (positionNumber == 0) {
            this.ipos = ipos;
            this.xpos = xpos;
        } else {
            this.istack[this.depth - positionNumber] = ipos;
            this.xstack[this.depth - positionNumber] = xpos;
        }
    }

    public void setSequence(int positionNumber, AbstractSequence seq) {
        if (positionNumber == 0) {
            this.sequence = seq;
        } else {
            this.sstack[this.depth - positionNumber] = seq;
        }
    }

    public int countPositions() {
        return this.depth + 1;
    }

    public void dump() {
        System.err.println("TreePosition dump depth:" + this.depth);
        if (this.depth < 0) {
            System.err.println("#- xpos:" + this.getPositionPtr(0));
        }
        int i = 0;
        while (i <= this.depth) {
            AbstractSequence seq = i == 0 ? this.sequence : this.sstack[this.depth - i];
            System.err.print("#" + i + " seq:" + seq);
            System.err.println(" ipos:" + this.getPositionInt(i) + " xpos:" + this.getPositionPtr(i));
            ++i;
        }
    }
}

