/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import mlsub.typing.AtomicConstraint;
import mlsub.typing.TypeSymbol;
import mlsub.typing.Typing;
import mlsub.typing.TypingEx;

public final class Constraint {
    public static final Constraint True = null;
    private TypeSymbol[] binders;
    private int nbinders;
    private AtomicConstraint[] atoms;
    private int natoms;

    public Constraint(TypeSymbol[] binders, AtomicConstraint[] atoms) {
        this.binders = binders;
        if (binders != null) {
            this.nbinders = binders.length;
        }
        this.atoms = atoms;
        if (atoms != null) {
            this.natoms = atoms.length;
        }
    }

    public static final Constraint create(TypeSymbol[] binders, AtomicConstraint[] atoms) {
        if (binders == null && atoms == null) {
            return True;
        }
        if (binders != null && binders.length == 0) {
            throw new Error("Please optimize");
        }
        if (atoms != null && atoms.length == 0) {
            throw new Error("Please optimize");
        }
        return new Constraint(binders, atoms);
    }

    private Constraint() {
    }

    public static final boolean hasBinders(Constraint c) {
        return c != null && c.binders != null;
    }

    public TypeSymbol[] binders() {
        return this.binders;
    }

    public AtomicConstraint[] atoms() {
        return this.atoms;
    }

    public static Constraint and(Constraint c1, Constraint c2) {
        int i;
        int i2;
        int natoms2;
        int nbinders1 = c1 == null ? 0 : c1.nbinders;
        int nbinders2 = c2 == null ? 0 : c2.nbinders;
        int natoms1 = c1 == null ? 0 : c1.natoms;
        int n = natoms2 = c2 == null ? 0 : c2.natoms;
        if (nbinders1 == 0 && nbinders2 == 0 && natoms1 == 0 && natoms2 == 0) {
            return True;
        }
        Constraint res = new Constraint();
        res.nbinders = nbinders1 + nbinders2;
        res.natoms = natoms1 + natoms2;
        if (res.nbinders > 0) {
            res.binders = new TypeSymbol[res.nbinders];
            i2 = 0;
            while (i2 < nbinders1) {
                res.binders[i2] = c1.binders[i2];
                ++i2;
            }
            i = 0;
            while (i < nbinders2) {
                res.binders[nbinders1 + i] = c2.binders[i];
                ++i;
            }
        }
        if (res.natoms > 0) {
            res.atoms = new AtomicConstraint[res.natoms];
            i2 = 0;
            while (i2 < natoms1) {
                res.atoms[i2] = c1.atoms[i2];
                ++i2;
            }
            i = 0;
            while (i < natoms2) {
                res.atoms[natoms1 + i] = c2.atoms[i];
                ++i;
            }
        }
        return res;
    }

    public static Constraint and(Constraint c1, TypeSymbol t0, TypeSymbol t1, AtomicConstraint a1, AtomicConstraint a2) {
        int nbinders = (c1 == null ? 0 : c1.nbinders) + 2;
        int natoms = (c1 == null ? 0 : c1.natoms) + 2;
        Constraint res = new Constraint();
        res.nbinders = nbinders;
        res.natoms = natoms;
        res.binders = new TypeSymbol[nbinders];
        int i = 0;
        while (i < nbinders - 2) {
            res.binders[i] = c1.binders[i];
            ++i;
        }
        res.binders[nbinders - 2] = t0;
        res.binders[nbinders - 1] = t1;
        res.atoms = new AtomicConstraint[res.natoms];
        int i2 = 0;
        while (i2 < natoms - 2) {
            res.atoms[i2] = c1.atoms[i2];
            ++i2;
        }
        res.atoms[natoms - 2] = a2;
        res.atoms[natoms - 1] = a1;
        return res;
    }

    static Constraint and(TypeSymbol m, Constraint c1, Constraint c2, AtomicConstraint a1, AtomicConstraint a2) {
        Constraint res = new Constraint();
        int nbinders1 = c1 == null ? 0 : c1.nbinders;
        int nbinders2 = c2 == null ? 0 : c2.nbinders;
        int natoms1 = c1 == null ? 0 : c1.natoms;
        int natoms2 = c2 == null ? 0 : c2.natoms;
        res.nbinders = nbinders1 + nbinders2 + 1;
        res.binders = new TypeSymbol[res.nbinders];
        int i = 0;
        while (i < nbinders1) {
            res.binders[i] = c1.binders[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < nbinders2) {
            res.binders[nbinders1 + i2] = c2.binders[i2];
            ++i2;
        }
        res.binders[res.nbinders - 1] = m;
        res.natoms = natoms1 + natoms2 + 2;
        res.atoms = new AtomicConstraint[res.natoms];
        int i3 = 0;
        while (i3 < natoms1) {
            res.atoms[i3] = c1.atoms[i3];
            ++i3;
        }
        int i4 = 0;
        while (i4 < natoms2) {
            res.atoms[natoms1 + i4] = c2.atoms[i4];
            ++i4;
        }
        res.atoms[res.natoms - 2] = a2;
        res.atoms[res.natoms - 1] = a1;
        return res;
    }

    static Constraint and(Constraint c1, Constraint c2, AtomicConstraint a1) {
        Constraint res = new Constraint();
        int nbinders1 = c1 == null ? 0 : c1.nbinders;
        int nbinders2 = c2 == null ? 0 : c2.nbinders;
        int natoms1 = c1 == null ? 0 : c1.natoms;
        int natoms2 = c2 == null ? 0 : c2.natoms;
        res.nbinders = nbinders1 + nbinders2;
        res.binders = new TypeSymbol[res.nbinders];
        int i = 0;
        while (i < nbinders1) {
            res.binders[i] = c1.binders[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < nbinders2) {
            res.binders[nbinders1 + i2] = c2.binders[i2];
            ++i2;
        }
        res.natoms = natoms1 + natoms2 + 1;
        res.atoms = new AtomicConstraint[res.natoms];
        int i3 = 0;
        while (i3 < natoms1) {
            res.atoms[i3] = c1.atoms[i3];
            ++i3;
        }
        int i4 = 0;
        while (i4 < natoms2) {
            res.atoms[natoms1 + i4] = c2.atoms[i4];
            ++i4;
        }
        res.atoms[res.natoms - 1] = a1;
        return res;
    }

    public static Constraint and(Constraint[] cs, Constraint c1, Constraint c2) {
        int i;
        int i2;
        int nbinders1 = c1 == null ? 0 : c1.nbinders;
        int nbinders2 = c2 == null ? 0 : c2.nbinders;
        int natoms1 = c1 == null ? 0 : c1.natoms;
        int natoms2 = c2 == null ? 0 : c2.natoms;
        int lenBinders = nbinders1 + nbinders2;
        int lenAtoms = natoms1 + natoms2;
        int i3 = 0;
        while (i3 < cs.length) {
            Constraint c = cs[i3];
            if (c != True) {
                lenBinders += cs[i3].nbinders;
                lenAtoms += cs[i3].natoms;
            }
            ++i3;
        }
        if (lenAtoms == 0 && lenBinders == 0) {
            return True;
        }
        Constraint res = new Constraint();
        if (lenBinders > 0) {
            res.nbinders = lenBinders;
            res.binders = new TypeSymbol[lenBinders];
            i2 = 0;
            while (i2 < nbinders2) {
                res.binders[--lenBinders] = c2.binders[i2];
                ++i2;
            }
            i = 0;
            while (i < nbinders1) {
                res.binders[--lenBinders] = c1.binders[i];
                ++i;
            }
        }
        if (lenAtoms > 0) {
            res.natoms = lenAtoms;
            res.atoms = new AtomicConstraint[lenAtoms];
            i2 = 0;
            while (i2 < natoms2) {
                res.atoms[--lenAtoms] = c2.atoms[i2];
                ++i2;
            }
            i = 0;
            while (i < natoms1) {
                res.atoms[--lenAtoms] = c1.atoms[i];
                ++i;
            }
        }
        int j = 0;
        while (j < cs.length) {
            Constraint c = cs[j];
            if (c != True) {
                int i4 = 0;
                while (i4 < c.nbinders) {
                    res.binders[--lenBinders] = c.binders[i4];
                    ++i4;
                }
                int i5 = 0;
                while (i5 < c.natoms) {
                    res.atoms[--lenAtoms] = c.atoms[i5];
                    ++i5;
                }
            }
            ++j;
        }
        return res;
    }

    public static void enter(Constraint c) throws TypingEx {
        if (c != null) {
            c.enter();
        }
    }

    public void enter() throws TypingEx {
        if (this.binders != null) {
            Typing.introduceTypeSymbols(this.binders);
        }
        if (this.atoms != null) {
            int i = 0;
            while (i < this.natoms) {
                this.atoms[i].enter();
                ++i;
            }
        }
    }

    public String toString() {
        StringBuffer res = new StringBuffer("<");
        int i = 0;
        while (i < this.nbinders) {
            res.append(this.binders[i].toString());
            if (i < this.nbinders - 1) {
                res.append(", ");
            }
            ++i;
        }
        if (this.nbinders > 0 && this.natoms > 0) {
            res.append(" | ");
        }
        int i2 = 0;
        while (i2 < this.natoms) {
            res.append(String.valueOf(this.atoms[i2]));
            if (i2 < this.natoms - 1) {
                res.append(", ");
            }
            ++i2;
        }
        res.append("> ");
        return res.toString();
    }

    public static String toString(Constraint c) {
        if (c == True) {
            return "";
        }
        return c.toString();
    }
}

