/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import java.util.Map;
import mlsub.typing.Debug;
import mlsub.typing.InternalError;
import mlsub.typing.Monotype;
import mlsub.typing.NullnessKind;
import mlsub.typing.TopMonotype;
import mlsub.typing.TypeConstructor;
import mlsub.typing.TypeSymbol;
import mlsub.typing.Typing;
import mlsub.typing.lowlevel.Element;
import mlsub.typing.lowlevel.Engine;
import mlsub.typing.lowlevel.Kind;

public final class MonotypeVar
extends Monotype
implements Element,
TypeSymbol {
    private String name;
    private int id = -1;
    Kind kind;
    Kind persistentKind;
    private Monotype equivalent;
    private static int uniqueNum = 0;

    public MonotypeVar() {
    }

    public MonotypeVar(String name) {
        this.name = name;
    }

    private MonotypeVar(String name, Kind persistentKind) {
        this.name = name;
        this.setPersistentKind(persistentKind);
    }

    public String getName() {
        return this.name;
    }

    public TypeSymbol cloneTypeSymbol() {
        return new MonotypeVar(this.name, this.persistentKind);
    }

    Monotype substitute(Map map2) {
        Object newVar = map2.get(this);
        if (newVar == null) {
            return this;
        }
        return (Monotype)newVar;
    }

    public static MonotypeVar[] news(int n) {
        if (n == 0) {
            return null;
        }
        MonotypeVar[] res = new MonotypeVar[n];
        int i = 0;
        while (i < n) {
            res[i] = new MonotypeVar();
            res[i].persistentKind = NullnessKind.instance;
            ++i;
        }
        return res;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int value) {
        this.id = value;
    }

    public Kind getKind() {
        return this.kind;
    }

    public void setKind(Kind value) {
        if (this.kind != null && value != null && this.kind != value) {
            throw new InternalError("Variance already set in MonotypeVar " + this + ":\nkind was " + this.kind + ", value is " + value);
        }
        if (this.kind == value) {
            return;
        }
        this.kind = value;
        if (value == null) {
            this.equivalent = null;
            this.id = -1;
        } else {
            TypeConstructor tc;
            this.equivalent = value.freshMonotype();
            if (Typing.dbg) {
                Debug.println("Equivalence: " + this + " == " + this.equivalent);
            }
            if (this.equivalent != null && (tc = this.equivalent.head()) != null) {
                tc.name = this + "'";
            }
        }
    }

    public void resetKind(Kind value) {
        this.setKind(null);
        this.setKind(value);
    }

    public void setPersistentKind(Kind k) {
        this.persistentKind = k;
    }

    void reset() {
        if (this.persistentKind == null) {
            this.setKind(null);
        } else {
            this.equivalent = null;
            this.kind = null;
            this.setKind(this.persistentKind);
        }
    }

    public Monotype equivalent() {
        if (this.equivalent != null) {
            return this.equivalent;
        }
        return this;
    }

    public TypeConstructor head() {
        if (this.equivalent != null) {
            return this.equivalent.head();
        }
        return null;
    }

    public String toString() {
        if (this.name == null) {
            this.name = MonotypeVar.newUniqueName();
        }
        return this.name;
    }

    private static String newUniqueName() {
        return "t" + uniqueNum++;
    }

    void tag(int variance) {
        if (this.equivalent != null) {
            this.equivalent.tag(variance);
        } else if (this.kind != TopMonotype.TopKind.instance) {
            Engine.tag(this, variance);
        }
    }

    Monotype canonify() {
        if (this.equivalent != null) {
            return this.equivalent.canonify();
        }
        if (this.kind == TopMonotype.TopKind.instance) {
            return TopMonotype.instance;
        }
        return (MonotypeVar)Engine.canonify(this);
    }
}

